/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.dummy;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import org.springframework.stereotype.Service;
import org.squashtest.csp.core.bugtracker.spi.DefaultOAuth2FormValues;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.jirasync.dummy.DummyJirasyncBugtrackerConnector;
import org.squashtest.tm.plugin.jirasync.helpers.JiraHelper;
import org.squashtest.tm.service.spi.BugTrackerConnector;
import org.squashtest.tm.service.spi.BugTrackerConnectorProvider;
import org.squashtest.tm.service.spi.DefaultOAuth2ConfigurationHandler;
import org.squashtest.tm.service.spi.GenericServerOAuth2Conf;
import org.squashtest.tm.service.spi.OAuth2ConfigurationHandler;

@Service(value="jirasync.DummyJirasyncBugtrackerProvider")
public class DummyJirasyncBugtrackerProvider
implements BugTrackerConnectorProvider {
    public static final String KIND = "jira.xsquash";
    public static final String LABEL = "JIRA Dummy Connector";
    private static final String JIRA_CLOUD_OFFLINE_ACCESS_SCOPE = "offline_access";
    @Inject
    private Provider<DummyJirasyncBugtrackerConnector> provider;
    @Inject
    private Provider<JiraHelper> providerHelper;

    public String getBugTrackerKind() {
        return KIND;
    }

    public String getLabel() {
        return LABEL;
    }

    public BugTrackerConnector createConnector(BugTracker bugTracker) {
        if (bugTracker == null) {
            throw new NullPointerException("bugTracker");
        }
        DummyJirasyncBugtrackerConnector connector = (DummyJirasyncBugtrackerConnector)this.provider.get();
        connector.setBugTracker(bugTracker);
        return connector;
    }

    public OAuth2ConfigurationHandler getOAuth2ConfigurationHandler() {
        final JiraHelper jiraHelper = (JiraHelper)this.providerHelper.get();
        return new DefaultOAuth2ConfigurationHandler(){

            public void appendScope(String bugTrackerUrl, StringBuilder sb, GenericServerOAuth2Conf conf) {
                String jiraInstancetype = jiraHelper.getJiraInstanceType(bugTrackerUrl);
                if ("cloud".equalsIgnoreCase(jiraInstancetype)) {
                    sb.append("&scope=");
                    sb.append(conf.getScope()).append(" ").append(DummyJirasyncBugtrackerProvider.JIRA_CLOUD_OFFLINE_ACCESS_SCOPE);
                    sb.append("&audience=api.atlassian.com");
                    sb.append("&prompt=consent");
                } else {
                    sb.append("&scope=");
                    sb.append(conf.getScope());
                }
            }

            public DefaultOAuth2FormValues getDefaultValueForOauth2Form(String bugTrackerUrl) {
                String jiraInstancetype = jiraHelper.getJiraInstanceType(bugTrackerUrl);
                if (jiraInstancetype == null) {
                    return new DefaultOAuth2FormValues("", "", "");
                }
                if ("cloud".equalsIgnoreCase(jiraInstancetype)) {
                    return new DefaultOAuth2FormValues("https://auth.atlassian.com/authorize", "https://auth.atlassian.com/oauth/token", "read:jira-user read:jira-work write:jira-work manage:jira-configuration manage:jira-project read:sprint:jira-software read:project:jira read:issue-details:jira read:board-scope:jira-software read:jql:jira read:board-scope.admin:jira-software");
                }
                return new DefaultOAuth2FormValues(bugTrackerUrl + "/rest/oauth2/latest/authorize", bugTrackerUrl + "/rest/oauth2/latest/token", "WRITE");
            }
        };
    }
}

