/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.nio.protocol;

import java.io.IOException;
import jirasync.org.apache.http.HttpException;
import jirasync.org.apache.http.HttpRequest;
import jirasync.org.apache.http.annotation.Contract;
import jirasync.org.apache.http.annotation.ThreadingBehavior;
import jirasync.org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import jirasync.org.apache.http.nio.protocol.HttpAsyncExchange;
import jirasync.org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import jirasync.org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import jirasync.org.apache.http.protocol.HttpContext;
import jirasync.org.apache.http.protocol.HttpRequestHandler;
import jirasync.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicAsyncRequestHandler
implements HttpAsyncRequestHandler<HttpRequest> {
    private final HttpRequestHandler handler;

    public BasicAsyncRequestHandler(HttpRequestHandler handler) {
        Args.notNull(handler, "Request handler");
        this.handler = handler;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest request, HttpContext context) {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(HttpRequest request, HttpAsyncExchange httpexchange, HttpContext context) throws HttpException, IOException {
        this.handler.handle(request, httpexchange.getResponse(), context);
        httpexchange.submitResponse();
    }
}

