/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations;

import com.google.common.collect.Lists;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import jirarest.com.atlassian.jira.rest.client.api.domain.BasicProject;
import jirarest.com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import jirarest.com.atlassian.jira.rest.client.api.domain.CimIssueType;
import jirarest.com.atlassian.jira.rest.client.api.domain.CimProject;
import jirarest.com.atlassian.jira.rest.client.api.domain.IssueType;
import jirarest.com.atlassian.jira.rest.client.api.domain.Page;
import jirarest.com.sun.ws.rs.core.UriBuilder;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.exceptions.JiraProjectNotFound;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.extension.ExtendedJiraRestClient;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.extension.ExtensionClient;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.json.PageIssueTypeFieldsParser;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.JiraRestClientOperation;

public class GetProjectForCreateByKeyOrId
extends JiraRestClientOperation<CimProject> {
    private final String projectKey;
    private static final String ISSUE_TYPES_PATH_URL = "issue/createmeta/%s/issuetypes/%d";
    private static final PageIssueTypeFieldsParser PAGE_ISSUE_TYPE_FIELDS_PARSER = new PageIssueTypeFieldsParser();
    private static final long PAGE_START = 0L;
    private static final int PAGE_MAX_RESULTS = 50;

    public GetProjectForCreateByKeyOrId(ExtendedJiraRestClient client, String projectKey) {
        super(client);
        this.projectKey = projectKey;
    }

    @Override
    public CimProject doIt() {
        Iterable<BasicProject> allProjects = this.client.getProjectClient().getAllProjects().claim();
        for (BasicProject project : allProjects) {
            if (!this.projectKey.equals(project.getKey()) && !this.projectKey.equals(String.valueOf(project.getId()))) continue;
            return new CimProject(project.getSelf(), project.getKey(), project.getId(), project.getName(), null, this.retrieveIssueTypes(project.getKey(), 0L, 50));
        }
        throw new JiraProjectNotFound(this.projectKey);
    }

    private List<CimIssueType> retrieveIssueTypes(String projectKey, long start, int maxResults) {
        ExtensionClient extension = this.client.getExtensionClient();
        Page<IssueType> issueTypes = this.client.getIssueClient().getCreateIssueMetaProjectIssueTypes(projectKey, start, maxResults).claim();
        ArrayList<CimIssueType> cimIssueTypes = new ArrayList<CimIssueType>();
        for (IssueType issueType : issueTypes.getValues()) {
            Map<String, CimFieldInfo> fields = this.retrieveIssueTypeFields(issueType.getId(), projectKey, extension, 0L, 50);
            cimIssueTypes.add(this.createCimIssueType(issueType, fields));
        }
        if (!issueTypes.isLast()) {
            cimIssueTypes.addAll(this.retrieveIssueTypes(projectKey, issueTypes.getStartAt() + (long)issueTypes.getMaxResults(), issueTypes.getMaxResults()));
        }
        return cimIssueTypes;
    }

    private Map<String, CimFieldInfo> retrieveIssueTypeFields(Long issueTypeId, String projectKey, ExtensionClient extension, long start, int maxResults) {
        Page<CimFieldInfo> fields = this.doRetrieveIssueTypeFields(issueTypeId, projectKey, extension, start, maxResults);
        Map fieldsMap = Lists.newArrayList(fields.getValues()).stream().collect(Collectors.toMap(CimFieldInfo::getId, Function.identity(), (v1, v2) -> {
            throw new RuntimeException("Duplicate key for values %s and %s".formatted(v1, v2));
        }, TreeMap::new));
        if (!fields.isLast()) {
            fieldsMap.putAll(this.retrieveIssueTypeFields(issueTypeId, projectKey, extension, fields.getStartAt() + (long)fields.getMaxResults(), fields.getMaxResults()));
        }
        return fieldsMap;
    }

    private Page<CimFieldInfo> doRetrieveIssueTypeFields(Long issueTypeId, String projectKey, ExtensionClient extension, long start, int maxResults) {
        String issueTypesPath = ISSUE_TYPES_PATH_URL.formatted(projectKey, issueTypeId);
        UriBuilder uriBuilder = UriBuilder.fromUri(extension.getBaseURI()).path(issueTypesPath);
        this.addPagingParameters(uriBuilder, start, maxResults);
        return extension.getAndParse(uriBuilder.build(new Object[0]), PAGE_ISSUE_TYPE_FIELDS_PARSER).claim();
    }

    private CimIssueType createCimIssueType(IssueType issueType, Map<String, CimFieldInfo> fields) {
        return new CimIssueType(issueType.getSelf(), issueType.getId(), issueType.getName(), issueType.isSubtask(), issueType.getDescription(), issueType.getIconUri(), fields);
    }

    private void addPagingParameters(UriBuilder uriBuilder, @Nullable Long startAt, @Nullable Integer maxResults) {
        if (startAt != null) {
            uriBuilder.queryParam("startAt", startAt);
        }
        if (maxResults != null) {
            uriBuilder.queryParam("maxResults", maxResults);
        }
    }
}

