/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jirarest.internal;

public enum JiraVersion {
    JIRA_5(5, 710, 854),
    JIRA_6(6, 6001, 64028),
    JIRA_7(7, 70105, Integer.MAX_VALUE);

    public static final int CLOUD_MAJOR_VERSION_NUM = 1000;
    private final int minBuild;
    private final int maxBuild;
    private final int majorVersion;

    private JiraVersion(int majorVersion, int minBuild, int maxBuild) {
        this.minBuild = minBuild;
        this.maxBuild = maxBuild;
        this.majorVersion = majorVersion;
    }

    public boolean isInBuildRange(int buildNum) {
        return buildNum >= this.minBuild && buildNum <= this.maxBuild;
    }

    public boolean isSameMajorVersion(int majorVersion) {
        return this.majorVersion == majorVersion;
    }

    public static final boolean isCloud(int majorVersion) {
        return majorVersion == 1000;
    }

    public static final JiraVersion byMajorVersion(int majorVersion) {
        JiraVersion version = JiraVersion.getLastKnownVersion();
        if (majorVersion == 1000) {
            return version;
        }
        JiraVersion[] jiraVersionArray = JiraVersion.values();
        int n = jiraVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            JiraVersion v = jiraVersionArray[n2];
            if (v.isSameMajorVersion(majorVersion)) {
                version = v;
                break;
            }
            ++n2;
        }
        return version;
    }

    public static final JiraVersion byBuildNumber(int buildNumber) {
        JiraVersion version = JiraVersion.getLastKnownVersion();
        JiraVersion[] jiraVersionArray = JiraVersion.values();
        int n = jiraVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            JiraVersion v = jiraVersionArray[n2];
            if (v.isInBuildRange(buildNumber)) {
                version = v;
                break;
            }
            ++n2;
        }
        return version;
    }

    public static JiraVersion getLastKnownVersion() {
        JiraVersion[] allversions = JiraVersion.values();
        return allversions[allversions.length - 1];
    }
}

