/*
 * Decompiled with CFR 0.152.
 */
package jirarest.org.apache.http.impl.client.cache;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import jirarest.org.apache.http.client.cache.HttpCacheEntry;
import jirarest.org.apache.http.client.methods.HttpExecutionAware;
import jirarest.org.apache.http.client.methods.HttpRequestWrapper;
import jirarest.org.apache.http.client.protocol.HttpClientContext;
import jirarest.org.apache.http.conn.routing.HttpRoute;
import jirarest.org.apache.http.impl.client.cache.AsynchronousValidationRequest;
import jirarest.org.apache.http.impl.client.cache.CacheConfig;
import jirarest.org.apache.http.impl.client.cache.CacheKeyGenerator;
import jirarest.org.apache.http.impl.client.cache.CachingExec;
import jirarest.org.apache.http.impl.client.cache.DefaultFailureCache;
import jirarest.org.apache.http.impl.client.cache.FailureCache;
import jirarest.org.apache.http.impl.client.cache.ImmediateSchedulingStrategy;
import jirarest.org.apache.http.impl.client.cache.SchedulingStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AsynchronousValidator
implements Closeable {
    private final SchedulingStrategy schedulingStrategy;
    private final Set<String> queued;
    private final CacheKeyGenerator cacheKeyGenerator;
    private final FailureCache failureCache;
    private final Log log = LogFactory.getLog(this.getClass());

    public AsynchronousValidator(CacheConfig config) {
        this(new ImmediateSchedulingStrategy(config));
    }

    AsynchronousValidator(SchedulingStrategy schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
        this.queued = new HashSet<String>();
        this.cacheKeyGenerator = new CacheKeyGenerator();
        this.failureCache = new DefaultFailureCache();
    }

    @Override
    public void close() throws IOException {
        this.schedulingStrategy.close();
    }

    public synchronized void revalidateCacheEntry(CachingExec cachingExec, HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware, HttpCacheEntry entry) {
        String uri = this.cacheKeyGenerator.getVariantURI(context.getTargetHost(), request, entry);
        if (!this.queued.contains(uri)) {
            int consecutiveFailedAttempts = this.failureCache.getErrorCount(uri);
            AsynchronousValidationRequest revalidationRequest = new AsynchronousValidationRequest(this, cachingExec, route, request, context, execAware, entry, uri, consecutiveFailedAttempts);
            try {
                this.schedulingStrategy.schedule(revalidationRequest);
                this.queued.add(uri);
            }
            catch (RejectedExecutionException ree) {
                this.log.debug((Object)("Revalidation for [" + uri + "] not scheduled: " + ree));
            }
        }
    }

    synchronized void markComplete(String identifier) {
        this.queued.remove(identifier);
    }

    void jobSuccessful(String identifier) {
        this.failureCache.resetErrorCount(identifier);
    }

    void jobFailed(String identifier) {
        this.failureCache.increaseErrorCount(identifier);
    }

    Set<String> getScheduledIdentifiers() {
        return Collections.unmodifiableSet(this.queued);
    }
}

