/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.jira.rest.client.internal.json;

import java.net.URI;
import jirarest.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jirarest.com.atlassian.jira.rest.client.api.domain.Visibility;
import jirarest.com.atlassian.jira.rest.client.api.domain.Worklog;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirarest.com.atlassian.jira.rest.client.internal.json.VisibilityJsonParser;
import jirarest.org.codehaus.jettison.json.JSONException;
import jirarest.org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class WorklogJsonParser
implements JsonObjectParser<Worklog> {
    @Override
    public Worklog parse(JSONObject json) throws JSONException {
        URI self = JsonParseUtil.getSelfUri(json);
        URI issueUri = JsonParseUtil.parseURI(json.getString("issue"));
        BasicUser author = JsonParseUtil.parseBasicUser(json.optJSONObject("author"));
        BasicUser updateAuthor = JsonParseUtil.parseBasicUser(json.optJSONObject("updateAuthor"));
        String comment = JsonParseUtil.getOptionalString(json, "comment");
        DateTime creationDate = JsonParseUtil.parseDateTime(json, "created");
        DateTime updateDate = JsonParseUtil.parseDateTime(json, "updated");
        DateTime startDate = JsonParseUtil.parseDateTime(json, "started");
        int minutesSpent = json.getInt("minutesSpent");
        Visibility visibility = new VisibilityJsonParser().parseVisibility(json);
        return new Worklog(self, issueUri, author, updateAuthor, comment, creationDate, updateDate, startDate, minutesSpent, visibility);
    }
}

