/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.plugin.rest.jackson.model.PartyDto;
import org.squashtest.tm.plugin.rest.jackson.model.PartyDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.TeamDto;
import org.squashtest.tm.plugin.rest.jackson.model.UserDto;
import org.squashtest.tm.plugin.rest.service.RestPartyService;
import org.squashtest.tm.plugin.rest.validators.helper.PartyValidationHelper;

@Component
public class PartyPatchValidator
implements Validator {
    @Inject
    private RestPartyService restPartyService;
    @Inject
    private PartyValidationHelper partyValidationHelper;

    public boolean supports(Class<?> clazz) {
        return PartyDto.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, final Errors errors) {
        PartyDto patch = (PartyDto)target;
        this.checkIfExist(errors, patch.getId());
        PartyDtoVisitor visitor = new PartyDtoVisitor(){

            @Override
            public void visit(UserDto userDto) {
                if (userDto.getGroup() != null) {
                    PartyPatchValidator.this.partyValidationHelper.checkAndAssignValues(errors, userDto);
                }
            }

            @Override
            public void visit(TeamDto teamDto) {
            }
        };
        patch.accept(visitor);
        this.checkForbiddenPatchAttributes(errors, patch);
    }

    private void checkIfExist(Errors errors, long id) {
        Party party = this.restPartyService.getOne(id);
        if (party == null) {
            String message = "No party known for id %d".formatted(id);
            errors.rejectValue("id", "invalid id", message);
        }
    }

    private void checkForbiddenPatchAttributes(final Errors errors, PartyDto patch) {
        PartyDtoVisitor visitor = new PartyDtoVisitor(){

            @Override
            public void visit(UserDto userDto) {
                if (userDto.getTeams() != null) {
                    errors.rejectValue("teams", "non patchable attribute", "Only attributes belonging to the user itself can be modified. The attribute teams cannot be patched. Use direct url to the team entity instead");
                }
            }

            @Override
            public void visit(TeamDto teamDto) {
                if (teamDto.getMembers() != null) {
                    errors.rejectValue("members", "non patchable attribute", "Only attributes belonging to the team itself can be modified. The attribute members cannot be patched. Use direct url to the team entity instead");
                }
            }
        };
        patch.accept(visitor);
    }
}

