/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetDto;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetParamValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.repository.RestDatasetRepository;
import org.squashtest.tm.plugin.rest.validators.helper.DatasetDtoValidationHelper;
import org.squashtest.tm.service.internal.repository.DatasetDao;

@Component
public class DatasetValidator
implements Validator {
    private static final String POST_DATASET = "post-dataset";
    private static final String PATCH_DATASET = "patch-dataset";
    @Inject
    private DatasetDtoValidationHelper datasetDtoValidationHelper;
    @Inject
    private RestDatasetRepository restDatasetRepository;
    @Inject
    private DatasetDao datasetDao;

    public boolean supports(Class<?> clazz) {
        return DatasetDto.class.equals(clazz);
    }

    public void validationPostDataset(DatasetDto datasetDto, List<Parameter> listAllParamByIdTc) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)datasetDto, POST_DATASET);
        this.validate(datasetDto, (Errors)validation);
        this.validateDatasetDto(datasetDto, listAllParamByIdTc, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(datasetDto, errors, POST_DATASET);
    }

    public void validationPatchDataset(DatasetDto datasetDto, Long datasetId) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)datasetDto, PATCH_DATASET);
        this.datasetDtoValidationHelper.checkEntityExist((Errors)validation, RestType.DATASET, datasetId);
        if (datasetDto.isHasName()) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)validation, (String)"name", (String)"required", (String)"This attribute can't be empty");
            Dataset dataset = (Dataset)this.restDatasetRepository.getReferenceById(datasetId);
            if (datasetDto.getName() != null && dataset.getName().equals(datasetDto.getName())) {
                validation.rejectValue("name", "invalid value", "A Dataset with the same name already exists in the Test Case");
            }
        }
        if (datasetDto.isHasParamValue()) {
            this.validateParamValue(datasetDto, datasetId, (Errors)validation);
        }
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(datasetDto, errors, PATCH_DATASET);
    }

    public void validate(Object target, Errors errors) {
        DatasetDto datasetDto = (DatasetDto)target;
        TestCaseDto referencedTcDTo = datasetDto.getReferencedTestCase();
        if (!referencedTcDTo.getRestType().equals((Object)RestType.TEST_CASE)) {
            errors.rejectValue("_type", "invalid type", "Type test-case expected");
        } else if (referencedTcDTo.getId() == null) {
            errors.rejectValue("id", "generated value", "The test case id must not be null ");
        }
        this.datasetDtoValidationHelper.checkEntityExist(errors, RestType.TEST_CASE, referencedTcDTo.getId());
        if (datasetDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing dataset, please do a patch request to the dataset id. ");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        Dataset sameName = this.datasetDao.findByTestCaseIdAndName(referencedTcDTo.getId(), datasetDto.getName());
        if (sameName != null) {
            errors.rejectValue("name", "invalid value", "A Dataset with the same name already exists in the Test Case");
        }
    }

    public void validateDatasetDto(DatasetDto datasetDto, List<Parameter> listAllParamByIdTc, Errors errors) {
        Object msgErrors = "";
        Set<DatasetParamValueDto> listParamValueDto = datasetDto.getValueDtos();
        List listIdParamIdTcDto = listParamValueDto.stream().map(paramValueDto -> new Couple((Object)paramValueDto.getParameterId(), (Object)paramValueDto.getTestCaseId())).collect(Collectors.toList());
        List listIdParamIdTcBD = listAllParamByIdTc.stream().map(paramByIdTc -> new Couple((Object)paramByIdTc.getId(), (Object)paramByIdTc.getTestCase().getId())).collect(Collectors.toList());
        List listDifference = (List)CollectionUtils.subtract(listIdParamIdTcDto, listIdParamIdTcBD);
        for (Couple p : listDifference) {
            msgErrors = (String)msgErrors + "Test Case " + String.valueOf(p.getA2()) + " is not called by Test Case " + String.valueOf(datasetDto.getReferencedTestCase().getId()) + ", or Parameters " + String.valueOf(p.getA1()) + " of Test Case " + String.valueOf(p.getA2()) + " are not delegated\n";
        }
        if (!((String)msgErrors).isEmpty()) {
            errors.rejectValue("valueDtos", "invalid value", (String)msgErrors);
        }
    }

    public void validateParamValue(DatasetDto datasetDto, Long datasetId, Errors errors) {
        Object msgErrors = "";
        boolean isExist = true;
        Set<DatasetParamValueDto> DatasetParamValueDto2 = datasetDto.getValueDtos();
        List<DatasetParamValue> listParamValueById = this.restDatasetRepository.findParamValueByIdDataset(datasetId);
        for (DatasetParamValueDto pvDto : DatasetParamValueDto2) {
            isExist = listParamValueById.stream().anyMatch(paramValueById -> paramValueById.getParameter().getId().equals(pvDto.getParameterId()));
            if (isExist) continue;
            msgErrors = (String)msgErrors + "Dataset " + String.valueOf(datasetId) + " has no parameter " + String.valueOf(pvDto.getParameterId()) + "\n";
        }
        if (!((String)msgErrors).isEmpty()) {
            errors.rejectValue("valueDtos", "invalid value", (String)msgErrors);
        }
    }
}

