/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.plugin.rest.core.exception.ProgrammingError;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationHints;
import org.squashtest.tm.plugin.rest.core.jackson.WrappedDTO;

public final class DeserializationUtils {
    private DeserializationUtils() {
    }

    public static DeserializationHints getHints(DeserializationContext ctxt) {
        DeserializationHints hints = (DeserializationHints)ctxt.getAttribute((Object)"deserialization_hints");
        if (hints == null) {
            throw new ProgrammingError("No hints found in the deserialization context ! The hints are available only for url endpoint using annotation @PersistentEntity.");
        }
        return hints;
    }

    public static Object findEnclosingUnwrappedInstance(JsonParser parser) {
        Object constructed = parser.getParsingContext().getParent().getCurrentValue();
        if (WrappedDTO.class.isAssignableFrom(constructed.getClass())) {
            constructed = ((WrappedDTO)constructed).getWrapped();
        }
        return constructed;
    }

    public static BoundEntity findBoundEntity(JsonParser parser) {
        Object constructed = DeserializationUtils.findEnclosingUnwrappedInstance(parser);
        if (BoundEntity.class.isAssignableFrom(constructed.getClass())) {
            return (BoundEntity)constructed;
        }
        return null;
    }

    public static BoundEntity findBoundEntityOrDie(JsonParser p) {
        BoundEntity entity = DeserializationUtils.findBoundEntity(p);
        if (entity == null) {
            Class<?> clz = DeserializationUtils.findEnclosingUnwrappedInstance(p).getClass();
            throw new ProgrammingError("expected to find an instance of BoundEntity (an entity that can have custom field value) but found instead : " + String.valueOf(clz));
        }
        return entity;
    }
}

