/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import jakarta.persistence.EntityNotFoundException;
import java.util.Collections;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.plugin.rest.jackson.model.ParameterDto;
import org.squashtest.tm.plugin.rest.repository.RestParameterRepository;
import org.squashtest.tm.plugin.rest.service.RestParameterService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testcase.ParameterModificationService;

@Service
@Transactional
public class RestParameterServiceImpl
implements RestParameterService {
    @Inject
    private RestParameterRepository restParameterRepository;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private ParameterModificationService parameterModificationService;
    @Inject
    private PermissionEvaluationService permissionService;

    @Override
    @Transactional(readOnly=true)
    public Parameter getOne(long id) throws AccessDeniedException {
        Parameter parameter = this.getParameter(id);
        TestCase testCase = parameter.getTestCase();
        if (this.permissionEvaluationService.canRead((Object)testCase)) {
            return parameter;
        }
        throw new AccessDeniedException("Access denied");
    }

    private Parameter getParameter(long id) {
        Parameter parameter = this.restParameterRepository.retrieveById(id);
        if (parameter == null) {
            throw new EntityNotFoundException("The parameter with id : " + id + " do not exist.");
        }
        return parameter;
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#testCaseId,'org.squashtest.tm.domain.testcase.TestCase' , 'READ')")
    public Page<Parameter> findAllByTestCaseId(long testCaseId, Pageable pageable) {
        return this.restParameterRepository.findByTestCase_Id(testCaseId, pageable);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#parameterDto.getReferencedTestCase().getId(),'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE')")
    public Parameter addParameter(ParameterDto parameterDto) {
        Parameter parameter = new Parameter(parameterDto.getName());
        parameter.setDescription(parameterDto.getDescription());
        this.parameterModificationService.addNewParameterToTestCase(parameter, parameterDto.getReferencedTestCase().getId().longValue());
        return parameter;
    }

    @Override
    public Parameter modifyParameter(ParameterDto parameterDto) {
        Parameter parameter = this.getParameter(parameterDto.getId());
        this.checkWritePermissionOnTestCase(parameter.getTestCase().getId());
        if (parameterDto.isHasName()) {
            parameter.setName(parameterDto.getName());
        }
        if (parameterDto.isHasDescription()) {
            parameter.setDescription(parameterDto.getDescription());
        }
        return parameter;
    }

    @Override
    public void deleteParameter(Long parameterId) {
        Parameter parameter = this.getParameter(parameterId);
        this.checkWritePermissionOnTestCase(parameter.getTestCase().getId());
        this.parameterModificationService.removeById(parameterId.longValue());
    }

    private void checkWritePermissionOnTestCase(Long testCaseId) {
        this.permissionService.checkPermission(Collections.singletonList(testCaseId), Permissions.WRITE.name(), TestCase.class.getName());
    }
}

