/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.helper;

import java.util.List;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;

public final class CustomSelfLinksHelper {
    private static final List<String> invalidEntityTypes = List.of("projects", "reports", "dashboards", "charts", "custom-exports", "reporting-folders", "custom-report");

    private CustomSelfLinksHelper() {
    }

    public static <T> void replaceLinksByCustomSelfLinks(EntityModel<T> entityModel, String entityTypeName) {
        entityModel.removeLinks();
        String entityType = "%ss".formatted(CustomSelfLinksHelper.toKebabCase(entityTypeName));
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
        String currentPath = builder.build().getPath();
        String newPath = invalidEntityTypes.stream().filter(currentPath::contains).findFirst().map(option -> currentPath.replaceFirst(option + "/[^/]+", "").replaceFirst("/reporting-library/content", "")).orElse(currentPath);
        builder.replacePath(newPath);
        builder.path("/" + entityType + "/" + String.valueOf(((CustomReportLibraryNode)entityModel.getContent()).getId()));
        entityModel.add(Link.of((String)builder.toUriString(), (LinkRelation)LinkRelation.of((String)"self")));
    }

    public static String toKebabCase(String input) {
        return input.replace('_', '-').toLowerCase();
    }
}

