/*
 * Decompiled with CFR 0.152.
 */
package xsquash4gitlab.com.apollographql.apollo.internal.fetcher;

import java.util.concurrent.Executor;
import xsquash4gitlab.com.apollographql.apollo.api.internal.ApolloLogger;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloException;
import xsquash4gitlab.com.apollographql.apollo.fetcher.ResponseFetcher;
import xsquash4gitlab.com.apollographql.apollo.interceptor.ApolloInterceptor;
import xsquash4gitlab.com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;

public final class CacheFirstFetcher
implements ResponseFetcher {
    @Override
    public ApolloInterceptor provideInterceptor(ApolloLogger apolloLogger) {
        return new CacheFirstInterceptor();
    }

    private static final class CacheFirstInterceptor
    implements ApolloInterceptor {
        volatile boolean disposed;

        private CacheFirstInterceptor() {
        }

        @Override
        public void interceptAsync(final @NotNull ApolloInterceptor.InterceptorRequest request, final @NotNull ApolloInterceptorChain chain, final @NotNull Executor dispatcher, final @NotNull ApolloInterceptor.CallBack callBack) {
            ApolloInterceptor.InterceptorRequest cacheRequest = request.toBuilder().fetchFromCache(true).build();
            chain.proceedAsync(cacheRequest, dispatcher, new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                    callBack.onResponse(response);
                }

                @Override
                public void onFailure(@NotNull ApolloException e) {
                    if (!disposed) {
                        ApolloInterceptor.InterceptorRequest networkRequest = request.toBuilder().fetchFromCache(false).build();
                        chain.proceedAsync(networkRequest, dispatcher, callBack);
                    }
                }

                @Override
                public void onCompleted() {
                    callBack.onCompleted();
                }

                @Override
                public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
                    callBack.onFetch(sourceType);
                }
            });
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }
    }
}

