/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch;

import com.google.common.base.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;
import xsquash4gitlab.org.jetbrains.annotations.Nullable;

public final class NoteProcessInfo {
    public final Set<Long> requirementIds;
    public final String issueGlobalId;
    public final String noteBody;
    public final String existingNoteGlobalId;
    public final boolean canEdit;

    private NoteProcessInfo(@NotNull Set<Long> requirementIds, @NotNull String issueGlobalId, @NotNull String noteBody, @Nullable String existingNoteGlobalId, boolean canEdit) {
        this.requirementIds = requirementIds;
        this.issueGlobalId = issueGlobalId;
        this.noteBody = noteBody;
        this.existingNoteGlobalId = existingNoteGlobalId;
        this.canEdit = canEdit;
    }

    private NoteProcessInfo(@NotNull Set<Long> requirementIds, @NotNull String issueGlobalId, @NotNull String noteBody, @Nullable String existingNoteGlobalId) {
        this(requirementIds, issueGlobalId, noteBody, existingNoteGlobalId, true);
    }

    public static NoteProcessInfo forCreation(Set<Long> requirementIds, String issueGlobalId, String noteBody) {
        return new NoteProcessInfo(requirementIds, issueGlobalId, noteBody, null);
    }

    public static NoteProcessInfo forUpdate(Set<Long> requirementIds, String issueGlobalId, String noteBody, String noteGlobalId, boolean canEdit) {
        return new NoteProcessInfo(requirementIds, issueGlobalId, noteBody, noteGlobalId, canEdit);
    }

    public boolean isUpdate() {
        return this.existingNoteGlobalId != null;
    }

    public boolean isCreation() {
        return this.existingNoteGlobalId == null;
    }

    public String getIssueGlobalId() {
        return this.issueGlobalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoteProcessInfo that = (NoteProcessInfo)o;
        return Objects.equal((Object)this.issueGlobalId, (Object)that.issueGlobalId) && Objects.equal((Object)this.noteBody, (Object)that.noteBody) && Objects.equal((Object)this.existingNoteGlobalId, (Object)that.existingNoteGlobalId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.issueGlobalId, this.noteBody, this.existingNoteGlobalId});
    }

    public String prettyPrint() {
        return "[issueGlobalId=%s, existingNoteGlobalId=%s, requirementIds=%s]".formatted(this.issueGlobalId, this.existingNoteGlobalId, this.requirementIds.stream().map(Object::toString).collect(Collectors.joining(",")));
    }
}

