/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.domain;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.model.Mappings;

public class PersistedConfiguration {
    private static final String MAPPINGS_KEY = "Xsquash4GitLabMappings";
    public static final String DISPLAY_STATE_KEY = "Xsquash4GitLabDisplayState";
    private final Map<Long, Mappings> mappingsBySyncIds;
    private Map<Long, Boolean> displayStateBySyncId;

    public PersistedConfiguration(Map<Long, Mappings> mappingsBySyncIds, Map<Long, Boolean> displayStateBySyncId) {
        this.mappingsBySyncIds = mappingsBySyncIds.isEmpty() ? new HashMap<Long, Mappings>() : new HashMap<Long, Mappings>(mappingsBySyncIds);
        this.displayStateBySyncId = new HashMap<Long, Boolean>(displayStateBySyncId);
    }

    public static PersistedConfiguration withDefaultConfiguration() {
        return new PersistedConfiguration(new HashMap<Long, Mappings>(), new HashMap<Long, Boolean>());
    }

    public Map<Long, Mappings> getMappingsBySyncIds() {
        return this.mappingsBySyncIds;
    }

    public Map<Long, Boolean> getDisplayStateBySyncId() {
        return this.displayStateBySyncId;
    }

    public void setDisplayStateBySyncId(Map<Long, Boolean> displayStateBySyncId) {
        this.displayStateBySyncId = displayStateBySyncId;
    }

    public boolean hasConfiguredMappings() {
        return this.mappingsBySyncIds.values().stream().anyMatch(mappings -> !Mappings.isEmptyOrNull(mappings));
    }

    public Map<String, String> asRawMap() throws IOException {
        String jsonMappings = new ObjectMapper().writeValueAsString(this.mappingsBySyncIds);
        String displayState = new ObjectMapper().writeValueAsString(this.displayStateBySyncId);
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(MAPPINGS_KEY, jsonMappings);
        finalMap.put(DISPLAY_STATE_KEY, displayState);
        return finalMap;
    }

    public static PersistedConfiguration fromRawMap(Map<String, String> rawConfiguration) throws IOException {
        Map<Long, Mappings> mappings;
        if (rawConfiguration.containsKey(MAPPINGS_KEY)) {
            mappings = (Map)new ObjectMapper().readValue(rawConfiguration.get(MAPPINGS_KEY), (TypeReference)new TypeReference<HashMap<Long, Mappings>>(){});
            if (mappings.isEmpty()) {
                mappings = new HashMap();
            }
        } else {
            mappings = new HashMap();
        }
        Map<Long, Boolean> displayState = rawConfiguration.containsKey(DISPLAY_STATE_KEY) ? (Map)new ObjectMapper().readValue(rawConfiguration.get(DISPLAY_STATE_KEY), (TypeReference)new TypeReference<Map<Long, Boolean>>(){}) : new HashMap<Long, Boolean>();
        return new PersistedConfiguration(mappings, displayState);
    }
}

