/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabSynchronisationConfiguration;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SyncedRequirementHierarchy;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationFilterValue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationReport;

public class GitLabRemoteSynchronisation {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitLabRemoteSynchronisation.class);
    private RemoteSynchronisation remoteSynchronisation;

    protected GitLabRemoteSynchronisation() {
    }

    public GitLabRemoteSynchronisation(RemoteSynchronisation remoteSynchronisation) {
        this.remoteSynchronisation = remoteSynchronisation;
    }

    public RemoteSynchronisation getRemoteSynchronisation() {
        return this.remoteSynchronisation;
    }

    public Long getId() {
        return this.remoteSynchronisation.getId();
    }

    public Project getProject() {
        return this.remoteSynchronisation.getProject();
    }

    public String getSynchronisationPath() {
        return GitLabRemoteSynchronisation.getSynchronisationPath(this.remoteSynchronisation);
    }

    public static String getSynchronisationPath(RemoteSynchronisation remoteSynchronisation) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSynchronisation);
        String rawPath = conf.getSynchronisationPath();
        if (rawPath == null) {
            throw new IllegalArgumentException("Programmatic error, no synchronisation path for remote sync " + remoteSynchronisation.getId());
        }
        return PathUtils.appendPathToProjectName((String)remoteSynchronisation.getProject().getName(), (String)rawPath);
    }

    public void setSynchronisationPath(String synchronisationPath) throws IOException {
        GitLabSynchronisationConfiguration conf = this.getConfForUpdate();
        conf.setSynchronisationPath(synchronisationPath);
        this.remoteSynchronisation.setOptions(new ObjectMapper().writeValueAsString((Object)conf));
    }

    private GitLabSynchronisationConfiguration getConfForUpdate() {
        if (this.remoteSynchronisation.getOptions() == null) {
            return new GitLabSynchronisationConfiguration();
        }
        return this.getDeserializedOptions();
    }

    private GitLabSynchronisationConfiguration getDeserializedOptions() {
        return GitLabRemoteSynchronisation.getDeserializedOptions(this.remoteSynchronisation);
    }

    private static GitLabSynchronisationConfiguration getDeserializedOptions(RemoteSynchronisation remoteSynchronisation) {
        return GitLabRemoteSynchronisation.getDeserializedOptions(remoteSynchronisation.getId(), remoteSynchronisation.getOptions());
    }

    public static GitLabSynchronisationConfiguration getDeserializedOptions(Long remoteSyncId, String synchronisationOptions) {
        try {
            return (GitLabSynchronisationConfiguration)new ObjectMapper().readValue(synchronisationOptions, GitLabSynchronisationConfiguration.class);
        }
        catch (IOException ioException) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Could not deserialize options for gitlab synchronisation %d".formatted(remoteSyncId));
            }
            throw new IllegalArgumentException(ioException);
        }
    }

    public String getPerimeter() {
        return GitLabRemoteSynchronisation.getPerimeter(this.remoteSynchronisation);
    }

    public static String getPerimeter(RemoteSynchronisation remoteSynchronisation) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSynchronisation);
        String perimeter = conf.getPerimeter();
        if (perimeter == null) {
            throw new IllegalArgumentException("Programmatic error, no parameter in remote synchronisation " + remoteSynchronisation.getId());
        }
        return perimeter;
    }

    public void setPerimeter(String perimeter) throws IOException {
        GitLabSynchronisationConfiguration conf = this.getConfForUpdate();
        conf.setPerimeter(perimeter);
        this.remoteSynchronisation.setOptions(new ObjectMapper().writeValueAsString((Object)conf));
    }

    public List<SynchronisationFilterValue> getFilterValues() {
        return GitLabRemoteSynchronisation.getFilterValues(this.remoteSynchronisation);
    }

    public static List<SynchronisationFilterValue> getFilterValues(RemoteSynchronisation remoteSynchronisation) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSynchronisation);
        List<SynchronisationFilterValue> filterValues = conf.getFilterValues();
        if (filterValues == null) {
            throw new IllegalArgumentException("Programmatic error, no filter values for remote sync " + remoteSynchronisation.getId());
        }
        return filterValues;
    }

    public static List<SynchronisationFilterValue> getFilterValuesForDto(RemoteSynchronisation remoteSynchronisation) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSynchronisation);
        List<SynchronisationFilterValue> filters = conf.getFilterValues();
        if (filters == null) {
            return new ArrayList<SynchronisationFilterValue>();
        }
        return filters;
    }

    public static List<SynchronisationFilterValue> getSprintFilterValuesForDto(RemoteSynchronisation remoteSynchronisation) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSynchronisation);
        List<SynchronisationFilterValue> sprintFilters = conf.getSprintFilterValues();
        if (sprintFilters == null) {
            return new ArrayList<SynchronisationFilterValue>();
        }
        return sprintFilters;
    }

    public static List<SynchronisationFilterValue> getSprintFilterValues(RemoteSynchronisation remoteSynchronisation) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSynchronisation);
        List<SynchronisationFilterValue> sprintFilters = conf.getSprintFilterValues();
        if (sprintFilters == null) {
            throw new IllegalArgumentException("Programmatic error, no filter values for remote sync " + remoteSynchronisation.getId());
        }
        return sprintFilters;
    }

    public void setFilterValues(List<SynchronisationFilterValue> filterValues) throws IOException {
        GitLabSynchronisationConfiguration conf = this.getConfForUpdate();
        conf.setFilterValues(filterValues);
        this.remoteSynchronisation.setOptions(new ObjectMapper().writeValueAsString((Object)conf));
    }

    public void setSprintFilterValues(List<SynchronisationFilterValue> sprintFilterValues) throws IOException {
        GitLabSynchronisationConfiguration conf = this.getConfForUpdate();
        conf.setSprintFilterValues(sprintFilterValues);
        this.remoteSynchronisation.setOptions(new ObjectMapper().writeValueAsString((Object)conf));
    }

    public SyncedRequirementHierarchy getSyncedRequirementHierarchy() {
        return GitLabRemoteSynchronisation.getSyncedRequirementHierarchy(this.remoteSynchronisation);
    }

    public static SyncedRequirementHierarchy getSyncedRequirementHierarchy(RemoteSynchronisation remoteSync) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSync);
        String hierarchy = conf.getHierarchy();
        return SyncedRequirementHierarchy.valueOf(hierarchy);
    }

    public void setSyncedRequirementHierarchy(SyncedRequirementHierarchy hierarchy) throws IOException {
        GitLabSynchronisationConfiguration conf = this.getConfForUpdate();
        conf.setHierarchy(hierarchy.name());
        this.remoteSynchronisation.setOptions(new ObjectMapper().writeValueAsString((Object)conf));
    }

    public String getSelectValue() {
        return this.remoteSynchronisation.getSelectValue();
    }

    public boolean isSprintSynchronisationEnable() {
        return GitLabRemoteSynchronisation.isSprintSynchronisationEnable(this.remoteSynchronisation);
    }

    public static boolean isSprintSynchronisationEnable(RemoteSynchronisation remoteSync) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSync);
        return conf.isSprintSynchronisationEnable();
    }

    public void setSprintSynchronisationEnable(boolean sprintSynchronisationEnable) throws IOException {
        GitLabSynchronisationConfiguration conf = this.getConfForUpdate();
        conf.setSprintSynchronisationEnable(sprintSynchronisationEnable);
        this.remoteSynchronisation.setOptions(new ObjectMapper().writeValueAsString((Object)conf));
    }

    public String getSprintSynchronisationPath() {
        return GitLabRemoteSynchronisation.getSprintSynchronisationPath(this.remoteSynchronisation);
    }

    public static String getSprintSynchronisationPath(RemoteSynchronisation remoteSync) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSync);
        String rawPath = conf.getSprintSynchronisationPath();
        if (rawPath == null) {
            throw new IllegalArgumentException("Programmatic error, no sprint synchronisation path for remote sync " + remoteSync.getId());
        }
        return PathUtils.appendPathToProjectName((String)remoteSync.getProject().getName(), (String)rawPath);
    }

    public void setSprintSynchronisationPath(String sprintSynchronisationPath) throws IOException {
        GitLabSynchronisationConfiguration conf = this.getConfForUpdate();
        conf.setSprintSynchronisationPath(sprintSynchronisationPath);
        this.remoteSynchronisation.setOptions(new ObjectMapper().writeValueAsString((Object)conf));
    }

    public void setSprintRemoteSelectType(String sprintRemoteSelectType) throws IOException {
        GitLabSynchronisationConfiguration conf = this.getConfForUpdate();
        conf.setSprintRemoteSelectType(sprintRemoteSelectType);
        this.remoteSynchronisation.setOptions(new ObjectMapper().writeValueAsString((Object)conf));
    }

    public static String getSprintSelectType(RemoteSynchronisation remoteSync) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSync);
        return conf.getSprintRemoteSelectType();
    }

    public void setSprintSelectValue(String sprintSelectValue) throws IOException {
        GitLabSynchronisationConfiguration conf = this.getConfForUpdate();
        conf.setSprintSelectValue(sprintSelectValue);
        this.remoteSynchronisation.setOptions(new ObjectMapper().writeValueAsString((Object)conf));
    }

    public static String getSprintSelectValue(RemoteSynchronisation remoteSync) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSync);
        return conf.getSprintSelectValue();
    }

    public static Integer getSynchronizedRequirementsCount(RemoteSynchronisation remoteSync) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSync);
        return conf.getSynchronizedRequirementsCount();
    }

    public static Integer getUnprocessedRequirementsCount(RemoteSynchronisation remoteSync) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSync);
        return conf.getUnprocessedRequirementsCount();
    }

    public static Integer getSynchronizedSprintTicketsCount(RemoteSynchronisation remoteSync) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSync);
        return conf.getSynchronizedSprintTicketsCount();
    }

    public static Integer getUnprocessedSprintTicketsCount(RemoteSynchronisation remoteSync) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSync);
        return conf.getUnprocessedSprintTicketsCount();
    }

    public void setStatusLabelEnabled(boolean statusLabelEnabled) throws JsonProcessingException {
        GitLabSynchronisationConfiguration conf = this.getConfForUpdate();
        conf.setStatusLabelEnabled(statusLabelEnabled);
        this.remoteSynchronisation.setOptions(new ObjectMapper().writeValueAsString((Object)conf));
    }

    public static boolean isStatusLabelEnabled(RemoteSynchronisation remoteSync) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSync);
        return conf.isStatusLabelEnabled();
    }

    public static String getStatusLabelPrefix(RemoteSynchronisation remoteSync) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(remoteSync);
        return conf.getStatusLabelPrefix();
    }

    public static String getStatusLabelPrefix(Long syncId, String configuration) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(syncId, configuration);
        return conf.getStatusLabelPrefix();
    }

    public static boolean isStatusLabelEnabled(Long syncId, String configuration) {
        GitLabSynchronisationConfiguration conf = GitLabRemoteSynchronisation.getDeserializedOptions(syncId, configuration);
        return conf.isStatusLabelEnabled();
    }

    public void setStatusLabelPrefix(String statusLabelPrefix) throws JsonProcessingException {
        GitLabSynchronisationConfiguration conf = this.getConfForUpdate();
        conf.setStatusLabelPrefix(statusLabelPrefix);
        this.remoteSynchronisation.setOptions(new ObjectMapper().writeValueAsString((Object)conf));
    }

    public void setSynchronizedAndUnprocessedCounts(SynchronisationReport report) throws IOException {
        GitLabSynchronisationConfiguration conf = this.getConfForUpdate();
        conf.setSynchronizedRequirementsCount(report.getSynchronizedRequirementsCount());
        conf.setUnprocessedRequirementsCount(report.getUnprocessedRequirementsCount());
        if (this.isSprintSynchronisationEnable()) {
            conf.setSynchronizedSprintTicketsCount(report.getSynchronizedSprintTicketsCount());
            conf.setUnprocessedSprintTicketsCount(report.getUnprocessedSprintTicketsCount());
        }
        this.remoteSynchronisation.setOptions(new ObjectMapper().writeValueAsString((Object)conf));
    }

    public void removeSprintSynchronisation() throws IOException {
        GitLabSynchronisationConfiguration conf = this.getConfForUpdate();
        conf.setSprintSynchronisationEnable(false);
        conf.setSprintSynchronisationPath(null);
        conf.setSprintFilterValues(null);
        conf.setSprintSelectValue(null);
        conf.setSprintRemoteSelectType(null);
        conf.setSynchronizedSprintTicketsCount(null);
        conf.setUnprocessedSprintTicketsCount(null);
        this.remoteSynchronisation.setOptions(new ObjectMapper().writeValueAsString((Object)conf));
    }
}

