/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.adapter;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabNamedReferenceDto;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabConverters;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupBoardScopeQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectBoardScopeQuery;

public interface BoardAdapter {
    public String milestoneId();

    public String milestoneTitle();

    public String iterationId();

    public String iterationTitle();

    public String assigneeUsername();

    public String assigneeName();

    public List<GitLabNamedReferenceDto> getLabels();

    public Integer weight();

    public static class GroupBoard
    implements BoardAdapter {
        private final GetGroupBoardScopeQuery.Board board;

        public GroupBoard(GetGroupBoardScopeQuery.Board board) {
            this.board = board;
        }

        @Override
        public String milestoneId() {
            return Optional.ofNullable(this.board.milestone()).map(GetGroupBoardScopeQuery.Milestone::id).orElse(null);
        }

        @Override
        public String milestoneTitle() {
            return Optional.ofNullable(this.board.milestone()).map(GetGroupBoardScopeQuery.Milestone::title).orElse(null);
        }

        @Override
        public String iterationId() {
            return Optional.ofNullable(this.board.iteration()).map(GetGroupBoardScopeQuery.Iteration::id).orElse(null);
        }

        @Override
        public String iterationTitle() {
            return Optional.ofNullable(this.board.iteration()).map(GetGroupBoardScopeQuery.Iteration::title).orElse(null);
        }

        @Override
        public String assigneeUsername() {
            return Optional.ofNullable(this.board.assignee()).map(GetGroupBoardScopeQuery.Assignee::username).orElse(null);
        }

        @Override
        public String assigneeName() {
            return Optional.ofNullable(this.board.assignee()).map(GetGroupBoardScopeQuery.Assignee::name).orElse(null);
        }

        @Override
        public List<GitLabNamedReferenceDto> getLabels() {
            return Optional.ofNullable(this.board.labels()).map(GetGroupBoardScopeQuery.Labels::nodes).map(nodes -> nodes.stream().map(node -> new GitLabNamedReferenceDto(node.id(), node.title()))).orElseThrow(() -> GitLabConverters.exception("Received malformed label in group board filters")).collect(Collectors.toList());
        }

        @Override
        public Integer weight() {
            return this.board.weight();
        }
    }

    public static class ProjectBoard
    implements BoardAdapter {
        private final GetProjectBoardScopeQuery.Board board;

        public ProjectBoard(GetProjectBoardScopeQuery.Board board) {
            this.board = board;
        }

        @Override
        public String milestoneId() {
            return Optional.ofNullable(this.board.milestone()).map(GetProjectBoardScopeQuery.Milestone::id).orElse(null);
        }

        @Override
        public String milestoneTitle() {
            return Optional.ofNullable(this.board.milestone()).map(GetProjectBoardScopeQuery.Milestone::title).orElse(null);
        }

        @Override
        public String iterationId() {
            return Optional.ofNullable(this.board.iteration()).map(GetProjectBoardScopeQuery.Iteration::id).orElse(null);
        }

        @Override
        public String iterationTitle() {
            return Optional.ofNullable(this.board.iteration()).map(GetProjectBoardScopeQuery.Iteration::title).orElse(null);
        }

        @Override
        public String assigneeUsername() {
            return Optional.ofNullable(this.board.assignee()).map(GetProjectBoardScopeQuery.Assignee::username).orElse(null);
        }

        @Override
        public String assigneeName() {
            return Optional.ofNullable(this.board.assignee()).map(GetProjectBoardScopeQuery.Assignee::name).orElse(null);
        }

        @Override
        public List<GitLabNamedReferenceDto> getLabels() {
            return Optional.ofNullable(this.board.labels()).map(GetProjectBoardScopeQuery.Labels::nodes).map(nodes -> nodes.stream().map(node -> new GitLabNamedReferenceDto(node.id(), node.title()))).orElseThrow(() -> GitLabConverters.exception("Received malformed label in Project board filters")).collect(Collectors.toList());
        }

        @Override
        public Integer weight() {
            return this.board.weight();
        }
    }
}

