/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ad.ldap;

import javax.naming.directory.DirContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.squashtest.tm.core.foundation.lang.Assert;
import org.squashtest.tm.plugin.security.ad.ldap.AbstractActiveDirectoryLdapAuthenticationProviderFeatures;
import org.squashtest.tm.plugin.security.ad.ldap.SquashActiveDirectoryLdapAuthenticationProvider;
import org.squashtest.tm.service.user.UserManagerService;

public class ActiveDirectoryLdapAuthenticationProviderFactoryBean
implements FactoryBean<SquashActiveDirectoryLdapAuthenticationProvider>,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveDirectoryLdapAuthenticationProviderFactoryBean.class);
    private static final String MULTI_AD_PROVIDER = "ad.ldap-multi";
    private static final String AD_PROVIDER = "ad.ldap";
    private String url;
    private String domain;
    private String userSearchBase;
    private String userSearchFilter;
    private LdapContextSource contextSource;
    private String activeAuthenticationProvider;
    private LdapAuthoritiesPopulator authoritiesPopulator;
    private Boolean convertSubErrorCodesToExceptions;
    private SquashActiveDirectoryLdapAuthenticationProvider authenticationProvider;
    private UserDetailsContextMapper userDetailsMapper;
    private AbstractActiveDirectoryLdapAuthenticationProviderFeatures features;
    private UserManagerService userManagerService;

    public SquashActiveDirectoryLdapAuthenticationProvider getObject() {
        return this.authenticationProvider;
    }

    private SquashActiveDirectoryLdapAuthenticationProvider createAuthenticationProvider() {
        SquashActiveDirectoryLdapAuthenticationProvider provider = new SquashActiveDirectoryLdapAuthenticationProvider(this.domain, this.url);
        this.checkManagerAccount(provider);
        provider.setAuthoritiesPopulator(this.authoritiesPopulator);
        provider.setUserDetailsContextMapper(this.userDetailsMapper);
        provider.setFeatures(this.features);
        provider.setUserFinder(this.userManagerService);
        if (StringUtils.isNotBlank((CharSequence)this.userSearchFilter)) {
            provider.setSearchFilter(this.userSearchFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)this.userSearchBase)) {
            provider.setSearchBase(this.userSearchBase);
        }
        if (this.convertSubErrorCodesToExceptions != null) {
            provider.setConvertSubErrorCodesToExceptions(this.convertSubErrorCodesToExceptions);
        }
        return provider;
    }

    private void checkManagerAccount(SquashActiveDirectoryLdapAuthenticationProvider provider) {
        String newDomain = provider.rootDnFromDomain(this.domain);
        String logMsg = this.url + "/" + newDomain;
        String username = this.contextSource.getUserDn();
        String password = this.contextSource.getPassword();
        if (StringUtils.isNotBlank((CharSequence)username) || StringUtils.isNotBlank((CharSequence)password)) {
            LOGGER.debug("Bind authentication in url: " + logMsg);
            DirContext ctx = provider.bindAsUser(username, password);
            LdapUtils.closeContext((DirContext)ctx);
        } else {
            LOGGER.debug("Anonymous authentication in url: " + logMsg);
        }
        LOGGER.info("plugin AD enabled");
    }

    public Class<?> getObjectType() {
        return LdapAuthenticationProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }

    void setUserSearchBase(String userSearchBase) {
        this.userSearchBase = userSearchBase;
    }

    void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.userDetailsMapper == null) {
            LOGGER.warn("No UserDetailsMapper was configured. This may be a programming error.");
        }
        if (MULTI_AD_PROVIDER.equals(this.activeAuthenticationProvider) || AD_PROVIDER.equals(this.activeAuthenticationProvider)) {
            LOGGER.info("Active auth provider is '{}', this factory will produce an Active Directory LDAP auth provider.", (Object)this.activeAuthenticationProvider);
            this.initializeActiveDirectoryAuthenticationProvider();
        } else {
            LOGGER.info("Active auth provider is '{}', this factory will produce an Active Directory null auth provider.", (Object)this.activeAuthenticationProvider);
            this.initializeNullAuthenticationProvider();
        }
        this.authenticationProvider.afterPropertiesSet();
    }

    private void initializeActiveDirectoryAuthenticationProvider() throws Exception {
        Assert.propertyNotBlank((String)this.url, (String)"AD server url should not be blank.");
        Assert.propertyNotNull((Object)this.contextSource, (String)"AD server contextSource should not be null.");
        Assert.propertyNotNull((Object)this.authoritiesPopulator, (String)"AD server authoritiesPopulator should not be null.");
        LOGGER.debug("Checking ActiveDirectoryLdapAuthenticationManagerFactoryBean configuration");
        LOGGER.debug("Configured server url : {}", (Object)this.url);
        LOGGER.debug("Configured domain name : {}", (Object)this.domain);
        LOGGER.debug("Configured user search base : {}", (Object)this.userSearchBase);
        LOGGER.debug("Configured user search filter : {}", (Object)this.userSearchFilter);
        this.authenticationProvider = this.createAuthenticationProvider();
    }

    private void initializeNullAuthenticationProvider() {
        this.authenticationProvider = new NullAuthenticationProvider();
    }

    public void setActiveAuthenticationProvider(String activeAuthenticationProvider) {
        this.activeAuthenticationProvider = activeAuthenticationProvider;
    }

    public void setAuthoritiesPopulator(LdapAuthoritiesPopulator authoritiesPopulator) {
        this.authoritiesPopulator = authoritiesPopulator;
    }

    public void setConvertSubErrorCodesToExceptions(Boolean convertSubErrorCodesToExceptions) {
        this.convertSubErrorCodesToExceptions = convertSubErrorCodesToExceptions;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    void setUserDetailsMapper(UserDetailsContextMapper userDetailsMapper) {
        this.userDetailsMapper = userDetailsMapper;
    }

    void setFeatures(AbstractActiveDirectoryLdapAuthenticationProviderFeatures features) {
        this.features = features;
    }

    void setUserManagerService(UserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    public void setContextSource(LdapContextSource contextSource) {
        this.contextSource = contextSource;
    }

    public String getUrl() {
        return this.url;
    }

    private static class NullAuthenticationProvider
    extends SquashActiveDirectoryLdapAuthenticationProvider {
        @Override
        public void afterPropertiesSet() {
        }

        NullAuthenticationProvider() {
            super("NullAuthenticationProvider", "NullAuthenticationProvider");
        }

        @Override
        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            return null;
        }

        public boolean supports(Class<?> authentication) {
            return false;
        }
    }
}

