/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap.internal.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.util.function.Supplier;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.utils.RestTemplateFactory;

public abstract class RestTemplateAbstractFactory
implements RestTemplateFactory,
InitializingBean {
    @Inject
    protected RestTemplateBuilder builder;
    protected Supplier<ClientHttpRequestFactory> springRequestFactory;

    @Override
    public RestTemplate restTemplate(BugTracker bugTracker, Credentials credentials) {
        RestTemplateBuilder configuredBuilder = this.configureBaseBuilder(bugTracker.getUrl());
        if (AuthenticationProtocol.BASIC_AUTH.equals((Object)credentials.getImplementedProtocol())) {
            configuredBuilder = this.addBasicAuthentication(configuredBuilder, credentials);
        }
        return configuredBuilder.build();
    }

    private RestTemplateBuilder configureBaseBuilder(String baseUrl) {
        return this.builder.rootUri(baseUrl).requestFactory(this.springRequestFactory).messageConverters(new HttpMessageConverter[]{this.tuleapPluginMappingJackson2HttpMessageConverter()});
    }

    private RestTemplateBuilder addBasicAuthentication(RestTemplateBuilder builder, Credentials credentials) {
        BasicAuthenticationCredentials basicAuthenticationCredentials = (BasicAuthenticationCredentials)credentials;
        return builder.basicAuthentication(basicAuthenticationCredentials.getUsername(), String.valueOf(basicAuthenticationCredentials.getPassword()));
    }

    protected abstract void initSpringRequestFactory();

    public void afterPropertiesSet() {
        this.initSpringRequestFactory();
    }

    public MappingJackson2HttpMessageConverter tuleapPluginMappingJackson2HttpMessageConverter() {
        MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();
        messageConverter.setObjectMapper(this.tuleapPluginObjectMapper());
        return messageConverter;
    }

    public ObjectMapper tuleapPluginObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        return objectMapper;
    }
}

