/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.RedmineOptions;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Role;
import java.util.List;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.NameValuePair;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.message.BasicNameValuePair;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedCustomField;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedRole;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedTracker;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedWorkflows;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.internal.ExtendedTransport;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.internal.ExtendedURIConfigurator;
import org.squashtest.tm.plugin.bugtracker.redmine3.utils.BaseCommunicatorFactory;

public class Redmine3ExtendedManager
extends RedmineManager {
    private final ExtendedTransport extendedTransport;
    private final String uri;
    private final String login;
    private final String password;
    private final String token;

    public Redmine3ExtendedManager(String uri, String login, String password, BaseCommunicatorFactory baseCommunicatorFactory) {
        super(uri, login, password, RedmineOptions.simpleOptions());
        this.extendedTransport = new ExtendedTransport(new ExtendedURIConfigurator(uri, null), baseCommunicatorFactory);
        this.uri = uri;
        this.login = login;
        this.password = password;
        this.token = null;
        this.extendedTransport.setCredentials(login, password);
    }

    public Redmine3ExtendedManager(String uri, String token, BaseCommunicatorFactory baseCommunicatorFactory) {
        super(uri, token, RedmineOptions.simpleOptions());
        this.extendedTransport = new ExtendedTransport(new ExtendedURIConfigurator(uri, token), baseCommunicatorFactory);
        this.uri = uri;
        this.password = null;
        this.login = null;
        this.token = token;
    }

    public List<ExtendedCustomField> getCustomField() throws RedmineException {
        return this.extendedTransport.getObjectsList(ExtendedCustomField.class, new NameValuePair[0]);
    }

    public List<ExtendedTracker> getExtendedTracker() throws RedmineException {
        return this.extendedTransport.getObjectsList(ExtendedTracker.class, new NameValuePair[0]);
    }

    public List<ExtendedRole> getExtendedRoles() throws RedmineException {
        return this.extendedTransport.getObjectsList(ExtendedRole.class, new NameValuePair[0]);
    }

    public ExtendedRole getExtendedRole(Role role) throws RedmineException {
        return this.extendedTransport.getObject(ExtendedRole.class, role.getId(), new NameValuePair[0]);
    }

    @Override
    public List<IssueCategory> getCategories(int projectID) throws RedmineException {
        return this.extendedTransport.getChildEntries(Project.class, Integer.toString(projectID), IssueCategory.class);
    }

    @Override
    public List<Membership> getMemberships(String project) throws RedmineException {
        return this.extendedTransport.getChildEntries(Project.class, project, Membership.class);
    }

    @Override
    public List<Membership> getMemberships(Project project) throws RedmineException {
        return this.getMemberships(this.getProjectKey(project));
    }

    private String getProjectKey(Project project) {
        return project.getId() != null ? project.getId().toString() : project.getIdentifier();
    }

    public ExtendedWorkflows getWorkflowForRole(String roleId) throws RedmineException {
        BasicNameValuePair roleParam = new BasicNameValuePair("role_id", roleId);
        return this.extendedTransport.getObject(ExtendedWorkflows.class, roleParam);
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public String getUri() {
        return this.uri;
    }
}

