/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.converter;

import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.Version;
import jakarta.inject.Inject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.stereotype.Component;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.plugin.bugtracker.redmine3.Redmine3Client;
import org.squashtest.tm.plugin.bugtracker.redmine3.converter.EntityType;
import org.squashtest.tm.plugin.bugtracker.redmine3.converter.Redmine3FieldType;
import org.squashtest.tm.plugin.bugtracker.redmine3.converter.Redmine3IssueBuilder;
import org.squashtest.tm.plugin.bugtracker.redmine3.exception.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.utils.CustomFieldsUtils;

@Component
public class SquashToRedmine3EntityConverter {
    @Inject
    private ExceptionHandler exceptionHandler;

    public Issue squash2RedmineIssue(AdvancedIssue advancedIssue, Tracker tracker, Project project, User author) {
        Redmine3IssueBuilder builder = new Redmine3IssueBuilder(project, author, tracker);
        for (String key : advancedIssue.getFieldValues().keySet()) {
            FieldValue value = advancedIssue.getFieldValue(key);
            Redmine3FieldType redmine3FieldType = Redmine3FieldType.fromString(key);
            switch (redmine3FieldType) {
                case SUBJECT: {
                    builder.setSubject(value.getScalar().toString());
                    break;
                }
                case ASSIGNEE: {
                    builder.setAssignee(this.createAssignee(value));
                    break;
                }
                case ATTACHMENT: {
                    break;
                }
                case CATEGORY: {
                    builder.setCategory(this.createCategory(value));
                    break;
                }
                case CUSTOM: {
                    builder.addCustomField(this.createCustomField(key, value));
                    break;
                }
                case DESCRIPTION: {
                    builder.setDescription(value.getScalar().toString());
                    break;
                }
                case DONE_RATIO: {
                    builder.setDoneRatio(this.parseInt(value.getScalar()));
                    break;
                }
                case DUE_DATE: {
                    builder.setDueDate(this.createDate(value));
                    break;
                }
                case ESTIMATED_HOURS: {
                    builder.setEstimatedTime(this.parseFloat(value));
                    break;
                }
                case PARENT_ISSUE: {
                    builder.setParentId(this.parseInt(value.getScalar()));
                    break;
                }
                case PRIORITY: {
                    builder.setPriorityId(this.parseInt(value.getId()));
                    break;
                }
                case START_DATE: {
                    builder.setStartDate(this.createDate(value));
                    break;
                }
                case VERSION: {
                    builder.setVersion(this.createVersion(value));
                    break;
                }
                case TRACKER: {
                    break;
                }
                default: {
                    throw new NotImplementedException("Default case should not exist");
                }
            }
        }
        Issue issue = builder.build();
        return issue;
    }

    private Integer parseInt(String string) {
        Integer result = null;
        try {
            if (!string.isEmpty()) {
                result = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException exception) {
            throw this.exceptionHandler.numberConversionFailure(exception);
        }
        return result;
    }

    private Float parseFloat(FieldValue value) {
        Float result = null;
        try {
            if (!value.getScalar().isEmpty()) {
                result = Float.valueOf(Float.parseFloat(value.getScalar()));
            }
        }
        catch (NumberFormatException exception) {
            throw this.exceptionHandler.numberConversionFailure(exception);
        }
        return result;
    }

    private Version createVersion(FieldValue value) {
        Version v = new Version();
        if ("-1".equals(value.getId())) {
            return null;
        }
        v.setName(value.getScalar());
        v.setId(Integer.valueOf(value.getId()));
        return v;
    }

    private Date createDate(FieldValue value) {
        Date result = null;
        String scalar = value.getScalar();
        if (!"".equals(scalar) && scalar != null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                format.setLenient(false);
                result = format.parse(scalar);
            }
            catch (ParseException e) {
                throw this.exceptionHandler.genericError(e);
            }
        }
        return result;
    }

    private CustomField createCustomField(String key, FieldValue value) {
        CustomField c = new CustomField();
        c.setName(key);
        EntityType type = EntityType.fromString(value.getTypename());
        switch (type) {
            case CUSTOM_BOOL: {
                CustomFieldsUtils.setValueForCustomBool(value, c);
                break;
            }
            case CUSTOM_LIST: {
                CustomFieldsUtils.setValueForCustomList(value, c);
                break;
            }
            case CUSTOM_VERSION: {
                CustomFieldsUtils.setValueForCustomVersion(value, c);
                break;
            }
            case CUSTOM_USER: {
                CustomFieldsUtils.setValueForCustomUser(value, c);
                break;
            }
            default: {
                c.setValue(value.getScalar());
            }
        }
        return c;
    }

    private IssueCategory createCategory(FieldValue value) {
        IssueCategory category = new IssueCategory();
        if ("-1".equals(value.getId())) {
            return null;
        }
        category.setName(value.getScalar());
        category.setId(Integer.valueOf(value.getId()));
        return category;
    }

    private User createAssignee(FieldValue value) {
        User user = new User();
        user.setFullName(value.getScalar());
        return user;
    }

    public Collection<Attachment> convertToRedmineAttachments(List<org.squashtest.tm.bugtracker.definition.Attachment> attachments, Redmine3Client client) {
        ArrayList<Attachment> redmineAttachments = new ArrayList<Attachment>(attachments.size());
        for (org.squashtest.tm.bugtracker.definition.Attachment attach : attachments) {
            Attachment input = client.uploadAttachment(attach.getName(), attach.getStreamContent());
            redmineAttachments.add(input);
        }
        return redmineAttachments;
    }
}

