/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.caching;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.Project;
import java.time.Instant;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.redmine3.Redmine3Client;
import org.squashtest.tm.plugin.bugtracker.redmine3.RedmineClientInitializer;
import org.squashtest.tm.plugin.bugtracker.redmine3.caching.RedmineBugTrackerAndProject;
import org.squashtest.tm.plugin.bugtracker.redmine3.caching.RedmineCachedValues;
import org.squashtest.tm.plugin.bugtracker.redmine3.caching.RedmineCompositeCacheKey;
import org.squashtest.tm.plugin.bugtracker.redmine3.caching.RedmineValueCacheManager;
import org.squashtest.tm.plugin.bugtracker.redmine3.converter.EntityConverter;

public class RedmineValueCacheWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedmineValueCacheWorker.class);
    private final EntityConverter entityConverter;
    private final RedmineClientInitializer redmineClientInitializer;
    private final RedmineValueCacheManager redmineValueCacheManager;
    private final Object lock = new Object();
    private int id;

    public RedmineValueCacheWorker(RedmineClientInitializer redmineClientInitializer, RedmineValueCacheManager redmineValueCacheManager, EntityConverter entityConverter) {
        this.redmineClientInitializer = redmineClientInitializer;
        this.redmineValueCacheManager = redmineValueCacheManager;
        this.entityConverter = entityConverter;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void start() {
        this.redmineValueCacheManager.getTaskScheduler().schedule(this::processInSynchronizedBlock, Instant.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInSynchronizedBlock() {
        Object object = this.lock;
        synchronized (object) {
            this.doProcess();
        }
    }

    private void doProcess() {
        Optional<RedmineBugTrackerAndProject> item;
        while ((item = this.redmineValueCacheManager.getQueue().poll()).isPresent()) {
            RedmineBugTrackerAndProject redmineBtAndProject = item.get();
            this.updateCachedValues(redmineBtAndProject.bugTracker(), redmineBtAndProject.project());
        }
    }

    private void updateCachedValues(BugTracker bugTracker, Project project) {
        LOGGER.trace("[Worker #{}] Updating cache for project {} and bug tracker {}", new Object[]{this.id, project.getName(), bugTracker.getId()});
        Redmine3Client client = this.redmineClientInitializer.initRedmineClient(bugTracker);
        if (client == null) {
            return;
        }
        RedmineCompositeCacheKey key = new RedmineCompositeCacheKey(bugTracker.getId(), project.getName());
        try {
            Project extendedProject = this.entityConverter.convertToRedmineExtendedProject(project, client);
            this.redmineValueCacheManager.updateCache(key, RedmineCachedValues.of(extendedProject));
            LOGGER.trace("[Worker #{}] Finished cache update for project {} and bug tracker {}", new Object[]{this.id, project.getName(), bugTracker.getId()});
        }
        catch (RedmineException e) {
            this.redmineValueCacheManager.handleCacheError(key, e, project.getName(), bugTracker);
        }
    }
}

