/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.caching;

import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.Set;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.BugtrackerProject;

@Repository
public class RedmineValueCacheDao {
    private final DSLContext dslContext;
    private final EntityManager em;

    public RedmineValueCacheDao(DSLContext dslContext, EntityManager em) {
        this.dslContext = dslContext;
        this.em = em;
    }

    public List<BugTracker> getAllRedmineBugTrackers() {
        return this.em.createQuery("SELECT b FROM BugTracker b WHERE b.kind = :kind", BugTracker.class).setParameter("kind", (Object)"redmine3.rest").getResultList();
    }

    public Set<String> getRedmineProjectPathsByBugTrackerId(long bugTrackerId) {
        return this.dslContext.select((SelectField)BugtrackerProject.BUGTRACKER_PROJECT.BUGTRACKER_PROJECT_NAME).from((TableLike)Tables.BUGTRACKER).join((TableLike)Tables.PROJECT).on(Tables.BUGTRACKER.BUGTRACKER_ID.eq((Field)Tables.PROJECT.BUGTRACKER_ID)).join((TableLike)BugtrackerProject.BUGTRACKER_PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)BugtrackerProject.BUGTRACKER_PROJECT.PROJECT_ID)).where(Tables.BUGTRACKER.BUGTRACKER_ID.eq((Object)bugTrackerId)).fetchSet((Field)BugtrackerProject.BUGTRACKER_PROJECT.BUGTRACKER_PROJECT_NAME);
    }

    public Set<String> getRedmineProjectPathsByTmProjectId(long projectId) {
        return this.dslContext.select((SelectField)BugtrackerProject.BUGTRACKER_PROJECT.BUGTRACKER_PROJECT_NAME).from((TableLike)BugtrackerProject.BUGTRACKER_PROJECT).join((TableLike)Tables.PROJECT).on(BugtrackerProject.BUGTRACKER_PROJECT.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchSet((Field)BugtrackerProject.BUGTRACKER_PROJECT.BUGTRACKER_PROJECT_NAME);
    }
}

