-- Lock Database
UPDATE databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-jpptetfv (100.64.5.150)', LOCKGRANTED = NOW() WHERE ID = 1 AND LOCKED = FALSE;

-- *********************************************************************
-- Update Database Script
-- *********************************************************************
-- Change Log: upgrade.changelog-up-to-12.0.0.xml
-- Ran at: 28/01/2026 14:54
-- Against: squashtm@jdbc:postgresql://postgres/squashtest
-- Liquibase version: 4.31.1
-- *********************************************************************

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-provider-column-to-ai-server-table::dclaerhout
-- Add new PROVIDER column to AI_SERVER table
ALTER TABLE AI_SERVER ADD PROVIDER VARCHAR(50) DEFAULT 'NONE' NOT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-provider-column-to-ai-server-table', 'dclaerhout', 'tm/tm.changelog-12.0.0.xml', NOW(), 1, '9:5f1ab6c7d733f0af783d662095a2d7c3', 'addColumn tableName=AI_SERVER', 'Add new PROVIDER column to AI_SERVER table', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-model-name-column-to-ai-server-table::dclaerhout
-- Add new MODEL_NAME column to AI_SERVER table
ALTER TABLE AI_SERVER ADD MODEL_NAME VARCHAR(100);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-model-name-column-to-ai-server-table', 'dclaerhout', 'tm/tm.changelog-12.0.0.xml', NOW(), 2, '9:603b92acf22060d4cc16498d79fbbb80', 'addColumn tableName=AI_SERVER', 'Add new MODEL_NAME column to AI_SERVER table', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-options-column-to-ai-server-table::dclaerhout
-- Add new OPTIONS column to AI_SERVER table
ALTER TABLE AI_SERVER ADD OPTIONS TEXT;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-options-column-to-ai-server-table', 'dclaerhout', 'tm/tm.changelog-12.0.0.xml', NOW(), 3, '9:28203d84cb1883eaf7ea8ac2edcffae0', 'addColumn tableName=AI_SERVER', 'Add new OPTIONS column to AI_SERVER table', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-foreign-key-in-api-token-table-for-user-id-column::mbrugniere
-- Add foreign key constraint to API_TOKEN.USER_ID referencing CORE_USER.PARTY_ID
DELETE FROM API_TOKEN
      WHERE USER_ID NOT IN (SELECT PARTY_ID FROM CORE_USER);

ALTER TABLE API_TOKEN ADD CONSTRAINT fk_api_token_core_user FOREIGN KEY (USER_ID) REFERENCES CORE_USER (PARTY_ID) ON DELETE CASCADE;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-foreign-key-in-api-token-table-for-user-id-column', 'mbrugniere', 'tm/tm.changelog-12.0.0.xml', NOW(), 4, '9:a355dbbb5a332b2103d8df20ebb3310c', 'sql; addForeignKeyConstraint baseTableName=API_TOKEN, constraintName=fk_api_token_core_user, referencedTableName=CORE_USER', 'Add foreign key constraint to API_TOKEN.USER_ID referencing CORE_USER.PARTY_ID', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-sprint-count-subquery-to-query-tables::lmurat
-- Add new subquery counting sprints to test case search
INSERT INTO QUERY_MODEL (NAME, STRATEGY, JOIN_STYLE)
      VALUES ('TEST_CASE_SPRINTCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

INSERT INTO QUERY_COLUMN_PROTOTYPE(COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE,
                                         DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
      VALUES ('CALCULATED', FALSE, 'TEST_CASE_SPRINTCOUNT', 'TEST_CASE', null, 'NUMERIC',
              'count(sprints)', (select max(QUERY_MODEL_ID) from QUERY_MODEL));

INSERT INTO QUERY_PROJECTION_COLUMN(QUERY_COLUMN_ID, QUERY_MODEL_ID, LABEL, PROJECTION_OPERATION, PROJECTION_RANK, CUF_ID)
      VALUES (
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'SPRINT_ID'),
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        null, 'COUNT', 0, null
      );

INSERT INTO QUERY_AGGREGATION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, LABEL, AGGREGATION_OPERATION, AGGREGATION_RANK, CUF_ID)
      VALUES (
                 (select max(QUERY_MODEL_ID) from QUERY_MODEL),
                 (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_SPRINTCOUNT'),
                 null, 'NONE', 0, null
             );

INSERT INTO QUERY_ORDERING_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, ORDER_OPERATION, ORDER_RANK, ORDER_DIR, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_ID'),
        'NONE', 0, 'ASC', null
      );

INSERT INTO QUERY_ORDERING_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, ORDER_OPERATION, ORDER_RANK, ORDER_DIR, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'SPRINT_ID'),
        'COUNT', 1, 'ASC', null
      );

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-sprint-count-subquery-to-query-tables', 'lmurat', 'tm/tm.changelog-12.0.0.xml', NOW(), 5, '9:f6cb3b2b3e3d8516e934776c5fc7bf71', 'sql; sql; sql; sql; sql; sql', 'Add new subquery counting sprints to test case search', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-create-table-ai-usage-postgresql::mbrugniere
CREATE TABLE AI_USAGE (AI_USAGE_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, USAGE VARCHAR(100) NOT NULL, CONSTRAINT pk_ai_usage PRIMARY KEY (AI_USAGE_ID), CONSTRAINT uq_ai_usage_usage UNIQUE (USAGE));

INSERT INTO AI_USAGE (USAGE) VALUES ('CLASSIC_TEST_CASE_GENERATION');

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-create-table-ai-usage-postgresql', 'mbrugniere', 'tm/tm.changelog-12.0.0.xml', NOW(), 6, '9:5cf3f3f58f5a856946689c509dc91153', 'createTable tableName=AI_USAGE; insert tableName=AI_USAGE', '', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-create-prompt-set-table-postgresql::dclaerhout
-- Create prompt set table
CREATE TABLE PROMPT_SET (PROMPT_SET_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, NAME VARCHAR(255) NOT NULL, AI_USAGE_ID BIGINT NOT NULL, DESCRIPTION TEXT, CREATED_BY VARCHAR(100) NOT NULL, CREATED_ON TIMESTAMP WITHOUT TIME ZONE NOT NULL, LAST_MODIFIED_BY VARCHAR(100) DEFAULT null, LAST_MODIFIED_ON TIMESTAMP WITHOUT TIME ZONE DEFAULT null, CONSTRAINT pk_prompt_set PRIMARY KEY (PROMPT_SET_ID));

ALTER TABLE PROMPT_SET ADD CONSTRAINT fk_prompt_set_ai_usage FOREIGN KEY (AI_USAGE_ID) REFERENCES AI_USAGE (AI_USAGE_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-create-prompt-set-table-postgresql', 'dclaerhout', 'tm/tm.changelog-12.0.0.xml', NOW(), 7, '9:6972334349f9ebde206290bf5c9e9b5a', 'createTable tableName=PROMPT_SET; addForeignKeyConstraint baseTableName=PROMPT_SET, constraintName=fk_prompt_set_ai_usage, referencedTableName=AI_USAGE', 'Create prompt set table', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-create-index-for-prompt-set-table-postgresql::mbrugniere
CREATE INDEX idx_prompt_set_ai_usage_id ON PROMPT_SET(AI_USAGE_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-create-index-for-prompt-set-table-postgresql', 'mbrugniere', 'tm/tm.changelog-12.0.0.xml', NOW(), 8, '9:5592c87625e564aeb2a8e5f75579e507', 'createIndex indexName=idx_prompt_set_ai_usage_id, tableName=PROMPT_SET', '', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-create-prompt-table-postgresql::dclaerhout
-- Create prompt table
CREATE TABLE PROMPT (PROMPT_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, PROMPT_SET_ID BIGINT NOT NULL, NAME VARCHAR(255) NOT NULL, SYSTEM_PROMPT_TEMPLATE TEXT DEFAULT '' NOT NULL, USER_PROMPT_TEMPLATE TEXT DEFAULT '' NOT NULL, CONSTRAINT pk_prompt PRIMARY KEY (PROMPT_ID), CONSTRAINT fk_prompt_prompt_set FOREIGN KEY (PROMPT_SET_ID) REFERENCES PROMPT_SET(PROMPT_SET_ID));

COMMENT ON COLUMN PROMPT.PROMPT_SET_ID IS 'fk to the parent prompt set';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-create-prompt-table-postgresql', 'dclaerhout', 'tm/tm.changelog-12.0.0.xml', NOW(), 9, '9:6962ce6c6304e27ced6e2597b1387b2c', 'createTable tableName=PROMPT', 'Create prompt table', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-modify-accepted-attachment-extensions-for-automated-test-suite-import::ssviridov
UPDATE CORE_CONFIG SET VALUE = 'txt, html, xml, log' WHERE STR_KEY = 'uploadfilter.fileExtensions.resultImport.whitelist';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-modify-accepted-attachment-extensions-for-automated-test-suite-import', 'ssviridov', 'tm/tm.changelog-12.0.0.xml', NOW(), 10, '9:3fb237bf4f4732c797e375fa293c54f4', 'update tableName=CORE_CONFIG', '', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-create-table-project-ai-configuration-postgresql::mbrugniere
CREATE TABLE PROJECT_AI_CONFIGURATION (PROJECT_AI_CONFIGURATION_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, PROJECT_ID BIGINT NOT NULL, AI_USAGE_ID BIGINT NOT NULL, AI_SERVER_ID BIGINT, PROMPT_SET_ID BIGINT, CONSTRAINT pk_project_ai_configuration PRIMARY KEY (PROJECT_AI_CONFIGURATION_ID));

ALTER TABLE PROJECT_AI_CONFIGURATION ADD CONSTRAINT fk_project_ai_configuration_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT (PROJECT_ID);

ALTER TABLE PROJECT_AI_CONFIGURATION ADD CONSTRAINT fk_project_ai_configuration_ai_usage FOREIGN KEY (AI_USAGE_ID) REFERENCES AI_USAGE (AI_USAGE_ID);

ALTER TABLE PROJECT_AI_CONFIGURATION ADD CONSTRAINT fk_project_ai_configuration_ai_server FOREIGN KEY (AI_SERVER_ID) REFERENCES AI_SERVER (SERVER_ID);

ALTER TABLE PROJECT_AI_CONFIGURATION ADD CONSTRAINT fk_project_ai_configuration_prompt_set FOREIGN KEY (PROMPT_SET_ID) REFERENCES PROMPT_SET (PROMPT_SET_ID);

ALTER TABLE PROJECT_AI_CONFIGURATION ADD CONSTRAINT uq_project_ai_configuration_project_id_ai_usage_id UNIQUE (PROJECT_ID, AI_USAGE_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-create-table-project-ai-configuration-postgresql', 'mbrugniere', 'tm/tm.changelog-12.0.0.xml', NOW(), 11, '9:36252a44c4d29f4019242a9e36b0212c', 'createTable tableName=PROJECT_AI_CONFIGURATION; addForeignKeyConstraint baseTableName=PROJECT_AI_CONFIGURATION, constraintName=fk_project_ai_configuration_project, referencedTableName=PROJECT; addForeignKeyConstraint baseTableName=PROJECT_AI_CONFI...', '', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-create-indexes-for-project-ai-configuration-table::mbrugniere
CREATE INDEX idx_project_ai_configuration_project_id ON PROJECT_AI_CONFIGURATION(PROJECT_ID);

CREATE INDEX idx_project_ai_configuration_ai_usage_id ON PROJECT_AI_CONFIGURATION(AI_USAGE_ID);

CREATE INDEX idx_project_ai_configuration_ai_server_id ON PROJECT_AI_CONFIGURATION(AI_SERVER_ID);

CREATE INDEX idx_project_ai_configuration_prompt_set_id ON PROJECT_AI_CONFIGURATION(PROMPT_SET_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-create-indexes-for-project-ai-configuration-table', 'mbrugniere', 'tm/tm.changelog-12.0.0.xml', NOW(), 12, '9:47f079fe0d0775f86bceec62f4f961ed', 'createIndex indexName=idx_project_ai_configuration_project_id, tableName=PROJECT_AI_CONFIGURATION; createIndex indexName=idx_project_ai_configuration_ai_usage_id, tableName=PROJECT_AI_CONFIGURATION; createIndex indexName=idx_project_ai_configurati...', '', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-modified-on-and-modified-by-columns-to-failure-details::ssviridov
ALTER TABLE FAILURE_DETAIL ADD LAST_MODIFIED_BY VARCHAR(50) DEFAULT null;

ALTER TABLE FAILURE_DETAIL ADD LAST_MODIFIED_ON TIMESTAMP WITHOUT TIME ZONE DEFAULT null;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-modified-on-and-modified-by-columns-to-failure-details', 'ssviridov', 'tm/tm.changelog-12.0.0.xml', NOW(), 13, '9:aef31d7fa1fc4eeb2dd4e3b72da208a1', 'addColumn tableName=FAILURE_DETAIL; addColumn tableName=FAILURE_DETAIL', '', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-change-business-value-in-query_column_prototype-table::bmarejus
-- Change business value to false for item-test-plan-tester query column prototype and to true for item-test-plan-lastexecby
UPDATE QUERY_COLUMN_PROTOTYPE
      SET BUSINESS = FALSE
      WHERE LABEL = 'ITEM_TEST_PLAN_TESTER';

UPDATE QUERY_COLUMN_PROTOTYPE
      SET BUSINESS = TRUE
      WHERE LABEL = 'ITEM_TEST_PLAN_LASTEXECBY';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-change-business-value-in-query_column_prototype-table', 'bmarejus', 'tm/tm.changelog-12.0.0.xml', NOW(), 14, '9:2e46aa3a84acd70c4b80284ed1365903', 'sql; sql', 'Change business value to false for item-test-plan-tester query column prototype and to true for item-test-plan-lastexecby', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0::lmurat
-- Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '12.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0', 'lmurat', 'tm/tm.changelog-12.0.0.xml', NOW(), 15, '9:c53f13fbc283d6aed143ef24fd9ba515', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.31.1', '9608457153');

-- Release Database Lock
UPDATE databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

