/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml.config;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class SamlLoginRedirectFilter
implements Filter {
    private static final String BASIC_AUTH_LOGIN_URL = "/login";
    private final String samlLoginUrl;

    public SamlLoginRedirectFilter(String registrationId) {
        this.samlLoginUrl = "/auth/saml/login/" + registrationId;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uriWithoutContextPath = this.getUriWithoutContextPath(httpRequest);
        if (BASIC_AUTH_LOGIN_URL.equals(uriWithoutContextPath)) {
            String samlLoginUriWithContextPath = this.getSamlLoginUriWithContextPath(httpRequest.getContextPath());
            httpResponse.sendRedirect(samlLoginUriWithContextPath);
            return;
        }
        chain.doFilter(request, response);
    }

    private String getUriWithoutContextPath(HttpServletRequest httpRequest) {
        String uri = httpRequest.getRequestURI();
        String contextPath = httpRequest.getContextPath();
        if (contextPath == null || contextPath.isEmpty() || "/".equals(contextPath)) {
            return uri;
        }
        return uri.substring(contextPath.length());
    }

    private String getSamlLoginUriWithContextPath(String contextPath) {
        if (contextPath.isEmpty() || "/".equals(contextPath)) {
            return this.samlLoginUrl;
        }
        return "%s%s".formatted(contextPath, this.samlLoginUrl);
    }
}

