/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.jackson;

import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.plugin.rest.core.exception.UnbalancedFilterExpressionException;
import org.squashtest.tm.plugin.rest.core.jackson.FilterExpression;

public class FilterExpressionBuilder {
    private static final String SPLIT_EXPR = "((?<=[\\[\\],])|(?=[\\[\\],]))";
    private static final String OPEN_SUBCONTEXT = "[";
    private static final String CLOSE_SUBCONTEXT = "]";
    private static final String SEPARATOR = ",";
    private FilterExpression properties;
    private int depth = 0;
    private LinkedList<String> tokens;
    private String currentProperty = null;
    private FilterExpression currentValue = null;
    private boolean subcontextClosed = false;

    public static FilterExpression from(String expression) {
        FilterExpressionBuilder parser = new FilterExpressionBuilder(FilterExpressionBuilder.tokenize(expression));
        parser.process();
        return parser.getProperties();
    }

    private FilterExpressionBuilder() {
    }

    private static final LinkedList<String> tokenize(String dirtyExpression) {
        String expression = dirtyExpression.replaceAll("\\s", "");
        if (StringUtils.isBlank((CharSequence)expression)) {
            return new LinkedList<String>();
        }
        String[] tokens = expression.split(SPLIT_EXPR);
        LinkedList<String> tokenList = new LinkedList<String>();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            tokenList.add(tok);
            ++n2;
        }
        return tokenList;
    }

    private FilterExpressionBuilder(LinkedList<String> tokens) {
        this(tokens, 0);
    }

    private FilterExpressionBuilder(LinkedList<String> tokens, int depth) {
        this.tokens = tokens;
        this.depth = depth;
    }

    public FilterExpression getProperties() {
        return this.properties;
    }

    public boolean hasTerminatedNormally() {
        if (this.depth == 0) {
            return this.tokens.isEmpty();
        }
        return this.subcontextClosed;
    }

    public void process() {
        block10: while (!this.tokens.isEmpty()) {
            String token;
            switch (token = this.tokens.removeFirst()) {
                case ",": {
                    this.storeProperty();
                    break;
                }
                case "[": {
                    FilterExpressionBuilder subcontext = new FilterExpressionBuilder(this.tokens, this.depth + 1);
                    subcontext.process();
                    this.currentValue = subcontext.getProperties();
                    break;
                }
                case "]": {
                    this.subcontextClosed = true;
                    break block10;
                }
                default: {
                    this.currentProperty = token;
                    this.currentValue = null;
                }
            }
        }
        this.storeProperty();
        if (!this.hasTerminatedNormally()) {
            throw new UnbalancedFilterExpressionException("unbalanced expression");
        }
    }

    private void storeProperty() {
        if (this.currentProperty == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new FilterExpression();
        }
        this.properties.put(this.currentProperty, this.currentValue);
        this.currentProperty = null;
        this.currentValue = null;
    }
}

