/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.webhook;

import jakarta.inject.Named;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;
import org.squashtest.tm.plugin.xsquash4gitlab.concurrency.SynchronisedSectionWrapper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.webhook.IssueWebhookAsyncWorker;
import org.squashtest.tm.plugin.xsquash4gitlab.service.webhook.IssueWebhookEventInfo;
import org.squashtest.tm.plugin.xsquash4gitlab.service.webhook.IssueWebhookService;

@Service
public class IssueWebhookServiceImpl
implements IssueWebhookService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssueWebhookServiceImpl.class);
    private static final Duration BUFFER_DELAY = Duration.ofSeconds(5L);
    private final ConcurrentLinkedQueue<IssueWebhookEventInfo> eventQueue = new ConcurrentLinkedQueue();
    private boolean isProcessScheduled;
    private final IssueWebhookAsyncWorker asyncWorker;
    private final TaskScheduler taskScheduler;
    private final SynchronisedSectionWrapper synchronisedSectionWrapper;

    public IssueWebhookServiceImpl(IssueWebhookAsyncWorker asyncWorker, @Named(value="squashtest.tm.service.ThreadPoolTaskScheduler") TaskScheduler taskScheduler, SynchronisedSectionWrapper synchronisedSectionWrapper) {
        this.asyncWorker = asyncWorker;
        this.taskScheduler = taskScheduler;
        this.synchronisedSectionWrapper = synchronisedSectionWrapper;
    }

    @Override
    public void appendToQueue(IssueWebhookEventInfo event) {
        if (!this.eventQueue.contains(event)) {
            this.eventQueue.add(event);
            LOGGER.trace("New webhook event queued.");
        }
        this.scheduleBackgroundProcess();
    }

    private void scheduleBackgroundProcess() {
        if (this.isProcessScheduled || this.eventQueue.isEmpty()) {
            return;
        }
        this.taskScheduler.schedule(this.synchronisedSectionWrapper.wrapAsSynchronisedSection(this::startBackgroundProcess), Instant.now().plus(BUFFER_DELAY));
        this.isProcessScheduled = true;
    }

    public void startBackgroundProcess() {
        if (this.hasQueuedEvents()) {
            LOGGER.trace("Starting background processing of queued events.");
            List<IssueWebhookEventInfo> queueCopy = this.popQueueItems();
            this.asyncWorker.processQueue(queueCopy, this::handleBackgroundProcessTermination);
        }
    }

    public boolean hasQueuedEvents() {
        return !this.eventQueue.isEmpty();
    }

    private List<IssueWebhookEventInfo> popQueueItems() {
        ArrayList<IssueWebhookEventInfo> copy = new ArrayList<IssueWebhookEventInfo>(this.eventQueue);
        this.eventQueue.clear();
        return copy;
    }

    private void handleBackgroundProcessTermination() {
        this.isProcessScheduled = false;
        this.scheduleBackgroundProcess();
    }
}

