/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.graphql.client;

import java.util.Optional;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabIssueConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetIssueByIdQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetIssueCommunityByIdQuery;

public class GitLabIssueClient {
    private final GitLabClient gitLabClient;

    public GitLabIssueClient(GitLabClient gitLabClient) {
        this.gitLabClient = gitLabClient;
    }

    public Optional<GitLabIssue> findIssueByGlobalIdPremium(String globalId) {
        GetIssueByIdQuery query = GetIssueByIdQuery.builder().id(globalId).build();
        return this.gitLabClient.executeAndConvert(query, (data, topLevelErrors) -> GitLabIssueConverter.convertSingleIssuePremium(data));
    }

    public Optional<GitLabIssue> findIssueByGlobalIdCommunity(String globalId) {
        GetIssueCommunityByIdQuery query = GetIssueCommunityByIdQuery.builder().id(globalId).build();
        return this.gitLabClient.executeAndConvert(query, (data, topLevelErrors) -> GitLabIssueConverter.convertSingleIssueCommunity(data));
    }

    public Optional<GitLabIssue> findIssueByGlobalIdOnUndeterminedInstanceType(String globalId) {
        return this.findIssueByGlobalIdPremium(globalId).or(() -> this.findIssueByGlobalIdCommunity(globalId));
    }
}

