/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.openid.connect.licensevalidator.service.impl;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.squashtest.tm.plugin.openid.connect.licensevalidator.com.license4j.License;
import org.squashtest.tm.plugin.openid.connect.licensevalidator.com.license4j.LicenseValidator;
import org.squashtest.tm.plugin.openid.connect.licensevalidator.com.license4j.exceptions.LicenseSecurityException;
import org.squashtest.tm.plugin.openid.connect.licensevalidator.com.license4j.util.FileUtils;
import org.squashtest.tm.plugin.openid.connect.licensevalidator.dto.LicenseInfo;
import org.squashtest.tm.plugin.openid.connect.licensevalidator.exception.SquashLicenseValidatorException;
import org.squashtest.tm.plugin.openid.connect.licensevalidator.service.ValidationService;
import org.squashtest.tm.plugin.openid.connect.licensevalidator.service.helper.DateHelper;
import org.squashtest.tm.plugin.openid.connect.licensevalidator.service.helper.ValidationHelper;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.internal.repository.UserDao;

public class ValidationServiceImpl
implements ValidationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationServiceImpl.class);
    private static final String PUBLIC_KEY = "/org/squashtest/tm/plugin/openid/connect/licensevalidator/squash-tm.pub";
    private static final String PRODUCT_ID = "Squash-TM";
    private static final String TRUE_VALUE = "true";
    private static final String FALSE_VALUE = "false";
    private static final int TWO_MONTH_TOLERANCE_PERIOD = -61;
    @Value(value="${squash.path.plugins-path}")
    private String pluginsPath;
    private ApplicationContext appCtx;
    private UserDao userDao;
    private ConfigurationService confService;
    private DateHelper dateHelper = DateHelper.INSTANCE;
    private ValidationHelper validationHelper = ValidationHelper.INSTANCE;
    @Inject
    private Environment environment;

    @Override
    public License validateLicense(String encodedLicense) {
        String publicKey = null;
        Boolean isLogUsed = Boolean.valueOf(this.environment.getProperty("squash.validator.log.activate"));
        try {
            if (isLogUsed.booleanValue()) {
                LOGGER.debug("Retrieving public key");
            }
            publicKey = this.readPublicKeyFromResources();
        }
        catch (IOException e) {
            LOGGER.error("Error occurs while reading Squash public key.", (Throwable)e);
            return null;
        }
        return LicenseValidator.validate(encodedLicense, publicKey, PRODUCT_ID, null, null, this.dateHelper.getCurrentDate(), null);
    }

    @Override
    public String readLicenseFile(String path) {
        String encodedLicense = null;
        Boolean isLogUsed = Boolean.valueOf(this.environment.getProperty("squash.validator.log.activate"));
        try {
            if (isLogUsed.booleanValue()) {
                LOGGER.debug("Retrieving for license file in {}", (Object)path);
            }
            encodedLicense = FileUtils.readFile(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (isLogUsed.booleanValue()) {
                LOGGER.debug("No license file found on path {}", (Object)path);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error occurs while reading Squash license file.", (Throwable)e);
        }
        return encodedLicense;
    }

    @Override
    public void validateLicenseForPlugin(@NotNull License license, String plugin) throws LicenseSecurityException {
        Boolean isLogUsed = Boolean.valueOf(this.environment.getProperty("squash.validator.log.activate"));
        this.isLicenseValid(license);
        this.validationHelper.isCurrentPluginAllowed(license, plugin, isLogUsed);
        if (isLogUsed.booleanValue()) {
            LOGGER.debug("Validation process complete, {} is included in the license plan", (Object)plugin);
        }
    }

    @Override
    public LicenseInfo getLicenseInfo(@NotNull License license) {
        int maxUsers = this.validationHelper.getMaxAllowedUsersInLicense(license);
        Date expirationDate = license.getLicenseText().getLicenseExpireDate();
        Map<String, Boolean> licensePlugins = this.getLicensePlugins(license);
        boolean isValidLicense = this.isValidLicense(expirationDate);
        return new LicenseInfo(maxUsers, expirationDate, licensePlugins, isValidLicense);
    }

    @Override
    public boolean isValidLicense(@NotNull License license) {
        Date expirationDate = license.getLicenseText().getLicenseExpireDate();
        return this.isValidLicense(expirationDate);
    }

    private boolean isValidLicense(Date expirationDate) {
        return !this.isLicenseExpiredForMoreThanTwoMonth(this.dateHelper.convertDateToLocalDate(expirationDate));
    }

    @Override
    public boolean isPluginEnabled(@NotNull License license, String key) {
        return Boolean.parseBoolean(license.getLicenseText().getCustomSignedFeatures().get(key));
    }

    @Override
    public String getLicenseType(@NotNull License license) {
        return license.getLicenseText().getCustomSignedFeatures().get("license-type");
    }

    private Map<String, Boolean> getLicensePlugins(License license) {
        HashMap<String, Boolean> licensePlugins = new HashMap<String, Boolean>();
        HashMap<String, String> customSignedFeatures = license.getLicenseText().getCustomSignedFeatures();
        customSignedFeatures.forEach((key, value) -> this.populateLicencePlugins((String)key, (String)value, (Map<String, Boolean>)licensePlugins));
        return licensePlugins;
    }

    private void populateLicencePlugins(String key, String value, Map<String, Boolean> licensePlugins) {
        if (TRUE_VALUE.equals(value) || FALSE_VALUE.equals(value)) {
            licensePlugins.put(key, Boolean.parseBoolean(value));
        }
    }

    private boolean isLicenseExpiredForMoreThanTwoMonth(LocalDate expirationDate) {
        long remaining_days = this.dateHelper.getCurrentLocalDate().until(expirationDate, ChronoUnit.DAYS);
        return remaining_days < -61L;
    }

    @Override
    public void checkExpirationDate(LocalDate expirationDate) throws LicenseSecurityException {
        Boolean isLogUsed = Boolean.valueOf(this.environment.getProperty("squash.validator.log.activate"));
        long remaining_days = this.dateHelper.getCurrentLocalDate().until(expirationDate, ChronoUnit.DAYS);
        if (remaining_days > 0L) {
            if (remaining_days < 61L) {
                this.createOrUpdateRemainingDays(remaining_days);
            } else {
                this.resetRemainingDays();
            }
            if (isLogUsed.booleanValue()) {
                LOGGER.debug("License expires in {} days.", (Object)remaining_days);
            }
        } else {
            if (isLogUsed.booleanValue()) {
                LOGGER.debug("License has expired for {} days.", (Object)Math.abs(remaining_days));
            }
            this.createOrUpdateRemainingDays(remaining_days);
            if (remaining_days < -61L) {
                throw new LicenseSecurityException("License has expired more than two months.");
            }
        }
    }

    @Override
    public void checkTotalActivatedUsers(License license) {
        int maxAllowed = this.validationHelper.getMaxAllowedUsersInLicense(license);
        int userCount = this.userDao.countAllActiveUsers();
        if ((long)userCount > Math.round((double)maxAllowed * 1.2)) {
            LOGGER.warn("Current license indicates the number of maximum activated users allowed is {}, but there are {} activated users in database", (Object)maxAllowed, (Object)userCount);
            this.createOrUpdateUserExcessInDatabase(userCount, maxAllowed, false);
        } else if (userCount > maxAllowed) {
            LOGGER.warn("Current license indicates the number of maximum activated users allowed is {}, but there are {} activated users in database", (Object)maxAllowed, (Object)userCount);
            this.createOrUpdateUserExcessInDatabase(userCount, maxAllowed, true);
        } else {
            this.resetUserExcessInDatabase();
        }
    }

    @Override
    public void shutDownApp() {
        if (this.appCtx != null) {
            ((ConfigurableApplicationContext)this.appCtx).close();
        }
        throw new SquashLicenseValidatorException("The license validation for Squash TM has failed, shutting down...");
    }

    private String readPublicKeyFromResources() throws IOException {
        Boolean isLogUsed = Boolean.valueOf(this.environment.getProperty("squash.validator.log.activate"));
        URL url = this.getClass().getResource(PUBLIC_KEY);
        if (isLogUsed.booleanValue()) {
            LOGGER.debug("Begin to retrieving file from {} ...", (Object)url.getPath());
        }
        String result = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        return result.replace("\n", "").replace("\r", "");
    }

    private void isLicenseValid(License license) throws LicenseSecurityException {
        Boolean isLogUsed = Boolean.valueOf(this.environment.getProperty("squash.validator.log.activate"));
        switch (license.getValidationStatus()) {
            case LICENSE_VALID: {
                if (isLogUsed.booleanValue() && LOGGER.isDebugEnabled()) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    LOGGER.debug("License is valid till {}", (Object)df.format(license.getLicenseText().getLicenseExpireDate()));
                }
                this.checkExpirationDate(this.dateHelper.convertDateToLocalDate(license.getLicenseText().getLicenseExpireDate()));
                break;
            }
            case LICENSE_INVALID: {
                throw new LicenseSecurityException("License file is not valid.");
            }
            case LICENSE_EXPIRED: {
                LocalDate expiredDate = this.dateHelper.convertDateToLocalDate(license.getLicenseText().getLicenseExpireDate());
                LOGGER.info("License has expired since {}", (Object)expiredDate);
                this.checkExpirationDate(expiredDate);
                break;
            }
            default: {
                throw new LicenseSecurityException("Errors occurs when validating the license file.");
            }
        }
    }

    private void createOrUpdateRemainingDays(long remainingDays) {
        Boolean isLogUsed = Boolean.valueOf(this.environment.getProperty("squash.validator.log.activate"));
        String remainingDaysParamValue = this.confService.findConfiguration("plugin.license.expiration");
        if (remainingDaysParamValue != null) {
            if (remainingDaysParamValue.isEmpty() || !Long.valueOf(remainingDaysParamValue).equals(remainingDays)) {
                if (isLogUsed.booleanValue()) {
                    LOGGER.debug("Update remaining days : {}", (Object)remainingDays);
                }
                this.confService.updateConfiguration("plugin.license.expiration", String.valueOf(remainingDays));
            }
        } else {
            if (isLogUsed.booleanValue()) {
                LOGGER.debug("Create remaining days : {}", (Object)remainingDays);
            }
            this.confService.createNewConfiguration("plugin.license.expiration", String.valueOf(remainingDays));
        }
    }

    private void resetRemainingDays() {
        Boolean isLogUsed = Boolean.valueOf(this.environment.getProperty("squash.validator.log.activate"));
        String remainingDaysParamValue = this.confService.findConfiguration("plugin.license.expiration");
        if (remainingDaysParamValue != null && !remainingDaysParamValue.isEmpty()) {
            if (isLogUsed.booleanValue()) {
                LOGGER.debug("Reset of {} parameter value in database", (Object)"plugin.license.expiration");
            }
            this.confService.updateConfiguration("plugin.license.expiration", "");
        }
    }

    private void createOrUpdateUserExcessInDatabase(int currentActiveUsersNumber, int maxAllowed, boolean userCreationAllowed) {
        Boolean isLogUsed = Boolean.valueOf(this.environment.getProperty("squash.validator.log.activate"));
        String maxUsersConfigParamValue = this.confService.findConfiguration("activated.user.excess");
        String newConfigurationParamValue = "%s-%s-%s".formatted(String.valueOf(currentActiveUsersNumber), String.valueOf(maxAllowed), userCreationAllowed);
        if (maxUsersConfigParamValue != null) {
            if (!newConfigurationParamValue.equals(maxUsersConfigParamValue)) {
                if (isLogUsed.booleanValue()) {
                    LOGGER.debug("Update max users excess : {}", (Object)currentActiveUsersNumber);
                }
                this.confService.updateConfiguration("activated.user.excess", newConfigurationParamValue);
            }
        } else {
            if (isLogUsed.booleanValue()) {
                LOGGER.debug("Create max users allowed : {}", (Object)currentActiveUsersNumber);
            }
            this.confService.createNewConfiguration("activated.user.excess", newConfigurationParamValue);
        }
    }

    private void resetUserExcessInDatabase() {
        Boolean isLogUsed = Boolean.valueOf(this.environment.getProperty("squash.validator.log.activate"));
        String maxUsersConfigParamValue = this.confService.findConfiguration("activated.user.excess");
        if (maxUsersConfigParamValue != null && !maxUsersConfigParamValue.isEmpty()) {
            if (isLogUsed.booleanValue()) {
                LOGGER.debug("Reset of {} parameter value in database", (Object)"activated.user.excess");
            }
            this.confService.updateConfiguration("activated.user.excess", "");
        }
    }

    @Inject
    public void setAppCtx(ApplicationContext appCtx) {
        this.appCtx = appCtx;
    }

    @Inject
    @Lazy
    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    @Inject
    @Lazy
    public void setConfService(ConfigurationService confService) {
        this.confService = confService;
    }
}

