/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators.helper;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.IdCollector;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.TestPlanItemDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestSuiteDto;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.plugin.rest.validators.helper.RestNodeValidationHelper;
import org.squashtest.tm.service.internal.repository.IterationDao;

@Component
public class TestSuiteValidationHelper
extends RestNodeValidationHelper {
    @Inject
    private IterationDao iterationDao;
    @Inject
    private CustomFieldValueHelper customFieldValueHelper;

    public void validateIterationAndItem(TestSuiteDto testSuiteDto, Errors errors) {
        Long iterationId = testSuiteDto.getParent().getId();
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId.longValue());
        if (iteration == null) {
            String message = "No entity known for type %s and id %d".formatted(new Object[]{RestType.ITERATION, iterationId});
            errors.rejectValue("id", "invalid id", message);
        }
        if (!errors.hasErrors()) {
            testSuiteDto.setProject(iteration.getCampaign().getProject());
        }
        if (!errors.hasErrors() && testSuiteDto.isHasListTpi()) {
            List listTestSuiteByIdIter = iteration.getTestPlan().getTestPlanItems();
            Collection listId = CollectionUtils.collect((Collection)listTestSuiteByIdIter, (Transformer)new IdCollector());
            List<TestPlanItemDto> listTpiDto = testSuiteDto.getListTpi();
            Collection listIdDto = listTpiDto.stream().map(TestPlanItemDto::getId).collect(Collectors.toList());
            List listIdDifferent = (List)CollectionUtils.subtract((Collection)listIdDto, (Collection)listId);
            StringBuilder msgErrorsBuilder = new StringBuilder();
            for (Long id : listIdDifferent) {
                msgErrorsBuilder.append("Iteration ").append(iterationId).append(" has no test plan item  ").append(id).append("\n");
            }
            String msgErrors = msgErrorsBuilder.toString();
            if (!msgErrors.isEmpty()) {
                errors.rejectValue("listTpi", "invalid value", msgErrors);
            }
        }
    }

    public void checkCufs(Errors errors, TestSuiteDto testSuiteDto) {
        this.customFieldValueHelper.checkCufs(errors, BindableEntity.TEST_SUITE, testSuiteDto.getProject().getId(), testSuiteDto.getCustomFields(), testSuiteDto.getId());
    }
}

