/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.glassfish.jersey.innate;

import gitlabbt.org.glassfish.jersey.CommonProperties;
import gitlabbt.org.glassfish.jersey.innate.VirtualThreadSupport;
import gitlabbt.org.glassfish.jersey.innate.virtual.LoomishExecutors;
import gitlabbt.org.glassfish.jersey.innate.virtual.ThreadFactoryBuilder;
import jakarta.ws.rs.core.Configuration;
import java.util.concurrent.ThreadFactory;

public final class VirtualThreadUtil {
    private static final boolean USE_VIRTUAL_THREADS_BY_DEFAULT = false;

    public static ThreadFactoryBuilder threadFactoryBuilder(String prefix, long start) {
        return new ThreadFactoryBuilder().prefix(prefix).start(start);
    }

    private VirtualThreadUtil() {
        throw new IllegalStateException();
    }

    public static LoomishExecutors withConfig(Configuration config) {
        return VirtualThreadUtil.withConfig(config, false);
    }

    public static LoomishExecutors withConfig(Configuration config, boolean useVirtualByDefault) {
        return VirtualThreadUtil.withConfig(config, null, useVirtualByDefault);
    }

    public static LoomishExecutors withConfig(Configuration config, ThreadFactoryBuilder threadFactoryBuilder, boolean useVirtualByDefault) {
        ThreadFactory tfThreadFactory = null;
        boolean useVirtualThreads = VirtualThreadUtil.useVirtualThreads(config, useVirtualByDefault);
        if (config != null) {
            Object threadFactory = config.getProperty(CommonProperties.THREAD_FACTORY);
            if (threadFactory != null && ThreadFactory.class.isInstance(threadFactory)) {
                tfThreadFactory = (ThreadFactory)threadFactory;
            } else if (threadFactoryBuilder != null) {
                return VirtualThreadSupport.allowVirtual(useVirtualThreads, threadFactoryBuilder);
            }
        }
        return tfThreadFactory == null ? VirtualThreadSupport.allowVirtual(useVirtualThreads) : VirtualThreadSupport.allowVirtual(useVirtualThreads, tfThreadFactory);
    }

    private static boolean useVirtualThreads(Configuration config, boolean useByDefault) {
        boolean bUseVirtualThreads = useByDefault;
        if (config != null) {
            Object useVirtualThread = config.getProperty(CommonProperties.USE_VIRTUAL_THREADS);
            if (useVirtualThread != null && Boolean.class.isInstance(useVirtualThread)) {
                bUseVirtualThreads = (Boolean)useVirtualThread;
            }
            if (useVirtualThread != null && String.class.isInstance(useVirtualThread)) {
                bUseVirtualThreads = Boolean.parseBoolean(useVirtualThread.toString());
            }
        }
        return bUseVirtualThreads;
    }
}

