/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.synchronisation.service;

import jakarta.inject.Provider;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.workflow.automjira.client.JiraClient;
import org.squashtest.tm.plugin.workflow.automjira.helpers.LocaleWithFallback;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.RemoteIssueFinderService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import workflowautomjira.com.atlassian.jira.rest.client.api.RestClientException;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Issue;

@Service
@Transactional
public class RemoteIssueFinderServiceImpl
implements RemoteIssueFinderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteIssueFinderServiceImpl.class);
    private final Provider<JiraClient> provider;
    private final InternationalizationHelper i18nHelper;
    private final Locale locale;

    public RemoteIssueFinderServiceImpl(Provider<JiraClient> provider, InternationalizationHelper i18nHelper) {
        this.provider = provider;
        this.i18nHelper = i18nHelper;
        this.locale = LocaleWithFallback.getLocaleWithFallback();
    }

    @Override
    public Issue findRemoteIssueByKey(String remoteIssueKey, BugTracker bugtracker) {
        Issue remoteIssue;
        try (JiraClient jiraClient = (JiraClient)this.provider.get();){
            try {
                jiraClient.jiraClientAuthentication(bugtracker);
                remoteIssue = jiraClient.getIssueJira(remoteIssueKey);
            }
            catch (BugTrackerNoCredentialsException ex) {
                String message = this.i18nHelper.internationalize("thirdpartyserver.admin.messages.testcreds.fail", this.locale);
                throw new BugTrackerNoCredentialsException(message, (Throwable)ex);
            }
            catch (RestClientException e) {
                String message = this.i18nHelper.internationalize("workflow.automation.jira.ticket.not-exist", this.locale);
                remoteIssue = null;
                LOGGER.error("[AUTOM-JIRA-SYNC] - Server id: {} name: {} - {}: {}", new Object[]{bugtracker.getId(), bugtracker.getName(), message, remoteIssueKey, e});
                jiraClient.close();
            }
        }
        return remoteIssue;
    }
}

