/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.utils;

import com.taskadapter.redmineapi.bean.CustomField;
import java.util.ArrayList;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;

public final class CustomFieldsUtils {
    private static final String NONE_BOOLEAN_VALUE_ID = "-1";

    private CustomFieldsUtils() {
    }

    public static void setValueForCustomList(FieldValue value, CustomField c) {
        if (CustomFieldsUtils.isMultipleCustom(value)) {
            CustomFieldsUtils.setValueForCustomMultiSelectList(value, c);
        } else {
            CustomFieldsUtils.setValueForCustomSingleSelectList(value, c);
        }
    }

    public static void setValueForCustomBool(FieldValue value, CustomField c) {
        if (NONE_BOOLEAN_VALUE_ID.equals(value.getId())) {
            return;
        }
        if ("true".equals(value.getId())) {
            c.setValue("1");
        } else {
            c.setValue("0");
        }
    }

    public static void setValueForCustomVersion(FieldValue value, CustomField c) {
        CustomFieldsUtils.setValueForCustomVersionOrUser(value, c);
    }

    public static void setValueForCustomUser(FieldValue value, CustomField c) {
        CustomFieldsUtils.setValueForCustomVersionOrUser(value, c);
    }

    private static void setValueForCustomVersionOrUser(FieldValue value, CustomField c) {
        if (CustomFieldsUtils.isMultipleCustom(value)) {
            CustomFieldsUtils.setValueForCustomMultiSelectVersionOrUser(value, c);
        } else {
            CustomFieldsUtils.setValueForCustomSingleSelectVersionOrUser(value, c);
        }
    }

    private static void setValueForCustomSingleSelectVersionOrUser(FieldValue value, CustomField c) {
        if (CustomFieldsUtils.isEmptyValue(value)) {
            c.setValue("");
        } else {
            c.setValue(value.getId());
        }
    }

    private static void setValueForCustomMultiSelectVersionOrUser(FieldValue value, CustomField c) {
        FieldValue[] fieldValues;
        ArrayList<String> liste = new ArrayList<String>();
        FieldValue[] fieldValueArray = fieldValues = value.getComposite();
        int n = fieldValues.length;
        int n2 = 0;
        while (n2 < n) {
            FieldValue v = fieldValueArray[n2];
            if (!NONE_BOOLEAN_VALUE_ID.equals(v.getId())) {
                liste.add(v.getId());
            }
            ++n2;
        }
        if (fieldValues.length == 0 || fieldValues.length == 1 && NONE_BOOLEAN_VALUE_ID.equals(fieldValues[0].getId())) {
            liste.add("");
        }
        c.setValues(liste);
    }

    private static boolean isMultipleCustom(FieldValue value) {
        return value.hasCompositeValue() || value.getScalar().isEmpty();
    }

    private static boolean isEmptyValue(FieldValue value) {
        return NONE_BOOLEAN_VALUE_ID.equals(value.getId());
    }

    private static void setValueForCustomSingleSelectList(FieldValue value, CustomField c) {
        if (CustomFieldsUtils.isEmptyValue(value)) {
            c.setValue("");
        } else {
            c.setValue(value.getScalar());
        }
    }

    private static void setValueForCustomMultiSelectList(FieldValue value, CustomField c) {
        FieldValue[] fieldValues;
        ArrayList<String> liste = new ArrayList<String>();
        FieldValue[] fieldValueArray = fieldValues = value.getComposite();
        int n = fieldValues.length;
        int n2 = 0;
        while (n2 < n) {
            FieldValue v = fieldValueArray[n2];
            if (!NONE_BOOLEAN_VALUE_ID.equals(v.getId())) {
                liste.add(v.getScalar());
            }
            ++n2;
        }
        if (fieldValues.length == 0 || fieldValues.length == 1 && NONE_BOOLEAN_VALUE_ID.equals(fieldValues[0].getId())) {
            liste.add("");
        }
        c.setValues(liste);
    }
}

