/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.sal.api.features;

import com.google.common.base.Predicate;
import java.util.regex.Pattern;
import jirarest.com.atlassian.sal.api.features.InvalidFeatureKeyException;
import jirarest.javax.annotation.Nullable;
import jirarest.javax.annotation.concurrent.Immutable;

@Immutable
public enum ValidFeatureKeyPredicate implements Predicate<String>
{
    INSTANCE;

    private static final Pattern VALID_FEATURE_KEY_PATTERN;

    public static boolean isValidFeatureKey(@Nullable String input) {
        return INSTANCE.apply(input);
    }

    public static String checkFeatureKey(@Nullable String input) {
        if (ValidFeatureKeyPredicate.isValidFeatureKey(input)) {
            return input;
        }
        throw new InvalidFeatureKeyException("Invalid feature key: '" + input + "'");
    }

    public boolean apply(@Nullable String input) {
        return input != null && VALID_FEATURE_KEY_PATTERN.matcher(input).matches();
    }

    static {
        VALID_FEATURE_KEY_PATTERN = Pattern.compile("[\\w\\.\\-]+");
    }
}

