/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.promptset.PromptSet;
import org.squashtest.tm.plugin.rest.admin.jackson.model.PromptSetDto;
import org.squashtest.tm.plugin.rest.admin.service.RestPromptSetService;
import org.squashtest.tm.plugin.rest.admin.service.patcher.PromptSetPatcher;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.internal.repository.PromptSetDao;
import org.squashtest.tm.service.promptset.PromptSetManagerService;

@Service
@Transactional
public class RestPromptSetServiceImpl
implements RestPromptSetService {
    private final PromptSetDao promptSetDao;
    private final PromptSetManagerService promptSetManagerService;
    private final PromptSetPatcher promptSetPatcher;

    public RestPromptSetServiceImpl(PromptSetDao promptSetDao, PromptSetManagerService promptSetManagerService, PromptSetPatcher promptSetPatcher) {
        this.promptSetDao = promptSetDao;
        this.promptSetManagerService = promptSetManagerService;
        this.promptSetPatcher = promptSetPatcher;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public PromptSet findPromptSetById(Long promptSetId) {
        return (PromptSet)this.promptSetDao.getReferenceById((Object)promptSetId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public Page<PromptSet> getAllPromptSets(Pageable pageable) {
        return this.promptSetDao.findAll(pageable);
    }

    @Override
    @IsUltimateLicenseAvailable
    public void deletePromptSets(List<Long> promptSetIds) {
        this.promptSetManagerService.delete(promptSetIds);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public PromptSet addPromptSet(PromptSetDto promptSetDto) {
        return this.promptSetManagerService.createPromptSet(promptSetDto.getName(), promptSetDto.getDescription(), promptSetDto.getAiUse());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public PromptSet updatePromptSet(Long promptSetId, PromptSetDto promptSetDto) {
        PromptSet promptSet = (PromptSet)this.promptSetDao.getReferenceById((Object)promptSetId);
        this.promptSetPatcher.patch(promptSet, promptSetDto);
        return promptSet;
    }
}

