#! /bin/sh
#
#     This file is part of the Squashtest platform.
#     Copyright (C) Henix, henix.fr
#
#     See the NOTICE file distributed with this work for additional
#     information regarding copyright ownership.
#
#     This is free software: you can redistribute it and/or modify
#     it under the terms of the GNU Lesser General Public License as published by
#     the Free Software Foundation, either version 3 of the License, or
#     (at your option) any later version.
#
#     this software is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public License
#     along with this software.  If not, see <http://www.gnu.org/licenses/>.
#

#That script will :
#- check that the java environnement exists,
#- the version is adequate,
#- will run the application

#####################################################################################################
# !!! IF YOU MAKE ANY CHANGES TO THIS FILE, UPDATE THE install-script.sh FILE OF DOCKER PROJECT !!! #
#####################################################################################################

# Default variables
JAR_NAME="../bundles/squash-tm.war"  # Java main library
# Directory variables
TMP_DIR=../tmp                             # Tmp and work directory
CONF_DIR=../conf                           # Configurations directory
LOG_DIR=../logs                            # Log directory

## Only indicate the major version, do not indicate a minor version
JAVA_REQUIRED_VERSION=21
# Extra Java args
JAVA_ARGS="-Xms128m -Xmx2048m"


# Test if java exists
echo -n "$0 : checking java environment... ";

java_exists=`java -version 2>&1`;

if [ $? -eq 127 ]
then
    echo;
    echo "$0 : Error : java not found. Please ensure that java is installed in \$PATH";
    exit -1;
fi

echo "done";

# Create logs and tmp directories if necessary
if [ ! -e "$LOG_DIR" ]; then
    mkdir $LOG_DIR
fi

if [ ! -e "$TMP_DIR" ]; then
    mkdir $TMP_DIR
fi

# Test if the version is high enough
echo -n "checking version... ";

java_version=$(echo "$java_exists" | awk -F '"' '/version/ {print $2}' | cut -d '.' -f1)

if [ $java_version -lt $JAVA_REQUIRED_VERSION ]
then
    echo;
    echo "$0 : Error : your JRE does not meet the requirements. Required version: ${JAVA_REQUIRED_VERSION}.";
    exit 1;
fi

echo  "done";


# Let's go !
echo "$0 : starting Squash TM... ";

ARGS="${JAVA_ARGS} -Duser.language=en ${JAVA_TOOL_OPTIONS} -Djava.io.tmpdir=${TMP_DIR} -Dlogging.dir=${LOG_DIR} ${SQUASH_JAVA_ARGS} -jar ${JAR_NAME} --spring.config.additional-location=${CONF_DIR}/ --spring.config.name=application,squash.tm.cfg --logging.config=${CONF_DIR}/log4j2.xml"

exec java ${ARGS}

