/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ManageableBasicAuthCredentialsDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ManageableCredentialsDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ManageableCredentialsDtoVisitor;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ManageableTokenAuthCredentialsDto;
import org.squashtest.tm.plugin.rest.admin.validators.HelpValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.service.internal.repository.BugTrackerDao;
import org.squashtest.tm.service.internal.repository.ScmServerDao;
import org.squashtest.tm.service.servers.ManageableCredentials;

@Component
public class CredentialsValidator
implements Validator {
    private static final String POST_BUGTRACKER_CREDENTIALS = "post-bugtracker-credentials";
    private static final String POST_TEST_AUTOMATION_CREDENTIALS = "post-test-automation-credentials";
    private static final String POST_SCM_SERVER_CREDENTIALS = "post-scm-server-credentials";
    private static final String POST_AI_SERVER_CREDENTIALS = "post-ai-server-credentials";
    public static final String NO_ENTITY_FOR_TYPE_AND_ID = "No entity known for type %s and id %d";
    private static final String WRONG_TYPE_ERROR_CODE = "wrong type";
    private static final String TYPE_FIELD = "_type";
    @PersistenceContext
    protected EntityManager entityManager;
    @Inject
    private HelpValidator helpValidator;
    @Inject
    private BugTrackerDao bugTrackerDao;
    @Inject
    private ScmServerDao scmServerDao;

    public boolean supports(Class<?> aClass) {
        return ManageableCredentials.class.equals(aClass);
    }

    public void validate(Object target, Errors errors) {
    }

    public void validatePostCredentialsForBugTracker(Long bugtrackerId, ManageableCredentialsDto credentialsDto) throws BindException {
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)credentialsDto, POST_BUGTRACKER_CREDENTIALS);
        BugTracker bugTracker = (BugTracker)this.entityManager.find(BugTracker.class, (Object)bugtrackerId);
        this.checkIfServerExists(bugtrackerId, Objects.isNull(bugTracker), (BindingResult)validationBean, "bug-tracker");
        if (Objects.nonNull(bugTracker)) {
            CredentialsValidatorVisitor credentialsValidatorVisitor = new CredentialsValidatorVisitor((BindingResult)validationBean, bugTracker.getAuthenticationProtocol());
            credentialsDto.accept(credentialsValidatorVisitor);
        }
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)credentialsDto, errors, (String)POST_BUGTRACKER_CREDENTIALS);
    }

    public void validatePostCredentialsForScmServer(Long scmServerId, ManageableCredentialsDto credentialsDto) throws BindException {
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)credentialsDto, POST_SCM_SERVER_CREDENTIALS);
        ScmServer scmServer = (ScmServer)this.entityManager.find(ScmServer.class, (Object)scmServerId);
        this.checkIfServerExists(scmServerId, Objects.isNull(scmServer), (BindingResult)validationBean, "scm-server");
        if (Objects.nonNull(scmServer)) {
            CredentialsValidatorVisitor credentialsValidatorVisitor = new CredentialsValidatorVisitor((BindingResult)validationBean, scmServer.getAuthenticationProtocol());
            credentialsDto.accept(credentialsValidatorVisitor);
        }
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)credentialsDto, errors, (String)POST_SCM_SERVER_CREDENTIALS);
    }

    public void validatePostCredentialsForTestAutomationServer(Long testAutomationServerId, ManageableCredentialsDto credentialsDto) throws BindException {
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)credentialsDto, POST_TEST_AUTOMATION_CREDENTIALS);
        TestAutomationServer testAutomationServer = (TestAutomationServer)this.entityManager.find(TestAutomationServer.class, (Object)testAutomationServerId);
        this.checkIfServerExists(testAutomationServerId, Objects.isNull(testAutomationServer), (BindingResult)validationBean, "test-automation-server");
        if (Objects.nonNull(testAutomationServer)) {
            CredentialsValidatorVisitor credentialsValidatorVisitor = new CredentialsValidatorVisitor((BindingResult)validationBean, testAutomationServer.getAuthenticationProtocol());
            credentialsDto.accept(credentialsValidatorVisitor);
        }
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)credentialsDto, errors, (String)POST_TEST_AUTOMATION_CREDENTIALS);
    }

    public void validatePostCredentialsForAiServer(Long aiServerId, ManageableCredentialsDto credentialsDto) throws BindException {
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)credentialsDto, POST_AI_SERVER_CREDENTIALS);
        AiServer aiServer = (AiServer)this.entityManager.find(AiServer.class, (Object)aiServerId);
        this.checkIfServerExists(aiServerId, Objects.isNull(aiServer), (BindingResult)validationBean, "ai-server");
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        if (Objects.nonNull(aiServer)) {
            CredentialsValidatorVisitor credentialsValidatorVisitor = new CredentialsValidatorVisitor((BindingResult)validationBean, aiServer.getAuthenticationProtocol());
            credentialsDto.accept(credentialsValidatorVisitor);
        }
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)credentialsDto, errors, (String)POST_AI_SERVER_CREDENTIALS);
    }

    private void checkIfServerExists(Long serverId, boolean serverExistence, BindingResult validationBean, String serverType) {
        if (serverExistence) {
            String message = NO_ENTITY_FOR_TYPE_AND_ID.formatted(serverType, serverId);
            validationBean.rejectValue("id", "invalid id", message);
        }
    }

    private class CredentialsValidatorVisitor
    implements ManageableCredentialsDtoVisitor {
        private static final String WRONG_CREDENTIALS_TYPE_MESSAGE = "This server can only accept credentials of type %s.";
        private BindingResult validationBean;
        private AuthenticationProtocol boundServerAuthProtocol;

        public CredentialsValidatorVisitor(BindingResult validationBean, AuthenticationProtocol boundServerAuthProtocol) {
            this.validationBean = validationBean;
            this.boundServerAuthProtocol = boundServerAuthProtocol;
        }

        @Override
        public void visit(ManageableBasicAuthCredentialsDto manageableBasicAuthCredentialsDto) {
            CredentialsValidator.this.helpValidator.validateAttributes("username", (Errors)this.validationBean);
            CredentialsValidator.this.helpValidator.validateAttributes("password", (Errors)this.validationBean);
            if (!AuthenticationProtocol.BASIC_AUTH.equals((Object)this.boundServerAuthProtocol)) {
                this.validationBean.rejectValue(CredentialsValidator.TYPE_FIELD, CredentialsValidator.WRONG_TYPE_ERROR_CODE, this.buildWrongCredentialsTypeMessage());
            }
        }

        @Override
        public void visit(ManageableTokenAuthCredentialsDto manageableTokenAuthCredentialsDto) {
            CredentialsValidator.this.helpValidator.validateAttributes("token", (Errors)this.validationBean);
            if (!AuthenticationProtocol.TOKEN_AUTH.equals((Object)this.boundServerAuthProtocol)) {
                this.validationBean.rejectValue(CredentialsValidator.TYPE_FIELD, CredentialsValidator.WRONG_TYPE_ERROR_CODE, this.buildWrongCredentialsTypeMessage());
            }
        }

        private String buildWrongCredentialsTypeMessage() {
            return WRONG_CREDENTIALS_TYPE_MESSAGE.formatted(this.getCredentialsJsonType());
        }

        private String getCredentialsJsonType() {
            return switch (this.boundServerAuthProtocol) {
                case AuthenticationProtocol.BASIC_AUTH -> "basic-auth-credentials";
                case AuthenticationProtocol.TOKEN_AUTH -> "token-auth-credentials";
                default -> throw new IllegalArgumentException("Unknown Authentication Protocol of type " + String.valueOf(this.boundServerAuthProtocol));
            };
        }
    }
}

