/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import java.util.List;
import java.util.Objects;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindException;
import org.squashtest.tm.api.plugin.ConfigurablePlugin;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.domain.artificialintelligence.AiUse;
import org.squashtest.tm.domain.artificialintelligence.AiUseName;
import org.squashtest.tm.domain.artificialintelligence.ProjectAiConfiguration;
import org.squashtest.tm.domain.bdd.SupportedLanguage;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.promptset.PromptSet;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.admin.jackson.model.AiPromptLanguageDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.AiUseDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ProjectAiConfigurationDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ProjectAutomationConfigurationDto;
import org.squashtest.tm.plugin.rest.admin.service.RestProjectAdminService;
import org.squashtest.tm.plugin.rest.admin.service.patcher.ProjectAutomationConfigurationPatcher;
import org.squashtest.tm.plugin.rest.admin.validators.ProjectAutomationConfigurationValidator;
import org.squashtest.tm.service.internal.repository.AiServerDao;
import org.squashtest.tm.service.internal.repository.AiUseDao;
import org.squashtest.tm.service.internal.repository.ProjectAiConfigurationDao;
import org.squashtest.tm.service.internal.repository.PromptSetDao;
import org.squashtest.tm.service.plugin.ConfigurablePluginManager;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.project.ProjectManagerService;

@Service
@Transactional
public class RestProjectAdminServiceImpl
implements RestProjectAdminService {
    private final GenericProjectManagerService genericProjectManager;
    private final ProjectManagerService projectManager;
    private final ProjectAutomationConfigurationPatcher projectAutomationConfigurationPatcher;
    private final ProjectAutomationConfigurationValidator projectAutomationConfigurationValidator;
    private final ConfigurablePluginManager configurablePluginManager;
    private final ProjectAiConfigurationDao projectAiConfigurationDao;
    private final AiUseDao aiUseDao;
    private final PromptSetDao promptSetDao;
    private final AiServerDao aiServerDao;
    private final DSLContext dsl;

    public RestProjectAdminServiceImpl(GenericProjectManagerService genericProjectManager, ProjectManagerService projectManager, ProjectAutomationConfigurationPatcher projectAutomationConfigurationPatcher, ProjectAutomationConfigurationValidator projectAutomationConfigurationValidator, ConfigurablePluginManager configurablePluginManager, ProjectAiConfigurationDao projectAiConfigurationDao, AiUseDao aiUseDao, PromptSetDao promptSetDao, AiServerDao aiServerDao, DSLContext dsl) {
        this.genericProjectManager = genericProjectManager;
        this.projectManager = projectManager;
        this.projectAutomationConfigurationPatcher = projectAutomationConfigurationPatcher;
        this.projectAutomationConfigurationValidator = projectAutomationConfigurationValidator;
        this.configurablePluginManager = configurablePluginManager;
        this.projectAiConfigurationDao = projectAiConfigurationDao;
        this.aiUseDao = aiUseDao;
        this.promptSetDao = promptSetDao;
        this.aiServerDao = aiServerDao;
        this.dsl = dsl;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteProjectByIds(List<Long> projectIds) {
        for (Long projectId : projectIds) {
            this.projectManager.deleteProject(projectId.longValue());
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeBugTracker(Long projectId, Long bugtrackerId) {
        this.genericProjectManager.changeBugTracker(projectId.longValue(), bugtrackerId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void unbindBugTracker(long projectId) {
        this.genericProjectManager.removeBugTracker(projectId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void bindScmRepository(long projectId, long scmRepositoryId) {
        this.genericProjectManager.bindScmRepository(projectId, scmRepositoryId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void unbindScmRepository(long projectId) {
        this.genericProjectManager.unbindScmRepository(projectId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public ProjectAutomationConfigurationDto getProjectAutomationSettings(long projectId) {
        GenericProject project = this.genericProjectManager.findById(projectId);
        return new ProjectAutomationConfigurationDto(project.getBddImplementationTechnology(), project.getBddScriptLanguage(), project.getAutomationWorkflowType());
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public ProjectAutomationConfigurationDto patchProjectAutomationConfiguration(ProjectAutomationConfigurationDto automConfDtoPatch, long projectId) throws BindException {
        GenericProject project = this.genericProjectManager.findById(projectId);
        this.projectAutomationConfigurationValidator.validatePatchAutomationConfiguration(automConfDtoPatch, project);
        this.projectAutomationConfigurationPatcher.patch(project, automConfDtoPatch);
        if (automConfDtoPatch.getAutomationWorkflowType() != null) {
            this.genericProjectManager.changeAutomationWorkflow(projectId, automConfDtoPatch.getAutomationWorkflowType().name());
        }
        return new ProjectAutomationConfigurationDto(project.getBddImplementationTechnology(), project.getBddScriptLanguage(), project.getAutomationWorkflowType());
    }

    @Override
    public void activateProjectPluginById(long projectId, String pluginId) {
        ConfigurablePlugin plugin = (ConfigurablePlugin)this.configurablePluginManager.findById(pluginId).orElseThrow(() -> new IllegalArgumentException("Could not find a plugin with ID %s".formatted(pluginId)));
        this.genericProjectManager.enablePlugin(projectId, plugin);
    }

    @Override
    public void deactivateProjectPluginById(long projectId, String pluginId, Boolean saveConfig) {
        this.configurablePluginManager.disableConfigurablePlugin(pluginId, projectId, saveConfig);
    }

    @Override
    public Long getAiServerId(Long projectId) {
        return (Long)this.dsl.select((SelectField)Tables.PROJECT.AI_SERVER_ID).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchOne((Field)Tables.PROJECT.AI_SERVER_ID);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public Page<ProjectAiConfiguration> getProjectAiConfigurations(long projectId, Pageable pageable) {
        return this.projectAiConfigurationDao.findAllByProjectId(projectId, pageable);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public ProjectAiConfiguration createOrUpdateProjectAiConfiguration(long projectId, ProjectAiConfigurationDto projectAiConfigurationDto) {
        Long aiUseId = this.aiUseDao.findAiUseIdByUse(AiUseName.valueOf((String)projectAiConfigurationDto.getAiUse()));
        Long projectAiConfigurationId = this.findProjectAiConfigurationIdByProjectIdAndAiUseId(projectId, aiUseId);
        if (Objects.isNull(projectAiConfigurationId)) {
            return this.createNewProjectAiConfiguration(projectAiConfigurationDto, projectId, aiUseId);
        }
        return this.updateProjectAiConfiguration(projectAiConfigurationDto, projectAiConfigurationId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void deleteProjectAiConfiguration(long projectId, AiUseDto aiUseDto) {
        Long aiUseId = this.aiUseDao.findAiUseIdByUse(AiUseName.valueOf((String)aiUseDto.getAiUse()));
        Long projectAiConfigurationId = this.findProjectAiConfigurationIdByProjectIdAndAiUseId(projectId, aiUseId);
        if (Objects.nonNull(projectAiConfigurationId)) {
            this.projectAiConfigurationDao.deleteById((Object)projectAiConfigurationId);
        }
    }

    private ProjectAiConfiguration createNewProjectAiConfiguration(ProjectAiConfigurationDto projectAiConfigurationDto, long projectId, long aiUseId) {
        ProjectAiConfiguration projectAiConfiguration = new ProjectAiConfiguration();
        projectAiConfiguration.setProject(this.genericProjectManager.findById(projectId));
        projectAiConfiguration.setAiUse((AiUse)this.aiUseDao.getReferenceById((Object)aiUseId));
        if (Objects.nonNull(projectAiConfigurationDto.getPromptSetId())) {
            projectAiConfiguration.setPromptSet((PromptSet)this.promptSetDao.getReferenceById((Object)projectAiConfigurationDto.getPromptSetId()));
        }
        if (Objects.nonNull(projectAiConfigurationDto.getAiServerId())) {
            projectAiConfiguration.setAiServer((AiServer)this.aiServerDao.getReferenceById((Object)projectAiConfigurationDto.getAiServerId()));
        }
        this.projectAiConfigurationDao.save((Object)projectAiConfiguration);
        return projectAiConfiguration;
    }

    private ProjectAiConfiguration updateProjectAiConfiguration(ProjectAiConfigurationDto projectAiConfigurationDto, Long projectAiConfigurationId) {
        ProjectAiConfiguration projectAiConfiguration = (ProjectAiConfiguration)this.projectAiConfigurationDao.getReferenceById((Object)projectAiConfigurationId);
        if (Objects.nonNull(projectAiConfigurationDto.getPromptSetId())) {
            projectAiConfiguration.setPromptSet((PromptSet)this.promptSetDao.getReferenceById((Object)projectAiConfigurationDto.getPromptSetId()));
        }
        if (Objects.nonNull(projectAiConfigurationDto.getAiServerId())) {
            projectAiConfiguration.setAiServer((AiServer)this.aiServerDao.getReferenceById((Object)projectAiConfigurationDto.getAiServerId()));
        }
        return projectAiConfiguration;
    }

    private Long findProjectAiConfigurationIdByProjectIdAndAiUseId(long projectId, Long aiUseId) {
        return (Long)this.dsl.select((SelectField)Tables.PROJECT_AI_CONFIGURATION.PROJECT_AI_CONFIGURATION_ID).from((TableLike)Tables.PROJECT_AI_CONFIGURATION).where(Tables.PROJECT_AI_CONFIGURATION.PROJECT_ID.eq((Object)projectId).and(Tables.PROJECT_AI_CONFIGURATION.AI_USE_ID.eq((Object)aiUseId))).fetchOne((Field)Tables.PROJECT_AI_CONFIGURATION.PROJECT_AI_CONFIGURATION_ID);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public AiPromptLanguageDto getProjectAiPromptLanguage(long projectId) {
        return new AiPromptLanguageDto(this.findProjectAiPromptLanguage(projectId));
    }

    private String findProjectAiPromptLanguage(long projectId) {
        return (String)this.dsl.select((SelectField)Tables.PROJECT.AI_PROMPT_LANGUAGE).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchOne((Field)Tables.PROJECT.AI_PROMPT_LANGUAGE);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public AiPromptLanguageDto patchProjectAiPromptLanguage(AiPromptLanguageDto aiPromptLanguageDto, long projectId) {
        GenericProject project = this.genericProjectManager.findById(projectId);
        project.setAiPromptLanguage(SupportedLanguage.valueOf((String)aiPromptLanguageDto.getAiPromptLanguage()));
        return new AiPromptLanguageDto(project.getAiPromptLanguage().name());
    }
}

