/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.jackson.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.plugin.rest.core.jackson.RestDtoName;
import org.squashtest.tm.service.internal.display.dto.aiserver.AbstractAiServerConfiguration;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerConfiguration;
import org.squashtest.tm.service.internal.display.dto.aiserver.CustomAiServerConfiguration;

@RestDtoName(value="options")
public class AiServerOptionsDto {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiServerOptionsDto.class);
    private Optional<Double> temperature;
    @JsonProperty(value="top_p")
    private Optional<Double> topP;
    @JsonProperty(value="random_seed")
    private Optional<Integer> randomSeed;
    private Optional<Integer> seed;
    @JsonProperty(value="max_tokens")
    private Optional<Integer> maxTokens;
    @JsonProperty(value="max_completion_tokens")
    private Optional<Integer> maxCompletionTokens;
    @JsonProperty(value="max_output_tokens")
    private Optional<Integer> maxOutputTokens;
    @JsonProperty(value="reasoning_effort")
    private Optional<String> reasoningEffort;
    @JsonProperty(value="organization_id")
    private Optional<String> organizationId;
    @JsonProperty(value="api_version")
    private Optional<String> apiVersion;
    @JsonProperty(value="thinking_type")
    private Optional<String> thinkingType;
    @JsonProperty(value="thinking_budget_tokens")
    private Optional<Integer> thinkingBudgetTokens;
    @JsonProperty(value="project_id")
    private Optional<String> projectId;
    private Optional<String> region;
    @JsonProperty(value="payload_template")
    private Optional<String> payloadTemplate;
    @JsonProperty(value="http_header_name_1")
    private Optional<String> httpHeaderName1;
    @JsonProperty(value="http_header_value_template_1")
    private Optional<String> httpHeaderValueTemplate1;
    @JsonProperty(value="http_header_name_2")
    private Optional<String> httpHeaderName2;
    @JsonProperty(value="http_header_value_template_2")
    private Optional<String> httpHeaderValueTemplate2;
    @JsonProperty(value="http_header_name_3")
    private Optional<String> httpHeaderName3;
    @JsonProperty(value="http_header_value_template_3")
    private Optional<String> httpHeaderValueTemplate3;
    @JsonProperty(value="http_header_name_4")
    private Optional<String> httpHeaderName4;
    @JsonProperty(value="http_header_value_template_4")
    private Optional<String> httpHeaderValueTemplate4;
    @JsonProperty(value="http_header_name_5")
    private Optional<String> httpHeaderName5;
    @JsonProperty(value="http_header_value_template_5")
    private Optional<String> httpHeaderValueTemplate5;
    @JsonProperty(value="generated_text_json_path")
    private Optional<String> generatedTextJsonPath;
    private Optional<Integer> timeout;

    public Optional<Double> getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Optional<Double> temperature) {
        this.temperature = temperature;
    }

    public Optional<Double> getTopP() {
        return this.topP;
    }

    public void setTopP(Optional<Double> topP) {
        this.topP = topP;
    }

    public Optional<Integer> getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Optional<Integer> randomSeed) {
        this.randomSeed = randomSeed;
    }

    public Optional<Integer> getSeed() {
        return this.seed;
    }

    public void setSeed(Optional<Integer> seed) {
        this.seed = seed;
    }

    public Optional<Integer> getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Optional<Integer> maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Optional<Integer> getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public void setMaxCompletionTokens(Optional<Integer> maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
    }

    public Optional<Integer> getMaxOutputTokens() {
        return this.maxOutputTokens;
    }

    public void setMaxOutputTokens(Optional<Integer> maxOutputTokens) {
        this.maxOutputTokens = maxOutputTokens;
    }

    public Optional<String> getReasoningEffort() {
        return this.reasoningEffort;
    }

    public void setReasoningEffort(Optional<String> reasoningEffort) {
        this.reasoningEffort = reasoningEffort;
    }

    public Optional<String> getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(Optional<String> organizationId) {
        this.organizationId = organizationId;
    }

    public Optional<String> getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(Optional<String> apiVersion) {
        this.apiVersion = apiVersion;
    }

    public Optional<String> getThinkingType() {
        return this.thinkingType;
    }

    public void setThinkingType(Optional<String> thinkingType) {
        this.thinkingType = thinkingType;
    }

    public Optional<Integer> getThinkingBudgetTokens() {
        return this.thinkingBudgetTokens;
    }

    public void setThinkingBudgetTokens(Optional<Integer> thinkingBudgetTokens) {
        this.thinkingBudgetTokens = thinkingBudgetTokens;
    }

    public Optional<String> getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Optional<String> projectId) {
        this.projectId = projectId;
    }

    public Optional<String> getRegion() {
        return this.region;
    }

    public void setRegion(Optional<String> region) {
        this.region = region;
    }

    public Optional<String> getPayloadTemplate() {
        return this.payloadTemplate;
    }

    public void setPayloadTemplate(Optional<String> payloadTemplate) {
        this.payloadTemplate = payloadTemplate;
    }

    public Optional<String> getHttpHeaderName1() {
        return this.httpHeaderName1;
    }

    public void setHttpHeaderName1(Optional<String> httpHeaderName1) {
        this.httpHeaderName1 = httpHeaderName1;
    }

    public Optional<String> getHttpHeaderValueTemplate1() {
        return this.httpHeaderValueTemplate1;
    }

    public void setHttpHeaderValueTemplate1(Optional<String> httpHeaderValueTemplate1) {
        this.httpHeaderValueTemplate1 = httpHeaderValueTemplate1;
    }

    public Optional<String> getHttpHeaderName2() {
        return this.httpHeaderName2;
    }

    public void setHttpHeaderName2(Optional<String> httpHeaderName2) {
        this.httpHeaderName2 = httpHeaderName2;
    }

    public Optional<String> getHttpHeaderValueTemplate2() {
        return this.httpHeaderValueTemplate2;
    }

    public void setHttpHeaderValueTemplate2(Optional<String> httpHeaderValueTemplate2) {
        this.httpHeaderValueTemplate2 = httpHeaderValueTemplate2;
    }

    public Optional<String> getHttpHeaderName3() {
        return this.httpHeaderName3;
    }

    public void setHttpHeaderName3(Optional<String> httpHeaderName3) {
        this.httpHeaderName3 = httpHeaderName3;
    }

    public Optional<String> getHttpHeaderValueTemplate3() {
        return this.httpHeaderValueTemplate3;
    }

    public void setHttpHeaderValueTemplate3(Optional<String> httpHeaderValueTemplate3) {
        this.httpHeaderValueTemplate3 = httpHeaderValueTemplate3;
    }

    public Optional<String> getHttpHeaderName4() {
        return this.httpHeaderName4;
    }

    public void setHttpHeaderName4(Optional<String> httpHeaderName4) {
        this.httpHeaderName4 = httpHeaderName4;
    }

    public Optional<String> getHttpHeaderValueTemplate4() {
        return this.httpHeaderValueTemplate4;
    }

    public void setHttpHeaderValueTemplate4(Optional<String> httpHeaderValueTemplate4) {
        this.httpHeaderValueTemplate4 = httpHeaderValueTemplate4;
    }

    public Optional<String> getHttpHeaderName5() {
        return this.httpHeaderName5;
    }

    public void setHttpHeaderName5(Optional<String> httpHeaderName5) {
        this.httpHeaderName5 = httpHeaderName5;
    }

    public Optional<String> getHttpHeaderValueTemplate5() {
        return this.httpHeaderValueTemplate5;
    }

    public void setHttpHeaderValueTemplate5(Optional<String> httpHeaderValueTemplate5) {
        this.httpHeaderValueTemplate5 = httpHeaderValueTemplate5;
    }

    public Optional<String> getGeneratedTextJsonPath() {
        return this.generatedTextJsonPath;
    }

    public void setGeneratedTextJsonPath(Optional<String> generatedTextJsonPath) {
        this.generatedTextJsonPath = generatedTextJsonPath;
    }

    public Optional<Integer> getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Optional<Integer> timeout) {
        this.timeout = timeout;
    }

    public String toCustomAiServerConfigurationAsString(CustomAiServerConfiguration conf) {
        this.setOptionalValue(this.payloadTemplate, arg_0 -> ((CustomAiServerConfiguration)conf).setPayloadTemplate(arg_0));
        this.setOptionalValue(this.generatedTextJsonPath, arg_0 -> ((CustomAiServerConfiguration)conf).setGeneratedTextJsonPath(arg_0));
        this.setOptionalValue(this.httpHeaderName1, arg_0 -> ((CustomAiServerConfiguration)conf).setHttpHeaderName1(arg_0));
        this.setOptionalValue(this.httpHeaderValueTemplate1, arg_0 -> ((CustomAiServerConfiguration)conf).setHttpHeaderValueTemplate1(arg_0));
        this.setOptionalValue(this.httpHeaderName2, arg_0 -> ((CustomAiServerConfiguration)conf).setHttpHeaderName2(arg_0));
        this.setOptionalValue(this.httpHeaderValueTemplate2, arg_0 -> ((CustomAiServerConfiguration)conf).setHttpHeaderValueTemplate2(arg_0));
        this.setOptionalValue(this.httpHeaderName3, arg_0 -> ((CustomAiServerConfiguration)conf).setHttpHeaderName3(arg_0));
        this.setOptionalValue(this.httpHeaderValueTemplate3, arg_0 -> ((CustomAiServerConfiguration)conf).setHttpHeaderValueTemplate3(arg_0));
        this.setOptionalValue(this.httpHeaderName4, arg_0 -> ((CustomAiServerConfiguration)conf).setHttpHeaderName4(arg_0));
        this.setOptionalValue(this.httpHeaderValueTemplate4, arg_0 -> ((CustomAiServerConfiguration)conf).setHttpHeaderValueTemplate4(arg_0));
        this.setOptionalValue(this.httpHeaderName5, arg_0 -> ((CustomAiServerConfiguration)conf).setHttpHeaderName5(arg_0));
        this.setOptionalValue(this.httpHeaderValueTemplate5, arg_0 -> ((CustomAiServerConfiguration)conf).setHttpHeaderValueTemplate5(arg_0));
        this.setOptionalValue(this.timeout, arg_0 -> ((CustomAiServerConfiguration)conf).setTimeout(arg_0));
        return this.writeOptionsAsString((AbstractAiServerConfiguration)conf);
    }

    public String toAiServerConfigurationAsString(AiServerConfiguration conf) {
        this.setOptionalValue(this.temperature, arg_0 -> ((AiServerConfiguration)conf).setTemperature(arg_0));
        this.setOptionalValue(this.topP, arg_0 -> ((AiServerConfiguration)conf).setTopP(arg_0));
        this.setOptionalValue(this.randomSeed, arg_0 -> ((AiServerConfiguration)conf).setRandomSeed(arg_0));
        this.setOptionalValue(this.seed, arg_0 -> ((AiServerConfiguration)conf).setSeed(arg_0));
        this.setOptionalValue(this.maxTokens, arg_0 -> ((AiServerConfiguration)conf).setMaxTokens(arg_0));
        this.setOptionalValue(this.maxCompletionTokens, arg_0 -> ((AiServerConfiguration)conf).setMaxCompletionTokens(arg_0));
        this.setOptionalValue(this.maxOutputTokens, arg_0 -> ((AiServerConfiguration)conf).setMaxOutputTokens(arg_0));
        this.setOptionalValue(this.reasoningEffort, arg_0 -> ((AiServerConfiguration)conf).setReasoningEffort(arg_0));
        this.setOptionalValue(this.organizationId, arg_0 -> ((AiServerConfiguration)conf).setOrganizationId(arg_0));
        this.setOptionalValue(this.apiVersion, arg_0 -> ((AiServerConfiguration)conf).setApiVersion(arg_0));
        this.setOptionalValue(this.thinkingType, arg_0 -> ((AiServerConfiguration)conf).setThinkingType(arg_0));
        this.setOptionalValue(this.thinkingBudgetTokens, arg_0 -> ((AiServerConfiguration)conf).setThinkingBudgetTokens(arg_0));
        this.setOptionalValue(this.projectId, arg_0 -> ((AiServerConfiguration)conf).setProjectId(arg_0));
        this.setOptionalValue(this.region, arg_0 -> ((AiServerConfiguration)conf).setRegion(arg_0));
        this.setOptionalValue(this.timeout, arg_0 -> ((AiServerConfiguration)conf).setTimeout(arg_0));
        return this.writeOptionsAsString((AbstractAiServerConfiguration)conf);
    }

    private String writeOptionsAsString(AbstractAiServerConfiguration conf) {
        try {
            return new ObjectMapper().writeValueAsString((Object)conf);
        }
        catch (IOException e) {
            String message = "Could not write AI server options as a string.";
            LOGGER.error(message, (Throwable)e);
            throw new ActionException(message);
        }
    }

    private <T> void setOptionalValue(Optional<T> optional, Consumer<T> setter) {
        if (Objects.nonNull(optional)) {
            if (optional.isEmpty()) {
                setter.accept(null);
            } else {
                setter.accept(optional.get());
            }
        }
    }
}

