/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap.internal.utils;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.utils.RestTemplateAbstractFactory;

@Component
@ConditionalOnProperty(prefix="plugin.bugtracker.tuleap", name={"deactivate-ssl-domain-name-check"}, havingValue="true")
public class RestTemplateNoSSLDomainCheckFactory
extends RestTemplateAbstractFactory {
    @Override
    protected void initSpringRequestFactory() {
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
            TlsSocketStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(sslContext).setHostnameVerifier((host, session) -> true).buildClassic();
            PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy(tlsStrategy).setMaxConnTotal(10).build();
            HttpHost proxy = this.getProxyIfConfigured();
            HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).disableCookieManagement();
            if (proxy != null) {
                httpClientBuilder.setProxy(proxy);
            }
            CloseableHttpClient httpClient = httpClientBuilder.build();
            this.springRequestFactory = () -> new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new BugTrackerRemoteException("Error initializing SSLContext", (Throwable)e);
        }
    }

    private HttpHost getProxyIfConfigured() {
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (StringUtils.isNotBlank((CharSequence)proxyHost) && StringUtils.isNotBlank((CharSequence)proxyPort)) {
            return new HttpHost(proxyHost, Integer.parseInt(proxyPort));
        }
        return null;
    }
}

