/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.creation;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.GraphqlClientException;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.GraphqlTopLevelErrorsException;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.BaseBatchProcessingOrchestrator;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.NoteProcessInfo;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.creation.IssueNoteBatchCreator;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.creation.IssueNoteBatchCreatorRegistry;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.creation.NoteCreationResult;
import xsquash4gitlab.com.apollographql.apollo.api.Error;

public class IssueNoteBatchCreationOrchestrator
extends BaseBatchProcessingOrchestrator<IssueNoteBatchCreator> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssueNoteBatchCreationOrchestrator.class);
    private boolean shouldInterruptProcess = false;

    public IssueNoteBatchCreationOrchestrator() {
        super(IssueNoteBatchCreatorRegistry.BATCH_CREATORS);
    }

    public BatchCreationResult createNotes(GitLabClient client, List<NoteProcessInfo> notesToCreate) {
        this.shouldInterruptProcess = false;
        HashMap<String, NoteCreationResult> resultByIssueId = new HashMap<String, NoteCreationResult>();
        this.processBatches(notesToCreate, (processingUnit, batch) -> this.doProcessBatch(client, (Map<String, NoteCreationResult>)resultByIssueId, (IssueNoteBatchCreator)processingUnit, batch));
        return new BatchCreationResult(resultByIssueId);
    }

    private void doProcessBatch(GitLabClient client, Map<String, NoteCreationResult> resultByIssueId, IssueNoteBatchCreator processingUnit, List<NoteProcessInfo> batch) {
        if (this.shouldInterruptProcess) {
            batch.forEach(item -> {
                NoteCreationResult noteCreationResult = resultByIssueId.put(item.issueGlobalId, NoteCreationResult.error("Batch aborted because of previous errors."));
            });
            return;
        }
        Date startTime = new Date();
        try {
            try {
                LOGGER.debug("Processing batch of {} note creations", (Object)batch.size());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("About to process batch with: {}", (Object)batch.stream().limit(5L).map(NoteProcessInfo::prettyPrint).collect(Collectors.joining(", ")));
                }
                Map<String, NoteCreationResult> batchResult = processingUnit.processBatch(client, batch);
                resultByIssueId.putAll(batchResult);
                boolean hasErrors = batchResult.values().stream().anyMatch(result -> result != null && !result.errors().isEmpty());
                if (hasErrors && LOGGER.isErrorEnabled()) {
                    LOGGER.error("Encountered errors while creating GitLab note batches :%n%s".formatted(batchResult.values().stream().flatMap(result -> result.errors().stream()).collect(Collectors.joining("\n"))));
                }
                LOGGER.debug("Created {} notes", (Object)processingUnit.getHandledBatchSize());
            }
            catch (GraphqlTopLevelErrorsException topLevelErrorsException) {
                LOGGER.error(topLevelErrorsException.getMessage(), (Throwable)((Object)topLevelErrorsException));
                topLevelErrorsException.getTopLevelErrors().forEach(topLevelError -> LOGGER.error(topLevelError.getMessage()));
                this.appendTopLevelErrors(resultByIssueId, batch, topLevelErrorsException);
                this.interruptProcessIfUsageLimitWasReached(topLevelErrorsException.getTopLevelErrors());
                LOGGER.debug("Batch processing took {} ms", (Object)(new Date().getTime() - startTime.getTime()));
            }
            catch (GraphqlClientException graphqlClientException) {
                LOGGER.error("A graphql error occurred during batch processing", (Throwable)((Object)graphqlClientException));
                LOGGER.debug("Batch processing took {} ms", (Object)(new Date().getTime() - startTime.getTime()));
            }
        }
        finally {
            LOGGER.debug("Batch processing took {} ms", (Object)(new Date().getTime() - startTime.getTime()));
        }
    }

    private void interruptProcessIfUsageLimitWasReached(List<Error> errors) {
        if (errors.stream().anyMatch(error -> error.getMessage().contains("Try again later"))) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("The usage limit for the note creation endpoint was reached. The remaining work will be delayed.");
            }
            this.shouldInterruptProcess = true;
        }
    }

    private void appendTopLevelErrors(Map<String, NoteCreationResult> resultByIssueId, List<NoteProcessInfo> batch, GraphqlTopLevelErrorsException topLevelErrorsException) {
        topLevelErrorsException.getTopLevelErrors().forEach(topLevelError -> {
            List list2;
            Object pathValue = topLevelError.getCustomAttributes().get("path");
            if (pathValue instanceof List && !(list2 = (List)pathValue).isEmpty()) {
                this.extractQueryIndexFromErrorPath(batch, list2).ifPresent(queryIndex -> {
                    String issueGlobalId = ((NoteProcessInfo)list.get((int)queryIndex.intValue())).issueGlobalId;
                    resultByIssueId.computeIfAbsent(issueGlobalId, k -> NoteCreationResult.empty()).errors().add(topLevelError.getMessage());
                });
            }
        });
    }

    private Optional<Integer> extractQueryIndexFromErrorPath(List<NoteProcessInfo> batch, List<?> pathValue) {
        int queryIndex;
        String str;
        String[] pathTokens;
        Object firstPathElement = pathValue.getFirst();
        if (firstPathElement instanceof String && this.isPathToAliasedQuery(pathTokens = (str = (String)firstPathElement).split("_")) && (queryIndex = Integer.parseInt(pathTokens[1])) >= 0 && queryIndex < batch.size()) {
            return Optional.of(queryIndex);
        }
        return Optional.empty();
    }

    private boolean isPathToAliasedQuery(String[] pathTokens) {
        return pathTokens.length == 2 && pathTokens[0].equals("m");
    }

    public record BatchCreationResult(Map<String, NoteCreationResult> resultByIssueId) {
        public List<String> getErrorsByIssueId(String issueGlobalId) {
            return Optional.ofNullable(this.resultByIssueId.get(issueGlobalId)).map(NoteCreationResult::errors).orElse(Collections.emptyList());
        }

        public String getNewNoteUrl(String issueGlobalId) {
            return Optional.ofNullable(this.resultByIssueId.get(issueGlobalId)).map(NoteCreationResult::noteUrl).orElse(null);
        }

        public String getNewNoteId(String issueGlobalId) {
            return Optional.ofNullable(this.resultByIssueId.get(issueGlobalId)).map(NoteCreationResult::noteId).orElse(null);
        }
    }
}

