/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting;

import jakarta.inject.Named;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.squashtest.tm.plugin.xsquash4gitlab.service.LocaleWithFallback;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.AbstractNoteFormatter;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.ObsoleteWarningNoteFormatter;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.ReportingNoteFormatter;
import org.squashtest.tm.service.internal.configuration.CallbackUrlProvider;
import org.squashtest.tm.service.statistics.testingstatus.RemoteRequirementStatistics;
import org.squashtest.tm.service.statistics.testingstatus.RemoteTestingStatus;
import org.squashtest.tm.service.statistics.testingstatus.exception.IllegalStatisticRatesException;

@Service(value="org.squashtest.tm.plugin.xsquash4gitlab.GitLabReportingHelper")
public class GitLabReportingLocaleHelper {
    private static final String RATIO_PATTERN = "%d%% (%d/%d)";
    private static final String REQUIREMENT_ROUTE_FORMAT = "requirement-workspace/requirement/%d/content";
    private final ReportingNoteFormatter reportingNoteFormatter;
    private final ObsoleteWarningNoteFormatter obsoleteWarningNoteFormatter;
    private final CallbackUrlProvider callbackUrlProvider;
    private final MessageSource messageSource;
    private final String tmSignature;
    private final AbstractNoteFormatter.LocaleCode localeToUse;

    public GitLabReportingLocaleHelper(ReportingNoteFormatter reportingNoteFormatter, CallbackUrlProvider callbackUrlProvider, @Named(value="xsquash4GitLabMessageSource") MessageSource messageSource, ObsoleteWarningNoteFormatter obsoleteWarningNoteFormatter) {
        this.reportingNoteFormatter = reportingNoteFormatter;
        this.callbackUrlProvider = callbackUrlProvider;
        this.messageSource = messageSource;
        this.tmSignature = this.getLocalizedSignature();
        this.localeToUse = this.findLocaleToUse();
        this.obsoleteWarningNoteFormatter = obsoleteWarningNoteFormatter;
    }

    public String getTmSignature() {
        return this.tmSignature;
    }

    public String buildReportNote(RemoteRequirementStatistics stats, String issueRemoteKey, Set<Long> requirementIds) {
        ReportingNoteFormatter.NoteParameters parameters = this.buildNoteParameters(stats, issueRemoteKey, requirementIds);
        return this.reportingNoteFormatter.formatReportNote(parameters, this.localeToUse);
    }

    public String buildObsoleteWarningNote(String newNoteUrl) {
        return this.obsoleteWarningNoteFormatter.formatObsoleteWarningNote(new ObsoleteWarningNoteFormatter.NoteParameters(newNoteUrl, this.tmSignature), this.localeToUse);
    }

    private ReportingNoteFormatter.NoteParameters buildNoteParameters(RemoteRequirementStatistics stats, String issueRemoteKey, Set<Long> requirementIds) {
        try {
            RemoteTestingStatus status = RemoteTestingStatus.findStatus((RemoteRequirementStatistics)stats);
            return new ReportingNoteFormatter.NoteParameters(this.getStatusEmoji(status), this.getStatusText(status), this.getRedactionRatio(stats), this.getVerificationRatio(stats), this.getValidationRatio(stats), this.makeLinksToRequirement(requirementIds), this.tmSignature);
        }
        catch (IllegalStatisticRatesException ex) {
            throw new IllegalArgumentException("Could not find testing status for remote key %s".formatted(issueRemoteKey), ex);
        }
    }

    private String getStatusEmoji(RemoteTestingStatus status) {
        return switch (status) {
            case RemoteTestingStatus.VALIDATION_IN_PROGRESS -> ":arrow_forward:";
            case RemoteTestingStatus.CONCEPTION -> ":pencil2:";
            case RemoteTestingStatus.INVALID -> ":x:";
            case RemoteTestingStatus.TO_EXECUTE -> ":checkered_flag:";
            case RemoteTestingStatus.VALID -> ":white_check_mark:";
            default -> "";
        };
    }

    private String getStatusText(RemoteTestingStatus status) {
        String code = "reporting.testing.status." + status.name();
        return this.messageSource.getMessage(code, null, LocaleWithFallback.getLocaleWithFallback());
    }

    private String getLocalizedSignature() {
        return this.messageSource.getMessage("reporting.signature", null, LocaleWithFallback.getLocaleWithFallback());
    }

    private String getRedactionRatio(RemoteRequirementStatistics stats) {
        return RATIO_PATTERN.formatted(stats.redactionRate.percentRoundedRate, stats.redactionRate.matchingCount, stats.redactionRate.totalCount);
    }

    private String getVerificationRatio(RemoteRequirementStatistics stats) {
        return RATIO_PATTERN.formatted(stats.verificationRate.percentRoundedRate, stats.verificationRate.matchingCount, stats.verificationRate.totalCount);
    }

    private String getValidationRatio(RemoteRequirementStatistics stats) {
        return RATIO_PATTERN.formatted(stats.validationRate.percentRoundedRate, stats.validationRate.matchingCount, stats.validationRate.totalCount);
    }

    private String makeLinksToRequirement(Set<Long> requirementIds) {
        return requirementIds.stream().sorted().map(this::makeLinkToRequirement).collect(Collectors.joining(", "));
    }

    private String makeLinkToRequirement(Long requirementId) {
        String url = this.makeUrlToRequirement(requirementId);
        return "[%d](%s)".formatted(requirementId, url);
    }

    private String makeUrlToRequirement(Long requirementId) {
        Object baseUrl = this.callbackUrlProvider.getCallbackUrl().toExternalForm();
        if (!((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        return (String)baseUrl + REQUIREMENT_ROUTE_FORMAT.formatted(requirementId);
    }

    private AbstractNoteFormatter.LocaleCode findLocaleToUse() {
        Locale squashLocale = LocaleWithFallback.getLocaleWithFallback();
        if (Locale.FRENCH.getLanguage().equals(squashLocale.getLanguage())) {
            return AbstractNoteFormatter.LocaleCode.FR;
        }
        return AbstractNoteFormatter.LocaleCode.EN;
    }
}

