/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.core.foundation.sanitizehtml.HTMLSanitizeUtils;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.DenormalizedCustomFieldOption;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.BuiltinSquashField;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.FieldMapping;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabField;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabMilestone;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabValue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.UserConfiguration;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.ValueMappings;
import org.squashtest.tm.plugin.xsquash4gitlab.service.RequirementImporter;
import org.squashtest.tm.plugin.xsquash4gitlab.service.UserConfigurationService;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.internal.repository.ProjectDao;

@Service(value="squash.tm.plugin.xsquash4gitlab.FieldMappingService")
@Transactional
public class FieldMappingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldMappingService.class);
    private static final Set<String> BUILTIN_FIELDS = new HashSet<String>();
    private final UserConfigurationService userConfigurationService;
    private final ProjectDao projectDao;
    private final CustomFieldBindingFinderService customFieldBindingFinderService;

    static {
        BuiltinSquashField[] builtinSquashFieldArray = BuiltinSquashField.values();
        int n = builtinSquashFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuiltinSquashField field = builtinSquashFieldArray[n2];
            BUILTIN_FIELDS.add(field.toString());
            ++n2;
        }
    }

    public FieldMappingService(UserConfigurationService userConfigurationService, ProjectDao projectDao, CustomFieldBindingFinderService customFieldBindingFinderService) {
        this.userConfigurationService = userConfigurationService;
        this.projectDao = projectDao;
        this.customFieldBindingFinderService = customFieldBindingFinderService;
    }

    public void processFieldMappings(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, Long projectId, RequirementVersion requirementVersion, GitLabIssue gitLabIssue, RequirementImporter.CustomFieldValueCollection cufValueCollection) {
        Project project = Objects.requireNonNull((Project)this.projectDao.getReferenceById((Object)projectId), "Cannot find project with ID " + String.valueOf(projectId));
        UserConfiguration userConfiguration = this.userConfigurationService.getUserConfiguration(projectId);
        ValueMappings valueMappings = this.userConfigurationService.getValueMappings(userConfiguration.getYamlFieldValueMapping());
        for (FieldMapping fieldMapping : userConfiguration.getFieldMappings()) {
            this.processFieldMapping(gitLabRemoteSynchronisation, requirementVersion, gitLabIssue, cufValueCollection, project, valueMappings, fieldMapping);
        }
    }

    private void processFieldMapping(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, RequirementVersion requirementVersion, GitLabIssue gitLabIssue, RequirementImporter.CustomFieldValueCollection cufValueCollection, Project project, ValueMappings valueMappings, FieldMapping fieldMapping) {
        block8: {
            String squashField = fieldMapping.getSquashField();
            String gitLabField = fieldMapping.getGitLabField();
            try {
                GitLabValue gitLabValue = this.getFieldValue(gitLabIssue, gitLabField);
                if (gitLabValue == null) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Could not find GitLab value, the mapping will be ignored.");
                    }
                } else {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Processing value '%s' for mapped field '%s'".formatted(gitLabValue, gitLabField));
                    }
                    if (this.isBuiltinField(squashField)) {
                        this.setBuiltInProperty(gitLabRemoteSynchronisation, requirementVersion, BuiltinSquashField.valueOf(squashField), gitLabValue, valueMappings, project);
                    } else {
                        this.setCustomField(squashField, gitLabValue, cufValueCollection, project.getId());
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                if (!LOGGER.isTraceEnabled()) break block8;
                LOGGER.error("An error occurred while settings value for field '%s' : %s".formatted(squashField, ex.getMessage()));
            }
        }
    }

    private boolean isBuiltinField(String squashField) {
        return BUILTIN_FIELDS.contains(squashField);
    }

    private GitLabValue getFieldValue(GitLabIssue gitLabIssue, String gitLabField) {
        switch (GitLabField.fromRawValue(gitLabField)) {
            case TITLE: {
                return GitLabValue.fromString(gitLabIssue.getTitle());
            }
            case DESCRIPTION: {
                return GitLabValue.fromString(gitLabIssue.getDescription());
            }
            case REFERENCE: {
                return GitLabValue.fromString(FieldMappingService.formatReference(gitLabIssue));
            }
            case AUTHOR: {
                return GitLabValue.fromString(gitLabIssue.getAuthor());
            }
            case CREATED_AT: {
                return GitLabValue.fromDate(gitLabIssue.getCreatedAt());
            }
            case UPDATED_BY: {
                return GitLabValue.fromString(gitLabIssue.getUpdatedBy());
            }
            case UPDATED_AT: {
                return GitLabValue.fromDate(gitLabIssue.getUpdatedAt());
            }
            case LABELS: {
                return GitLabValue.fromStrings(gitLabIssue.getLabels());
            }
            case MILESTONE_TITLE: {
                String milestoneTitle = Optional.ofNullable(gitLabIssue.getMilestone()).map(GitLabMilestone::getTitle).orElse("");
                return GitLabValue.fromString(milestoneTitle);
            }
            case MILESTONE_DUE_DATE: {
                Date dueDate = Optional.ofNullable(gitLabIssue.getMilestone()).map(GitLabMilestone::getDueDate).orElse(null);
                return GitLabValue.fromDate(dueDate);
            }
            case MILESTONE_EXPIRED: {
                Boolean expired = Optional.ofNullable(gitLabIssue.getMilestone()).map(GitLabMilestone::isExpired).orElse(null);
                return GitLabValue.fromBoolean(expired);
            }
            case WEIGHT: {
                return GitLabValue.fromInteger(gitLabIssue.getWeight());
            }
            case DUE_DATE: {
                return GitLabValue.fromDate(gitLabIssue.getDueDate());
            }
            case CONFIDENTIAL: {
                return GitLabValue.fromBoolean(gitLabIssue.isConfidential());
            }
            case DISCUSSION_LOCKED: {
                return GitLabValue.fromBoolean(gitLabIssue.isDiscussionLocked());
            }
            case EPIC: {
                return GitLabValue.fromString(gitLabIssue.getEpic());
            }
            case ASSIGNEES: {
                return GitLabValue.fromStrings(gitLabIssue.getAssignees());
            }
            case STATE: {
                return GitLabValue.fromString(gitLabIssue.getState().rawValue());
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Could not retrieve GitLab field value for field '%s'".formatted(gitLabField));
        }
        return null;
    }

    public static String formatReference(GitLabIssue gitLabIssue) {
        return "%s#%s".formatted(gitLabIssue.getProjectPath(), gitLabIssue.getIid());
    }

    private void setBuiltInProperty(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, RequirementVersion version, BuiltinSquashField builtinSquashField, GitLabValue gitLabValue, ValueMappings valueMappings, Project project) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Setting builtin property '%s' with value '%s'".formatted(new Object[]{builtinSquashField, gitLabValue}));
        }
        RequirementVersion.PropertiesSetter setter = version.getPropertySetter();
        switch (builtinSquashField) {
            case LABEL: {
                setter.setName(gitLabValue.getStringValue());
                break;
            }
            case DESCRIPTION: {
                setter.setDescription(FieldMappingService.checkAndUpdateDescriptionForGitLabInternalLinksAndFiles(gitLabRemoteSynchronisation, gitLabValue.getStringValue()));
                break;
            }
            case REFERENCE: {
                setter.setReference(gitLabValue.getStringValue());
                break;
            }
            case CATEGORY: {
                this.asCategory(gitLabValue, valueMappings, project).ifPresent(arg_0 -> ((RequirementVersion.PropertiesSetter)setter).setCategory(arg_0));
                break;
            }
            case STATUS: {
                this.asStatus(gitLabValue, valueMappings).ifPresent(arg_0 -> ((RequirementVersion.PropertiesSetter)setter).setStatus(arg_0));
                break;
            }
            case CRITICALITY: {
                this.asCriticality(gitLabValue, valueMappings).ifPresent(arg_0 -> ((RequirementVersion.PropertiesSetter)setter).setCriticality(arg_0));
            }
        }
    }

    public static String checkAndUpdateDescriptionForGitLabInternalLinksAndFiles(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, String rawDescription) {
        String serverUrl = gitLabRemoteSynchronisation.getRemoteSynchronisation().getServer().getUrl();
        Document doc = Jsoup.parse((String)rawDescription);
        Elements aElements = doc.getElementsByTag("a");
        aElements.forEach(a -> {
            String hrefValue = a.attr("href");
            try {
                URI hrefUrl = new URI(hrefValue);
                if (!hrefUrl.isAbsolute()) {
                    String completeUrl = FieldMappingService.appendServerUrlToRelativeUrl(hrefUrl, serverUrl);
                    a.attr("href", completeUrl);
                    a.attr("target", "_blank");
                }
            }
            catch (URISyntaxException e) {
                LOGGER.info("Could not create Url from string: " + hrefValue, (Throwable)e);
            }
        });
        Elements imgElements = doc.getElementsByTag("img");
        imgElements.forEach(img -> {
            String dataSrc = img.attr("data-src");
            try {
                URI dataSrcUrl = new URI(dataSrc);
                if (!dataSrcUrl.isAbsolute()) {
                    String completeDataSrcUrl = FieldMappingService.appendServerUrlToRelativeUrl(dataSrcUrl, serverUrl);
                    img.attr("src", completeDataSrcUrl);
                    img.attr("data-src", completeDataSrcUrl);
                    img.attr("style", "max-width:100%;");
                } else {
                    img.attr("src", dataSrc);
                    img.attr("style", "max-width:100%;");
                }
            }
            catch (URISyntaxException e) {
                LOGGER.info("Could not create Url from string: " + dataSrc, (Throwable)e);
            }
        });
        return doc.body().html();
    }

    private static String appendServerUrlToRelativeUrl(URI relativeUrl, String serverUrl) {
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        return "%s%s".formatted(serverUrl, relativeUrl.toString());
    }

    private Optional<InfoListItem> asCategory(GitLabValue gitLabValue, ValueMappings valueMappings, Project project) {
        if (!gitLabValue.hasStringValues()) {
            return Optional.empty();
        }
        Map<String, String> categoryValueMappings = valueMappings.getCategoryValueMappings();
        InfoList categoryInfoList = project.getRequirementCategories();
        boolean isSystemInfoList = SystemInfoListCode.isSystem((InfoList)categoryInfoList);
        return categoryValueMappings.keySet().stream().filter(key -> gitLabValue.getStringValues().contains(key)).findFirst().map(categoryValueMappings::get).map(categoryCode -> isSystemInfoList ? categoryCode.toUpperCase() : categoryCode).map(arg_0 -> ((InfoList)categoryInfoList).getItem(arg_0));
    }

    private Optional<RequirementCriticality> asCriticality(GitLabValue gitLabValue, ValueMappings valueMappings) {
        if (!gitLabValue.hasStringValues()) {
            return Optional.empty();
        }
        Map<String, String> criticalityValueMappings = valueMappings.getCriticalityValueMappings();
        return criticalityValueMappings.keySet().stream().filter(key -> gitLabValue.getStringValues().contains(key)).findFirst().map(criticalityValueMappings::get).map(String::toUpperCase).map(RequirementCriticality::valueOf);
    }

    private Optional<RequirementStatus> asStatus(GitLabValue gitLabValue, ValueMappings valueMappings) {
        if (!gitLabValue.hasStringValues()) {
            return Optional.empty();
        }
        Map<String, String> statusValueMappings = valueMappings.getStatusValueMappings();
        return statusValueMappings.keySet().stream().filter(key -> gitLabValue.getStringValues().contains(key)).findFirst().map(statusValueMappings::get).map(String::toUpperCase).map(RequirementStatus::valueOf);
    }

    public List<String> getAvailableCategoryValues(GenericProject project) {
        InfoList categoryInfoList = project.getRequirementCategories();
        boolean isSystemInfoList = SystemInfoListCode.isSystem((InfoList)categoryInfoList);
        return categoryInfoList.getItems().stream().map(InfoListItem::getCode).map(code -> isSystemInfoList ? code.toLowerCase() : code).collect(Collectors.toList());
    }

    private void setCustomField(String squashField, GitLabValue gitLabValue, RequirementImporter.CustomFieldValueCollection cufValueCollection, Long projectId) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Setting custom field '%s' with value '%s'".formatted(squashField, gitLabValue));
        }
        List boundCustomFields = this.customFieldBindingFinderService.findBoundCustomFields(projectId.longValue(), BindableEntity.REQUIREMENT_VERSION);
        for (CustomField customField : boundCustomFields) {
            if (!customField.getCode().equals(squashField)) continue;
            Optional<String> extractedValue = this.extractValue(gitLabValue, customField);
            extractedValue.ifPresent(s -> cufValueCollection.setValue(customField.getCode(), (String)s));
            return;
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Tried to set custom field value but none was found with code %s.".formatted(squashField));
        }
    }

    private Optional<String> extractValue(GitLabValue gitLabValue, CustomField customField) {
        InputType inputType = Objects.requireNonNull(customField.getInputType(), "Custom field has null input type.");
        return switch (customField.getInputType()) {
            case InputType.PLAIN_TEXT -> this.extractTextValue(gitLabValue, customField);
            case InputType.RICH_TEXT -> this.extractRichTextValue(gitLabValue, customField);
            case InputType.CHECKBOX -> this.extractCheckboxValue(gitLabValue, customField);
            case InputType.DROPDOWN_LIST -> this.extractDropdownValue(gitLabValue, customField);
            case InputType.DATE_PICKER -> this.extractDatePickerValue(gitLabValue, customField);
            case InputType.TAG -> this.extractTagValue(gitLabValue, customField);
            case InputType.NUMERIC -> this.extractNumericValue(gitLabValue, customField);
            default -> throw new IllegalArgumentException("Custom field input type '%s' not handled.".formatted(inputType));
        };
    }

    private Optional<String> extractTextValue(GitLabValue gitLabValue, CustomField customField) {
        if (gitLabValue.hasStringValues()) {
            return Optional.of(String.join((CharSequence)", ", gitLabValue.getStringValues()));
        }
        if (gitLabValue.hasDateValue()) {
            return Optional.of(DateUtils.formatIso8601Date((Date)gitLabValue.getDateValue()));
        }
        if (gitLabValue.hasStringValue()) {
            return Optional.of(gitLabValue.getStringValue());
        }
        if (gitLabValue.hasBooleanValue()) {
            return Optional.of(gitLabValue.getBooleanValue().toString());
        }
        if (gitLabValue.hasIntegerValue()) {
            return Optional.of(gitLabValue.getIntegerValue().toString());
        }
        this.warnCufValueNotFound(customField);
        return Optional.empty();
    }

    private Optional<String> extractRichTextValue(GitLabValue gitLabValue, CustomField customField) {
        if (gitLabValue.hasStringValue()) {
            return Optional.of(HTMLSanitizeUtils.cleanHtml((String)gitLabValue.getStringValue()));
        }
        return this.extractTextValue(gitLabValue, customField);
    }

    private Optional<String> extractCheckboxValue(GitLabValue gitLabValue, CustomField customField) {
        if (gitLabValue.hasBooleanValue()) {
            return Optional.of(gitLabValue.getBooleanValue().toString());
        }
        this.warnCufValueNotFound(customField);
        return Optional.empty();
    }

    private Optional<String> extractDropdownValue(GitLabValue gitLabValue, CustomField customField) {
        if (SingleSelectField.class.isAssignableFrom(customField.getClass())) {
            SingleSelectField singleSelectField = (SingleSelectField)customField;
            if (gitLabValue.hasStringValue()) {
                String codeOrLabel = gitLabValue.getStringValue();
                return this.extractMatchingOptionLabel(codeOrLabel, singleSelectField);
            }
            if (gitLabValue.hasStringValues()) {
                return this.findFirstMatchingCufOptionLabel(gitLabValue, singleSelectField);
            }
        } else {
            throw new IllegalArgumentException("Custom field was expected to be a SingleSelectField");
        }
        this.warnCufValueNotFound(customField);
        return Optional.empty();
    }

    private Optional<String> findFirstMatchingCufOptionLabel(GitLabValue gitLabValue, SingleSelectField singleSelectField) {
        for (String value : gitLabValue.getStringValues()) {
            Optional<String> matchingLabel = this.extractMatchingOptionLabel(value, singleSelectField);
            if (!matchingLabel.isPresent()) continue;
            return matchingLabel;
        }
        return Optional.empty();
    }

    private Optional<String> extractMatchingOptionLabel(String codeOrLabel, SingleSelectField singleSelectField) {
        boolean isLabelValue = singleSelectField.getOptions().stream().anyMatch(option -> codeOrLabel.equals(option.getLabel()));
        if (isLabelValue) {
            return Optional.of(codeOrLabel);
        }
        return singleSelectField.getOptions().stream().filter(option -> codeOrLabel.equals(option.getCode())).findFirst().map(DenormalizedCustomFieldOption::getLabel);
    }

    private Optional<String> extractDatePickerValue(GitLabValue gitLabValue, CustomField customField) {
        if (gitLabValue.hasDateValue()) {
            return Optional.of(DateUtils.formatIso8601Date((Date)gitLabValue.getDateValue()));
        }
        this.warnCufValueNotFound(customField);
        return Optional.empty();
    }

    private Optional<String> extractTagValue(GitLabValue gitLabValue, CustomField customField) {
        if (gitLabValue.hasStringValues()) {
            return Optional.of(String.join((CharSequence)"|", gitLabValue.getStringValues()));
        }
        if (gitLabValue.hasStringValue()) {
            return Optional.of(gitLabValue.getStringValue());
        }
        this.warnCufValueNotFound(customField);
        return Optional.empty();
    }

    private Optional<String> extractNumericValue(GitLabValue gitLabValue, CustomField customField) {
        if (gitLabValue.hasIntegerValue()) {
            return Optional.of(gitLabValue.getIntegerValue().toString());
        }
        this.warnCufValueNotFound(customField);
        return Optional.empty();
    }

    private void warnCufValueNotFound(CustomField customField) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("GitLabValue does not appear to contain any applicable value for CUF type '%s'".formatted(customField.getInputType().toString()));
        }
    }
}

