/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.converter;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.IterationDto;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.DateConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabConverters;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabEntityHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabMilestone;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabNote;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetBoardListIssuesCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetBoardListIssuesQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupFilteredBoardIssueNotesQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupFilteredBoardIssuesCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupFilteredBoardIssuesQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupIssuesCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupIssuesQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetIssueByIdQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetIssueCommunityByIdQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectFilteredBoardIssuesCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectFilteredBoardIssuesQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectIssuesCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectIssuesQuery;

public class GitLabIssueConverter {
    private static final String ERROR_INVALID_ISSUES_DATA = "Received invalid project issues data";
    private static final String ERROR_INVALID_GROUP_ISSUES_DATA = "Received invalid group issues data";
    private static final String ERROR_INVALID_GROUP_BOARD_DATA = "Received invalid group board issues data";
    private static final String ERROR_INVALID_PROJECT_PATH = "Could not retrieve path for project";
    private static final String ERROR_INVALID_GROUP_PATH = "Could not retrieve path for group";
    private static final String ERROR_INVALID_PROJECT_BOARD_PATH = "Could not retrieve path for project board";
    private static final String ERROR_INVALID_PROJECT_ID = "Could not retrieve id for project";
    private static final String ERROR_INVALID_ASSIGNEE_DATA = "Received invalid issue data for assignees";
    private static final String ERROR_INVALID_PROJECT_BOARD_ASSIGNEE_DATA = "Received invalid project board issue data for assignees";
    private static final String ERROR_INVALID_LABEL_DATA = "Received invalid data for labels";
    private static final String ERROR_INVALID_GROUP_LABEL_DATA = "Received invalid issue data for labels";
    private static final String ERROR_INVALID_PROJECT_BOARD_LABEL_DATA = "Received invalid project board issues data for labels";
    private static final String ERROR_NULL_ISSUE = "Received invalid issue data. Issue node is null";

    public static List<GitLabIssue> convertProjectIssuesPremium(@Nullable GetProjectIssuesQuery.Data projectIssuesQueryData) {
        String path = Optional.ofNullable(projectIssuesQueryData).map(GetProjectIssuesQuery.Data::project).map(GetProjectIssuesQuery.Project::path).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_PROJECT_PATH));
        return Optional.of(projectIssuesQueryData).map(GetProjectIssuesQuery.Data::project).map(GetProjectIssuesQuery.Project::issues).map(GetProjectIssuesQuery.Issues::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_ISSUES_DATA)).stream().filter(Objects::nonNull).map(issue -> GitLabIssueConverter.convertOneProjectIssuePremium(issue, path)).toList();
    }

    private static GitLabIssue convertOneProjectIssuePremium(GetProjectIssuesQuery.Node issue, String path) {
        GitLabIssueConverter.checkNullIssue(issue);
        String updatedBy = Optional.ofNullable(issue.updatedBy()).map(GetProjectIssuesQuery.UpdatedBy::username).orElse("");
        return new GitLabIssue(issue.id(), Integer.parseInt(issue.iid()), issue.title(), issue.webUrl(), issue.projectId(), path, issue.descriptionHtml(), issue.author().username(), DateConverter.parseDateTime(issue.createdAt().toString()), updatedBy, DateConverter.parseDateTime(issue.updatedAt().toString()), GitLabIssueConverter.extractMilestonePremium(issue), GitLabIssueConverter.extractIterationPremium(issue.iteration()), issue.webPath(), GitLabIssueConverter.extractLabelsPremium(issue), issue.weight(), GitLabIssueConverter.retrieveDate(issue.dueDate()), issue.confidential(), issue.discussionLocked(), GitLabIssueConverter.extractEpicTitlePremium(issue), GitLabIssueConverter.extractAssigneesPremium(issue), GitLabIssueConverter.extractNotesPremium(issue), issue.state());
    }

    private static List<GitLabNote> extractNotesPremium(GetProjectIssuesQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetProjectIssuesQuery.Node::notes).map(GetProjectIssuesQuery.Notes::nodes).map(nodes -> nodes.stream().map(node -> GitLabConverters.extractGitLabNote(node, GetProjectIssuesQuery.Node3::id, GetProjectIssuesQuery.Node3::body)).toList()).orElse(Collections.emptyList());
    }

    private static List<String> extractLabelsPremium(GetProjectIssuesQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetProjectIssuesQuery.Node::labels).map(GetProjectIssuesQuery.Labels::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_LABEL_DATA)).stream().map(GetProjectIssuesQuery.Node1::title).filter(StringUtils::isNotBlank).toList();
    }

    private static GitLabMilestone extractMilestonePremium(GetProjectIssuesQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetProjectIssuesQuery.Node::milestone).map(milestone -> new GitLabMilestone(milestone.id(), milestone.title(), GitLabIssueConverter.retrieveDate(milestone.dueDate()), milestone.expired(), milestone.state())).orElse(null);
    }

    private static IterationDto extractIterationPremium(GetProjectIssuesQuery.Iteration iteration) {
        if (iteration != null) {
            return new IterationDto(iteration.id(), iteration.title(), GitLabIssueConverter.retrieveDate(iteration.startDate()), GitLabIssueConverter.retrieveDate(iteration.dueDate()), iteration.iterationCadence().title(), iteration.state());
        }
        return null;
    }

    private static String extractEpicTitlePremium(GetProjectIssuesQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetProjectIssuesQuery.Node::epic).map(GetProjectIssuesQuery.Epic::title).orElse("");
    }

    private static List<String> extractAssigneesPremium(GetProjectIssuesQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetProjectIssuesQuery.Node::assignees).map(GetProjectIssuesQuery.Assignees::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_ASSIGNEE_DATA)).stream().map(GetProjectIssuesQuery.Node2::name).filter(StringUtils::isNotBlank).toList();
    }

    public static List<GitLabIssue> convertProjectIssuesCommunity(@Nullable GetProjectIssuesCommunityQuery.Data projectIssuesQueryData) {
        String path = Optional.ofNullable(projectIssuesQueryData).map(GetProjectIssuesCommunityQuery.Data::project).map(GetProjectIssuesCommunityQuery.Project::path).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_PROJECT_PATH));
        return Optional.of(projectIssuesQueryData).map(GetProjectIssuesCommunityQuery.Data::project).map(GetProjectIssuesCommunityQuery.Project::issues).map(GetProjectIssuesCommunityQuery.Issues::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_ISSUES_DATA)).stream().filter(Objects::nonNull).map(issue -> GitLabIssueConverter.convertOneProjectIssueCommunity(issue, path)).toList();
    }

    private static GitLabIssue convertOneProjectIssueCommunity(GetProjectIssuesCommunityQuery.Node issue, String path) {
        GitLabIssueConverter.checkNullIssue(issue);
        String updatedBy = Optional.ofNullable(issue.updatedBy()).map(GetProjectIssuesCommunityQuery.UpdatedBy::username).orElse("");
        return GitLabIssue.community(issue.id(), Integer.parseInt(issue.iid()), issue.title(), issue.webUrl(), issue.projectId(), path, issue.descriptionHtml(), issue.author().username(), DateConverter.parseDateTime(issue.createdAt().toString()), updatedBy, DateConverter.parseDateTime(issue.updatedAt().toString()), GitLabIssueConverter.extractMilestoneCommunity(issue), issue.webPath(), GitLabIssueConverter.extractLabelsCommunity(issue), GitLabIssueConverter.retrieveDate(issue.dueDate()), issue.confidential(), issue.discussionLocked(), GitLabIssueConverter.extractAssigneesCommunity(issue), GitLabIssueConverter.extractNotesCommunity(issue), issue.state());
    }

    private static List<GitLabNote> extractNotesCommunity(GetProjectIssuesCommunityQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetProjectIssuesCommunityQuery.Node::notes).map(GetProjectIssuesCommunityQuery.Notes::nodes).map(nodes -> nodes.stream().map(node -> GitLabConverters.extractGitLabNote(node, GetProjectIssuesCommunityQuery.Node3::id, GetProjectIssuesCommunityQuery.Node3::body)).toList()).orElse(Collections.emptyList());
    }

    private static List<String> extractLabelsCommunity(GetProjectIssuesCommunityQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetProjectIssuesCommunityQuery.Node::labels).map(GetProjectIssuesCommunityQuery.Labels::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_LABEL_DATA)).stream().map(GetProjectIssuesCommunityQuery.Node1::title).filter(StringUtils::isNotBlank).toList();
    }

    private static GitLabMilestone extractMilestoneCommunity(GetProjectIssuesCommunityQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetProjectIssuesCommunityQuery.Node::milestone).map(milestone -> new GitLabMilestone(milestone.id(), milestone.title(), GitLabIssueConverter.retrieveDate(milestone.dueDate()), milestone.expired(), milestone.state())).orElse(null);
    }

    private static List<String> extractAssigneesCommunity(GetProjectIssuesCommunityQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetProjectIssuesCommunityQuery.Node::assignees).map(GetProjectIssuesCommunityQuery.Assignees::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_ASSIGNEE_DATA)).stream().map(GetProjectIssuesCommunityQuery.Node2::name).filter(StringUtils::isNotBlank).toList();
    }

    public static BoardIssuesFirstPageResult convertProjectBoardIssuesPremium(@Nullable GetProjectFilteredBoardIssuesQuery.Data data) {
        String path = Optional.ofNullable(data).map(GetProjectFilteredBoardIssuesQuery.Data::project).map(GetProjectFilteredBoardIssuesQuery.Project::path).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_PROJECT_BOARD_PATH));
        Integer projectId = Optional.of(data).map(GetProjectFilteredBoardIssuesQuery.Data::project).map(GetProjectFilteredBoardIssuesQuery.Project::id).map(GitLabEntityHelper::extractProjectIdFromGID).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_PROJECT_ID));
        List boardListNodes = Optional.ofNullable(data).map(GetProjectFilteredBoardIssuesQuery.Data::project).map(GetProjectFilteredBoardIssuesQuery.Project::board).map(GetProjectFilteredBoardIssuesQuery.Board::lists).map(GetProjectFilteredBoardIssuesQuery.Lists::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_GROUP_BOARD_DATA));
        List<GitLabIssue> gitLabIssues = boardListNodes.stream().map(GetProjectFilteredBoardIssuesQuery.Node::issues).filter(Objects::nonNull).map(GetProjectFilteredBoardIssuesQuery.Issues::nodes).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(issue -> GitLabIssueConverter.convertOneProjectBoardIssuePremium(issue, path, projectId)).toList();
        Map<String, Optional<String>> endCursorByBoardListId = boardListNodes.stream().collect(Collectors.toMap(GetProjectFilteredBoardIssuesQuery.Node::id, GitLabIssueConverter::extractEndCursorPremium));
        return new BoardIssuesFirstPageResult(gitLabIssues, endCursorByBoardListId);
    }

    private static Optional<String> extractEndCursorPremium(GetProjectFilteredBoardIssuesQuery.Node boardListNode) {
        return Optional.of(boardListNode).map(GetProjectFilteredBoardIssuesQuery.Node::issues).map(GetProjectFilteredBoardIssuesQuery.Issues::pageInfo).map(GetProjectFilteredBoardIssuesQuery.PageInfo::endCursor);
    }

    private static GitLabIssue convertOneProjectBoardIssuePremium(GetProjectFilteredBoardIssuesQuery.Node1 issue, String path, Integer projectId) {
        GitLabIssueConverter.checkNullIssue(issue);
        String updatedBy = Optional.ofNullable(issue.updatedBy()).map(GetProjectFilteredBoardIssuesQuery.UpdatedBy::username).orElse("");
        return new GitLabIssue(issue.id(), Integer.parseInt(issue.iid()), issue.title(), issue.webUrl(), projectId, path, issue.descriptionHtml(), issue.author().username(), DateConverter.parseDateTime(issue.createdAt().toString()), updatedBy, DateConverter.parseDateTime(issue.updatedAt().toString()), GitLabIssueConverter.extractGitLabMilestonePremium(issue), GitLabIssueConverter.extractIterationPremium(issue.iteration()), issue.webPath(), GitLabIssueConverter.extractLabelsPremium(issue), issue.weight(), GitLabIssueConverter.retrieveDate(issue.dueDate()), issue.confidential(), issue.discussionLocked(), GitLabIssueConverter.extractEpicTitlePremium(issue), GitLabIssueConverter.extractAssigneesPremium(issue), GitLabIssueConverter.extractNotesPremium(issue), issue.state());
    }

    private static List<GitLabNote> extractNotesPremium(GetProjectFilteredBoardIssuesQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetProjectFilteredBoardIssuesQuery.Node1::notes).map(GetProjectFilteredBoardIssuesQuery.Notes::nodes).map(nodes -> nodes.stream().map(node -> GitLabConverters.extractGitLabNote(node, GetProjectFilteredBoardIssuesQuery.Node4::id, GetProjectFilteredBoardIssuesQuery.Node4::body)).toList()).orElse(Collections.emptyList());
    }

    private static List<String> extractLabelsPremium(GetProjectFilteredBoardIssuesQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetProjectFilteredBoardIssuesQuery.Node1::labels).map(GetProjectFilteredBoardIssuesQuery.Labels::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_PROJECT_BOARD_LABEL_DATA)).stream().map(GetProjectFilteredBoardIssuesQuery.Node2::title).filter(StringUtils::isNotBlank).toList();
    }

    private static GitLabMilestone extractGitLabMilestonePremium(GetProjectFilteredBoardIssuesQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetProjectFilteredBoardIssuesQuery.Node1::milestone).map(milestone -> new GitLabMilestone(milestone.id(), milestone.title(), GitLabIssueConverter.retrieveDate(milestone.dueDate()), milestone.expired(), milestone.state())).orElse(null);
    }

    private static IterationDto extractIterationPremium(GetProjectFilteredBoardIssuesQuery.Iteration iteration) {
        if (iteration != null) {
            return new IterationDto(iteration.id(), iteration.title(), GitLabIssueConverter.retrieveDate(iteration.startDate()), GitLabIssueConverter.retrieveDate(iteration.dueDate()), iteration.iterationCadence().title(), iteration.state());
        }
        return null;
    }

    private static String extractEpicTitlePremium(GetProjectFilteredBoardIssuesQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetProjectFilteredBoardIssuesQuery.Node1::epic).map(GetProjectFilteredBoardIssuesQuery.Epic::title).orElse("");
    }

    private static List<String> extractAssigneesPremium(GetProjectFilteredBoardIssuesQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetProjectFilteredBoardIssuesQuery.Node1::assignees).map(GetProjectFilteredBoardIssuesQuery.Assignees::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_PROJECT_BOARD_ASSIGNEE_DATA)).stream().map(GetProjectFilteredBoardIssuesQuery.Node3::name).filter(StringUtils::isNotBlank).toList();
    }

    public static BoardIssuesFirstPageResult convertProjectBoardIssuesCommunity(@Nullable GetProjectFilteredBoardIssuesCommunityQuery.Data data) {
        String path = Optional.ofNullable(data).map(GetProjectFilteredBoardIssuesCommunityQuery.Data::project).map(GetProjectFilteredBoardIssuesCommunityQuery.Project::path).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_PROJECT_BOARD_PATH));
        List boardListNodes = Optional.ofNullable(data).map(GetProjectFilteredBoardIssuesCommunityQuery.Data::project).map(GetProjectFilteredBoardIssuesCommunityQuery.Project::board).map(GetProjectFilteredBoardIssuesCommunityQuery.Board::lists).map(GetProjectFilteredBoardIssuesCommunityQuery.Lists::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_GROUP_BOARD_DATA));
        List<GitLabIssue> gitLabIssues = boardListNodes.stream().map(GetProjectFilteredBoardIssuesCommunityQuery.Node::issues).filter(Objects::nonNull).map(GetProjectFilteredBoardIssuesCommunityQuery.Issues::nodes).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(issue -> GitLabIssueConverter.convertOneProjectBoardIssueCommunity(issue, path)).toList();
        Map<String, Optional<String>> endCursorByBoardListId = boardListNodes.stream().collect(Collectors.toMap(GetProjectFilteredBoardIssuesCommunityQuery.Node::id, GitLabIssueConverter::extractEndCursorPremium));
        return new BoardIssuesFirstPageResult(gitLabIssues, endCursorByBoardListId);
    }

    private static Optional<String> extractEndCursorPremium(GetProjectFilteredBoardIssuesCommunityQuery.Node boardListNode) {
        return Optional.of(boardListNode).map(GetProjectFilteredBoardIssuesCommunityQuery.Node::issues).map(GetProjectFilteredBoardIssuesCommunityQuery.Issues::pageInfo).map(GetProjectFilteredBoardIssuesCommunityQuery.PageInfo::endCursor);
    }

    private static GitLabIssue convertOneProjectBoardIssueCommunity(GetProjectFilteredBoardIssuesCommunityQuery.Node1 issue, String path) {
        GitLabIssueConverter.checkNullIssue(issue);
        String updatedBy = Optional.ofNullable(issue.updatedBy()).map(GetProjectFilteredBoardIssuesCommunityQuery.UpdatedBy::username).orElse("");
        return GitLabIssue.community(issue.id(), Integer.parseInt(issue.iid()), issue.title(), issue.webUrl(), issue.projectId(), path, issue.descriptionHtml(), issue.author().username(), DateConverter.parseDateTime(issue.createdAt().toString()), updatedBy, DateConverter.parseDateTime(issue.updatedAt().toString()), GitLabIssueConverter.extractGitLabMilestoneCommunity(issue), issue.webPath(), GitLabIssueConverter.extractLabelsCommunity(issue), GitLabIssueConverter.retrieveDate(issue.dueDate()), issue.confidential(), issue.discussionLocked(), GitLabIssueConverter.extractAssigneesCommunity(issue), GitLabIssueConverter.extractNotesCommunity(issue), issue.state());
    }

    private static List<GitLabNote> extractNotesCommunity(GetProjectFilteredBoardIssuesCommunityQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetProjectFilteredBoardIssuesCommunityQuery.Node1::notes).map(GetProjectFilteredBoardIssuesCommunityQuery.Notes::nodes).map(nodes -> nodes.stream().map(node -> GitLabConverters.extractGitLabNote(node, GetProjectFilteredBoardIssuesCommunityQuery.Node4::id, GetProjectFilteredBoardIssuesCommunityQuery.Node4::body)).toList()).orElse(Collections.emptyList());
    }

    private static List<String> extractLabelsCommunity(GetProjectFilteredBoardIssuesCommunityQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetProjectFilteredBoardIssuesCommunityQuery.Node1::labels).map(GetProjectFilteredBoardIssuesCommunityQuery.Labels::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_PROJECT_BOARD_LABEL_DATA)).stream().map(GetProjectFilteredBoardIssuesCommunityQuery.Node2::title).filter(StringUtils::isNotBlank).toList();
    }

    private static GitLabMilestone extractGitLabMilestoneCommunity(GetProjectFilteredBoardIssuesCommunityQuery.Node1 issue) {
        GitLabIssueConverter.checkNullIssue(issue);
        GetProjectFilteredBoardIssuesCommunityQuery.Milestone milestone = issue.milestone();
        if (milestone != null) {
            return new GitLabMilestone(milestone.id(), milestone.title(), GitLabIssueConverter.retrieveDate(milestone.dueDate()), milestone.expired(), milestone.state());
        }
        return null;
    }

    private static List<String> extractAssigneesCommunity(GetProjectFilteredBoardIssuesCommunityQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetProjectFilteredBoardIssuesCommunityQuery.Node1::assignees).map(GetProjectFilteredBoardIssuesCommunityQuery.Assignees::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_PROJECT_BOARD_ASSIGNEE_DATA)).stream().map(GetProjectFilteredBoardIssuesCommunityQuery.Node3::name).filter(StringUtils::isNotBlank).toList();
    }

    public static List<GitLabIssue> convertGroupIssuesPremium(@Nullable GetGroupIssuesQuery.Data groupIssuesQueryData) {
        String path = Optional.ofNullable(groupIssuesQueryData).map(GetGroupIssuesQuery.Data::group).map(GetGroupIssuesQuery.Group::path).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_GROUP_PATH));
        return Optional.ofNullable(groupIssuesQueryData).map(GetGroupIssuesQuery.Data::group).map(GetGroupIssuesQuery.Group::issues).map(GetGroupIssuesQuery.Issues::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_GROUP_ISSUES_DATA)).stream().filter(Objects::nonNull).map(issue -> GitLabIssueConverter.convertOneGroupIssuePremium(issue, path)).toList();
    }

    private static GitLabIssue convertOneGroupIssuePremium(GetGroupIssuesQuery.Node issue, String path) {
        GitLabIssueConverter.checkNullIssue(issue);
        String updatedBy = Optional.ofNullable(issue.updatedBy()).map(GetGroupIssuesQuery.UpdatedBy::username).orElse("");
        return new GitLabIssue(issue.id(), Integer.parseInt(issue.iid()), issue.title(), issue.webUrl(), issue.projectId(), path, issue.descriptionHtml(), issue.author().username(), DateConverter.parseDateTime(issue.createdAt().toString()), updatedBy, DateConverter.parseDateTime(issue.updatedAt().toString()), GitLabIssueConverter.extractGitLabMilestonePremium(issue), GitLabIssueConverter.extractIterationPremium(issue.iteration()), issue.webPath(), GitLabIssueConverter.extractLabelsPremium(issue), issue.weight(), GitLabIssueConverter.retrieveDate(issue.dueDate()), issue.confidential(), issue.discussionLocked(), GitLabIssueConverter.extractEpicTitlePremium(issue), GitLabIssueConverter.extractAssigneesPremium(issue), GitLabIssueConverter.extractNotesPremium(issue), issue.state());
    }

    private static List<GitLabNote> extractNotesPremium(GetGroupIssuesQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetGroupIssuesQuery.Node::notes).map(GetGroupIssuesQuery.Notes::nodes).map(nodes -> nodes.stream().map(node -> GitLabConverters.extractGitLabNote(node, GetGroupIssuesQuery.Node3::id, GetGroupIssuesQuery.Node3::body)).toList()).orElse(Collections.emptyList());
    }

    private static List<String> extractLabelsPremium(GetGroupIssuesQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetGroupIssuesQuery.Node::labels).map(GetGroupIssuesQuery.Labels::nodes).orElseThrow(() -> GitLabConverters.exception("Received invalid group issue data for labels")).stream().map(GetGroupIssuesQuery.Node1::title).filter(StringUtils::isNotBlank).toList();
    }

    private static GitLabMilestone extractGitLabMilestonePremium(GetGroupIssuesQuery.Node issue) {
        GetGroupIssuesQuery.Milestone milestone = issue.milestone();
        if (milestone != null) {
            return new GitLabMilestone(milestone.id(), milestone.title(), GitLabIssueConverter.retrieveDate(milestone.dueDate()), milestone.expired(), milestone.state());
        }
        return null;
    }

    private static IterationDto extractIterationPremium(GetGroupIssuesQuery.Iteration iteration) {
        if (iteration != null) {
            return new IterationDto(iteration.id(), iteration.title(), GitLabIssueConverter.retrieveDate(iteration.startDate()), GitLabIssueConverter.retrieveDate(iteration.dueDate()), iteration.iterationCadence().title(), iteration.state());
        }
        return null;
    }

    private static String extractEpicTitlePremium(GetGroupIssuesQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetGroupIssuesQuery.Node::epic).map(GetGroupIssuesQuery.Epic::title).orElse("");
    }

    private static List<String> extractAssigneesPremium(GetGroupIssuesQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetGroupIssuesQuery.Node::assignees).map(GetGroupIssuesQuery.Assignees::nodes).orElseThrow(() -> GitLabConverters.exception("Received invalid group issue data for assignees")).stream().map(GetGroupIssuesQuery.Node2::name).filter(StringUtils::isNotBlank).toList();
    }

    public static List<GitLabIssue> convertGroupIssuesCommunity(@Nullable GetGroupIssuesCommunityQuery.Data groupIssuesQueryData) {
        String path = Optional.ofNullable(groupIssuesQueryData).map(GetGroupIssuesCommunityQuery.Data::group).map(GetGroupIssuesCommunityQuery.Group::path).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_GROUP_PATH));
        return Optional.ofNullable(groupIssuesQueryData).map(GetGroupIssuesCommunityQuery.Data::group).map(GetGroupIssuesCommunityQuery.Group::issues).map(GetGroupIssuesCommunityQuery.Issues::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_GROUP_ISSUES_DATA)).stream().filter(Objects::nonNull).map(issue -> GitLabIssueConverter.convertOneGroupIssueCommunity(issue, path)).toList();
    }

    private static GitLabIssue convertOneGroupIssueCommunity(GetGroupIssuesCommunityQuery.Node issue, String path) {
        GitLabIssueConverter.checkNullIssue(issue);
        String updatedBy = Optional.ofNullable(issue.updatedBy()).map(GetGroupIssuesCommunityQuery.UpdatedBy::username).orElse("");
        return GitLabIssue.community(issue.id(), Integer.parseInt(issue.iid()), issue.title(), issue.webUrl(), issue.projectId(), path, issue.descriptionHtml(), issue.author().username(), DateConverter.parseDateTime(issue.createdAt().toString()), updatedBy, DateConverter.parseDateTime(issue.updatedAt().toString()), GitLabIssueConverter.extractGitLabMilestoneCommunity(issue), issue.webPath(), GitLabIssueConverter.extractLabelsCommunity(issue), GitLabIssueConverter.retrieveDate(issue.dueDate()), issue.confidential(), issue.discussionLocked(), GitLabIssueConverter.extractAssigneesCommunity(issue), GitLabIssueConverter.extractNotesCommunity(issue), issue.state());
    }

    private static List<GitLabNote> extractNotesCommunity(GetGroupIssuesCommunityQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetGroupIssuesCommunityQuery.Node::notes).map(GetGroupIssuesCommunityQuery.Notes::nodes).map(nodes -> nodes.stream().map(node -> GitLabConverters.extractGitLabNote(node, GetGroupIssuesCommunityQuery.Node3::id, GetGroupIssuesCommunityQuery.Node3::body)).toList()).orElse(Collections.emptyList());
    }

    private static List<String> extractLabelsCommunity(GetGroupIssuesCommunityQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetGroupIssuesCommunityQuery.Node::labels).map(GetGroupIssuesCommunityQuery.Labels::nodes).orElseThrow(() -> GitLabConverters.exception("Received invalid group issue data for labels")).stream().map(GetGroupIssuesCommunityQuery.Node1::title).filter(StringUtils::isNotBlank).toList();
    }

    private static GitLabMilestone extractGitLabMilestoneCommunity(GetGroupIssuesCommunityQuery.Node issue) {
        GetGroupIssuesCommunityQuery.Milestone milestone = issue.milestone();
        if (milestone != null) {
            return new GitLabMilestone(milestone.id(), milestone.title(), GitLabIssueConverter.retrieveDate(milestone.dueDate()), milestone.expired(), milestone.state());
        }
        return null;
    }

    private static List<String> extractAssigneesCommunity(GetGroupIssuesCommunityQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetGroupIssuesCommunityQuery.Node::assignees).map(GetGroupIssuesCommunityQuery.Assignees::nodes).orElseThrow(() -> GitLabConverters.exception("Received invalid group issue data for assignees")).stream().map(GetGroupIssuesCommunityQuery.Node2::name).filter(StringUtils::isNotBlank).toList();
    }

    public static BoardIssuesFirstPageResult convertGroupBoardIssuesPremium(@Nullable GetGroupFilteredBoardIssuesQuery.Data data) {
        String path = Optional.ofNullable(data).map(GetGroupFilteredBoardIssuesQuery.Data::group).map(GetGroupFilteredBoardIssuesQuery.Group::path).orElseThrow(() -> GitLabConverters.exception("Could not retrieve path for group board"));
        List boardListNodes = Optional.of(data).map(GetGroupFilteredBoardIssuesQuery.Data::group).map(GetGroupFilteredBoardIssuesQuery.Group::board).map(GetGroupFilteredBoardIssuesQuery.Board::lists).map(GetGroupFilteredBoardIssuesQuery.Lists::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_GROUP_BOARD_DATA));
        List<GitLabIssue> gitLabIssues = boardListNodes.stream().map(GetGroupFilteredBoardIssuesQuery.Node::issues).filter(Objects::nonNull).map(GetGroupFilteredBoardIssuesQuery.Issues::nodes).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(issue -> GitLabIssueConverter.convertOneGroupBoardIssuePremium(issue, path)).toList();
        Map<String, Optional<String>> endCursorByBoardListId = boardListNodes.stream().collect(Collectors.toMap(GetGroupFilteredBoardIssuesQuery.Node::id, GitLabIssueConverter::extractEndCursorPremium));
        return new BoardIssuesFirstPageResult(gitLabIssues, endCursorByBoardListId);
    }

    private static Optional<String> extractEndCursorPremium(GetGroupFilteredBoardIssuesQuery.Node boardListNode) {
        return Optional.of(boardListNode).map(GetGroupFilteredBoardIssuesQuery.Node::issues).map(GetGroupFilteredBoardIssuesQuery.Issues::pageInfo).map(GetGroupFilteredBoardIssuesQuery.PageInfo::endCursor);
    }

    private static GitLabIssue convertOneGroupBoardIssuePremium(GetGroupFilteredBoardIssuesQuery.Node1 issue, String path) {
        GitLabIssueConverter.checkNullIssue(issue);
        String updatedBy = Optional.ofNullable(issue.updatedBy()).map(GetGroupFilteredBoardIssuesQuery.UpdatedBy::username).orElse("");
        return new GitLabIssue(issue.id(), Integer.parseInt(issue.iid()), issue.title(), issue.webUrl(), issue.projectId(), path, issue.descriptionHtml(), issue.author().username(), DateConverter.parseDateTime(issue.createdAt().toString()), updatedBy, DateConverter.parseDateTime(issue.updatedAt().toString()), GitLabIssueConverter.extractMilestonePremium(issue), GitLabIssueConverter.extractIterationPremium(issue.iteration()), issue.webPath(), GitLabIssueConverter.extractLabelsPremium(issue), issue.weight(), GitLabIssueConverter.retrieveDate(issue.dueDate()), issue.confidential(), issue.discussionLocked(), GitLabIssueConverter.extractEpicTitlePremium(issue), GitLabIssueConverter.extractAssigneesPremium(issue), Collections.emptyList(), issue.state());
    }

    private static List<String> extractLabelsPremium(GetGroupFilteredBoardIssuesQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetGroupFilteredBoardIssuesQuery.Node1::labels).map(GetGroupFilteredBoardIssuesQuery.Labels::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_PROJECT_BOARD_LABEL_DATA)).stream().map(GetGroupFilteredBoardIssuesQuery.Node2::title).filter(StringUtils::isNotBlank).toList();
    }

    private static GitLabMilestone extractMilestonePremium(GetGroupFilteredBoardIssuesQuery.Node1 issue) {
        GetGroupFilteredBoardIssuesQuery.Milestone milestone = issue.milestone();
        if (milestone != null) {
            return new GitLabMilestone(milestone.id(), milestone.title(), GitLabIssueConverter.retrieveDate(milestone.dueDate()), milestone.expired(), milestone.state());
        }
        return null;
    }

    private static IterationDto extractIterationPremium(GetGroupFilteredBoardIssuesQuery.Iteration iteration) {
        if (iteration != null) {
            return new IterationDto(iteration.id(), iteration.title(), GitLabIssueConverter.retrieveDate(iteration.startDate()), GitLabIssueConverter.retrieveDate(iteration.dueDate()), iteration.iterationCadence().title(), iteration.state());
        }
        return null;
    }

    private static String extractEpicTitlePremium(GetGroupFilteredBoardIssuesQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetGroupFilteredBoardIssuesQuery.Node1::epic).map(GetGroupFilteredBoardIssuesQuery.Epic::title).orElse("");
    }

    private static List<String> extractAssigneesPremium(GetGroupFilteredBoardIssuesQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetGroupFilteredBoardIssuesQuery.Node1::assignees).map(GetGroupFilteredBoardIssuesQuery.Assignees::nodes).orElseThrow(() -> GitLabConverters.exception("Received invalid group board issue data for assignees")).stream().map(GetGroupFilteredBoardIssuesQuery.Node3::name).filter(StringUtils::isNotBlank).toList();
    }

    public static BoardIssueNotesFirstPageResult convertGroupBoardIssueNotesPremium(@Nullable GetGroupFilteredBoardIssueNotesQuery.Data data) {
        List boardNodes = Optional.ofNullable(data).map(GetGroupFilteredBoardIssueNotesQuery.Data::group).map(GetGroupFilteredBoardIssueNotesQuery.Group::board).map(GetGroupFilteredBoardIssueNotesQuery.Board::lists).map(GetGroupFilteredBoardIssueNotesQuery.Lists::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_GROUP_BOARD_DATA));
        List issueNodes = boardNodes.stream().map(GetGroupFilteredBoardIssueNotesQuery.Node::issues).filter(Objects::nonNull).map(GetGroupFilteredBoardIssueNotesQuery.Issues::nodes).filter(Objects::nonNull).flatMap(Collection::stream).toList();
        return new BoardIssueNotesFirstPageResult(issueNodes.stream().collect(Collectors.toMap(GetGroupFilteredBoardIssueNotesQuery.Node1::id, GitLabIssueConverter::extractNotesPremium)));
    }

    private static List<GitLabNote> extractNotesPremium(GetGroupFilteredBoardIssueNotesQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetGroupFilteredBoardIssueNotesQuery.Node1::notes).map(GetGroupFilteredBoardIssueNotesQuery.Notes::nodes).map(nodes -> nodes.stream().map(node -> GitLabConverters.extractGitLabNote(node, GetGroupFilteredBoardIssueNotesQuery.Node2::id, GetGroupFilteredBoardIssueNotesQuery.Node2::body)).toList()).orElse(Collections.emptyList());
    }

    public static BoardIssuesFirstPageResult convertGroupBoardIssuesCommunity(@Nullable GetGroupFilteredBoardIssuesCommunityQuery.Data data) {
        String path = Optional.ofNullable(data).map(GetGroupFilteredBoardIssuesCommunityQuery.Data::group).map(GetGroupFilteredBoardIssuesCommunityQuery.Group::path).orElseThrow(() -> GitLabConverters.exception("Could not retrieve path for group board"));
        List boardListNodes = Optional.of(data).map(GetGroupFilteredBoardIssuesCommunityQuery.Data::group).map(GetGroupFilteredBoardIssuesCommunityQuery.Group::board).map(GetGroupFilteredBoardIssuesCommunityQuery.Board::lists).map(GetGroupFilteredBoardIssuesCommunityQuery.Lists::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_GROUP_BOARD_DATA));
        List<GitLabIssue> gitLabIssues = boardListNodes.stream().map(GetGroupFilteredBoardIssuesCommunityQuery.Node::issues).filter(Objects::nonNull).map(GetGroupFilteredBoardIssuesCommunityQuery.Issues::nodes).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(issue -> GitLabIssueConverter.convertOneGroupBoardIssueCommunity(issue, path)).toList();
        Map<String, Optional<String>> endCursorByBoardListId = boardListNodes.stream().collect(Collectors.toMap(GetGroupFilteredBoardIssuesCommunityQuery.Node::id, GitLabIssueConverter::extractEndCursorCommunity));
        return new BoardIssuesFirstPageResult(gitLabIssues, endCursorByBoardListId);
    }

    private static Optional<String> extractEndCursorCommunity(GetGroupFilteredBoardIssuesCommunityQuery.Node boardListNode) {
        return Optional.of(boardListNode).map(GetGroupFilteredBoardIssuesCommunityQuery.Node::issues).map(GetGroupFilteredBoardIssuesCommunityQuery.Issues::pageInfo).map(GetGroupFilteredBoardIssuesCommunityQuery.PageInfo::endCursor);
    }

    private static GitLabIssue convertOneGroupBoardIssueCommunity(GetGroupFilteredBoardIssuesCommunityQuery.Node1 issue, String path) {
        GitLabIssueConverter.checkNullIssue(issue);
        String updatedBy = Optional.ofNullable(issue.updatedBy()).map(GetGroupFilteredBoardIssuesCommunityQuery.UpdatedBy::username).orElse("");
        return GitLabIssue.community(issue.id(), Integer.parseInt(issue.iid()), issue.title(), issue.webUrl(), issue.projectId(), path, issue.descriptionHtml(), issue.author().username(), DateConverter.parseDateTime(issue.createdAt().toString()), updatedBy, DateConverter.parseDateTime(issue.updatedAt().toString()), GitLabIssueConverter.extractMilestoneCommunity(issue), issue.webPath(), GitLabIssueConverter.extractLabelsCommunity(issue), GitLabIssueConverter.retrieveDate(issue.dueDate()), issue.confidential(), issue.discussionLocked(), GitLabIssueConverter.extractAssigneesCommunity(issue), GitLabIssueConverter.extractNotesCommunity(issue), issue.state());
    }

    private static List<GitLabNote> extractNotesCommunity(GetGroupFilteredBoardIssuesCommunityQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetGroupFilteredBoardIssuesCommunityQuery.Node1::notes).map(GetGroupFilteredBoardIssuesCommunityQuery.Notes::nodes).map(nodes -> nodes.stream().map(node -> GitLabConverters.extractGitLabNote(node, GetGroupFilteredBoardIssuesCommunityQuery.Node4::id, GetGroupFilteredBoardIssuesCommunityQuery.Node4::body)).toList()).orElse(Collections.emptyList());
    }

    private static List<String> extractLabelsCommunity(GetGroupFilteredBoardIssuesCommunityQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetGroupFilteredBoardIssuesCommunityQuery.Node1::labels).map(GetGroupFilteredBoardIssuesCommunityQuery.Labels::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_PROJECT_BOARD_LABEL_DATA)).stream().map(GetGroupFilteredBoardIssuesCommunityQuery.Node2::title).filter(StringUtils::isNotBlank).toList();
    }

    private static GitLabMilestone extractMilestoneCommunity(GetGroupFilteredBoardIssuesCommunityQuery.Node1 issue) {
        GetGroupFilteredBoardIssuesCommunityQuery.Milestone milestone = issue.milestone();
        if (milestone != null) {
            return new GitLabMilestone(milestone.id(), milestone.title(), GitLabIssueConverter.retrieveDate(milestone.dueDate()), milestone.expired(), milestone.state());
        }
        return null;
    }

    private static List<String> extractAssigneesCommunity(GetGroupFilteredBoardIssuesCommunityQuery.Node1 issue) {
        return Optional.ofNullable(issue).map(GetGroupFilteredBoardIssuesCommunityQuery.Node1::assignees).map(GetGroupFilteredBoardIssuesCommunityQuery.Assignees::nodes).orElseThrow(() -> GitLabConverters.exception("Received invalid group board issue data for assignees")).stream().map(GetGroupFilteredBoardIssuesCommunityQuery.Node3::name).filter(StringUtils::isNotBlank).toList();
    }

    public static Optional<GitLabIssue> convertSingleIssuePremium(@Nullable GetIssueByIdQuery.Data data) {
        if (data == null) {
            return Optional.empty();
        }
        GetIssueByIdQuery.Issue issue = data.issue();
        if (issue == null) {
            return Optional.empty();
        }
        String updatedBy = Optional.ofNullable(issue.updatedBy()).map(GetIssueByIdQuery.UpdatedBy::username).orElse("");
        return Optional.of(new GitLabIssue(issue.id(), Integer.parseInt(issue.iid()), issue.title(), issue.webUrl(), issue.projectId(), "", issue.descriptionHtml(), issue.author().username(), DateConverter.parseDateTime(issue.createdAt().toString()), updatedBy, DateConverter.parseDateTime(issue.updatedAt().toString()), GitLabIssueConverter.extractMilestonePremium(issue), GitLabIssueConverter.extractIterationPremium(issue.iteration()), issue.webPath(), GitLabIssueConverter.extractLabelsPremium(issue), issue.weight(), GitLabIssueConverter.retrieveDate(issue.dueDate()), issue.confidential(), issue.discussionLocked(), GitLabIssueConverter.extractEpicTitlePremium(issue), GitLabIssueConverter.extractAssigneesPremium(issue), null, issue.state()));
    }

    private static List<String> extractLabelsPremium(GetIssueByIdQuery.Issue issue) {
        return Optional.ofNullable(issue).map(GetIssueByIdQuery.Issue::labels).map(GetIssueByIdQuery.Labels::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_GROUP_LABEL_DATA)).stream().map(GetIssueByIdQuery.Node::title).filter(StringUtils::isNotBlank).toList();
    }

    private static GitLabMilestone extractMilestonePremium(GetIssueByIdQuery.Issue issue) {
        GetIssueByIdQuery.Milestone milestone = issue.milestone();
        if (milestone != null) {
            return new GitLabMilestone(milestone.id(), milestone.title(), GitLabIssueConverter.retrieveDate(milestone.dueDate()), milestone.expired(), milestone.state());
        }
        return null;
    }

    private static IterationDto extractIterationPremium(GetIssueByIdQuery.Iteration iteration) {
        if (iteration != null) {
            return new IterationDto(iteration.id(), iteration.title(), GitLabIssueConverter.retrieveDate(iteration.startDate()), GitLabIssueConverter.retrieveDate(iteration.dueDate()), iteration.iterationCadence().title(), iteration.state());
        }
        return null;
    }

    private static String extractEpicTitlePremium(GetIssueByIdQuery.Issue issue) {
        return Optional.ofNullable(issue).map(GetIssueByIdQuery.Issue::epic).map(GetIssueByIdQuery.Epic::title).orElse("");
    }

    private static List<String> extractAssigneesPremium(GetIssueByIdQuery.Issue issue) {
        return Optional.ofNullable(issue).map(GetIssueByIdQuery.Issue::assignees).map(GetIssueByIdQuery.Assignees::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_ASSIGNEE_DATA)).stream().map(GetIssueByIdQuery.Node1::name).filter(StringUtils::isNotBlank).toList();
    }

    public static Optional<GitLabIssue> convertSingleIssueCommunity(@Nullable GetIssueCommunityByIdQuery.Data data) {
        if (data == null) {
            return Optional.empty();
        }
        GetIssueCommunityByIdQuery.Issue issue = data.issue();
        if (issue == null) {
            return Optional.empty();
        }
        String updatedBy = Optional.ofNullable(issue.updatedBy()).map(GetIssueCommunityByIdQuery.UpdatedBy::username).orElse("");
        return Optional.of(GitLabIssue.community(issue.id(), Integer.parseInt(issue.iid()), issue.title(), issue.webUrl(), issue.projectId(), "", issue.descriptionHtml(), issue.author().username(), DateConverter.parseDateTime(issue.createdAt().toString()), updatedBy, DateConverter.parseDateTime(issue.updatedAt().toString()), GitLabIssueConverter.extractMilestoneCommunity(issue), issue.webPath(), GitLabIssueConverter.extractLabelsCommunity(issue), GitLabIssueConverter.retrieveDate(issue.dueDate()), issue.confidential(), issue.discussionLocked(), GitLabIssueConverter.extractAssigneesCommunity(issue), null, issue.state()));
    }

    private static List<String> extractLabelsCommunity(GetIssueCommunityByIdQuery.Issue issue) {
        return Optional.ofNullable(issue).map(GetIssueCommunityByIdQuery.Issue::labels).map(GetIssueCommunityByIdQuery.Labels::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_GROUP_LABEL_DATA)).stream().map(GetIssueCommunityByIdQuery.Node::title).filter(StringUtils::isNotBlank).toList();
    }

    private static GitLabMilestone extractMilestoneCommunity(GetIssueCommunityByIdQuery.Issue issue) {
        GetIssueCommunityByIdQuery.Milestone milestone = issue.milestone();
        if (milestone != null) {
            return new GitLabMilestone(milestone.id(), milestone.title(), GitLabIssueConverter.retrieveDate(milestone.dueDate()), milestone.expired(), milestone.state());
        }
        return null;
    }

    private static List<String> extractAssigneesCommunity(GetIssueCommunityByIdQuery.Issue issue) {
        return Optional.ofNullable(issue).map(GetIssueCommunityByIdQuery.Issue::assignees).map(GetIssueCommunityByIdQuery.Assignees::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_ASSIGNEE_DATA)).stream().map(GetIssueCommunityByIdQuery.Node1::name).filter(StringUtils::isNotBlank).toList();
    }

    public static List<GitLabIssue> convertBoardListIssuesPremium(@Nullable GetBoardListIssuesQuery.Data data) {
        return Optional.ofNullable(data).map(GetBoardListIssuesQuery.Data::boardList).map(GetBoardListIssuesQuery.BoardList::issues).map(GetBoardListIssuesQuery.Issues::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_ISSUES_DATA)).stream().filter(Objects::nonNull).map(issue -> GitLabIssueConverter.convertOneBoardListIssuePremium(issue, null)).toList();
    }

    private static GitLabIssue convertOneBoardListIssuePremium(GetBoardListIssuesQuery.Node issue, String path) {
        GitLabIssueConverter.checkNullIssue(issue);
        String updatedBy = Optional.ofNullable(issue.updatedBy()).map(GetBoardListIssuesQuery.UpdatedBy::username).orElse("");
        return new GitLabIssue(issue.id(), Integer.parseInt(issue.iid()), issue.title(), issue.webUrl(), issue.projectId(), path, issue.descriptionHtml(), issue.author().username(), DateConverter.parseDateTime(issue.createdAt().toString()), updatedBy, DateConverter.parseDateTime(issue.updatedAt().toString()), GitLabIssueConverter.extractMilestonePremium(issue), GitLabIssueConverter.extractIterationPremium(issue.iteration()), issue.webPath(), GitLabIssueConverter.extractLabelsPremium(issue), issue.weight(), GitLabIssueConverter.retrieveDate(issue.dueDate()), issue.confidential(), issue.discussionLocked(), GitLabIssueConverter.extractEpicTitlePremium(issue), GitLabIssueConverter.extractAssigneesPremium(issue), GitLabIssueConverter.extractNotesPremium(issue), issue.state());
    }

    private static List<GitLabNote> extractNotesPremium(GetBoardListIssuesQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetBoardListIssuesQuery.Node::notes).map(GetBoardListIssuesQuery.Notes::nodes).map(nodes -> nodes.stream().map(node -> GitLabConverters.extractGitLabNote(node, GetBoardListIssuesQuery.Node3::id, GetBoardListIssuesQuery.Node3::body)).toList()).orElse(Collections.emptyList());
    }

    private static GitLabMilestone extractMilestonePremium(GetBoardListIssuesQuery.Node issue) {
        GetBoardListIssuesQuery.Milestone milestone = issue.milestone();
        if (milestone != null) {
            return new GitLabMilestone(milestone.id(), milestone.title(), GitLabIssueConverter.retrieveDate(milestone.dueDate()), milestone.expired(), milestone.state());
        }
        return null;
    }

    private static List<String> extractLabelsPremium(GetBoardListIssuesQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetBoardListIssuesQuery.Node::labels).map(GetBoardListIssuesQuery.Labels::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_LABEL_DATA)).stream().map(GetBoardListIssuesQuery.Node1::title).filter(StringUtils::isNotBlank).toList();
    }

    private static IterationDto extractIterationPremium(GetBoardListIssuesQuery.Iteration iteration) {
        if (iteration != null) {
            return new IterationDto(iteration.id(), iteration.title(), GitLabIssueConverter.retrieveDate(iteration.startDate()), GitLabIssueConverter.retrieveDate(iteration.dueDate()), iteration.iterationCadence().title(), iteration.state());
        }
        return null;
    }

    private static String extractEpicTitlePremium(GetBoardListIssuesQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetBoardListIssuesQuery.Node::epic).map(GetBoardListIssuesQuery.Epic::title).orElse("");
    }

    private static List<String> extractAssigneesPremium(GetBoardListIssuesQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetBoardListIssuesQuery.Node::assignees).map(GetBoardListIssuesQuery.Assignees::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_ASSIGNEE_DATA)).stream().map(GetBoardListIssuesQuery.Node2::name).filter(StringUtils::isNotBlank).toList();
    }

    public static List<GitLabIssue> convertBoardListIssuesCommunity(@Nullable GetBoardListIssuesCommunityQuery.Data data) {
        return Optional.ofNullable(data).map(GetBoardListIssuesCommunityQuery.Data::boardList).map(GetBoardListIssuesCommunityQuery.BoardList::issues).map(GetBoardListIssuesCommunityQuery.Issues::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_ISSUES_DATA)).stream().filter(Objects::nonNull).map(issue -> GitLabIssueConverter.convertOneBoardListIssueCommunity(issue, null)).toList();
    }

    private static GitLabIssue convertOneBoardListIssueCommunity(GetBoardListIssuesCommunityQuery.Node issue, String path) {
        GitLabIssueConverter.checkNullIssue(issue);
        String updatedBy = Optional.ofNullable(issue.updatedBy()).map(GetBoardListIssuesCommunityQuery.UpdatedBy::username).orElse("");
        return GitLabIssue.community(issue.id(), Integer.parseInt(issue.iid()), issue.title(), issue.webUrl(), issue.projectId(), path, issue.descriptionHtml(), issue.author().username(), DateConverter.parseDateTime(issue.createdAt().toString()), updatedBy, DateConverter.parseDateTime(issue.updatedAt().toString()), GitLabIssueConverter.extractMilestoneCommunity(issue), issue.webPath(), GitLabIssueConverter.extractLabelsCommunity(issue), GitLabIssueConverter.retrieveDate(issue.dueDate()), issue.confidential(), issue.discussionLocked(), GitLabIssueConverter.extractAssigneesCommunity(issue), GitLabIssueConverter.extractNotesCommunity(issue), issue.state());
    }

    private static List<GitLabNote> extractNotesCommunity(GetBoardListIssuesCommunityQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetBoardListIssuesCommunityQuery.Node::notes).map(GetBoardListIssuesCommunityQuery.Notes::nodes).map(nodes -> nodes.stream().map(node -> GitLabConverters.extractGitLabNote(node, GetBoardListIssuesCommunityQuery.Node3::id, GetBoardListIssuesCommunityQuery.Node3::body)).toList()).orElse(Collections.emptyList());
    }

    private static GitLabMilestone extractMilestoneCommunity(GetBoardListIssuesCommunityQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetBoardListIssuesCommunityQuery.Node::milestone).map(milestone -> new GitLabMilestone(milestone.id(), milestone.title(), GitLabIssueConverter.retrieveDate(milestone.dueDate()), milestone.expired(), milestone.state())).orElse(null);
    }

    private static List<String> extractLabelsCommunity(GetBoardListIssuesCommunityQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetBoardListIssuesCommunityQuery.Node::labels).map(GetBoardListIssuesCommunityQuery.Labels::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_LABEL_DATA)).stream().map(GetBoardListIssuesCommunityQuery.Node1::title).filter(StringUtils::isNotBlank).toList();
    }

    private static List<String> extractAssigneesCommunity(GetBoardListIssuesCommunityQuery.Node issue) {
        return Optional.ofNullable(issue).map(GetBoardListIssuesCommunityQuery.Node::assignees).map(GetBoardListIssuesCommunityQuery.Assignees::nodes).orElseThrow(() -> GitLabConverters.exception(ERROR_INVALID_ASSIGNEE_DATA)).stream().map(GetBoardListIssuesCommunityQuery.Node2::name).filter(StringUtils::isNotBlank).toList();
    }

    private static Date retrieveDate(Object date) {
        return date != null ? DateConverter.parseDate(date.toString()) : null;
    }

    private static void checkNullIssue(Object issueNode) {
        if (issueNode == null) {
            throw GitLabConverters.exception(ERROR_NULL_ISSUE);
        }
    }

    private GitLabIssueConverter() {
        throw new IllegalStateException("This class is not meant to be instantiated.");
    }

    public record BoardIssueNotesFirstPageResult(Map<String, List<GitLabNote>> notesByIssueId) {
    }

    public static class BoardIssuesFirstPageResult {
        public final List<GitLabIssue> gitLabIssues;
        public final Map<String, Optional<String>> endCursorByBoardListId;

        public BoardIssuesFirstPageResult(List<GitLabIssue> gitLabIssues, Map<String, Optional<String>> endCursorByBoardListId) {
            this.gitLabIssues = gitLabIssues;
            this.endCursorByBoardListId = endCursorByBoardListId;
        }
    }
}

