/*
 * Decompiled with CFR 0.152.
 */
package workflowautomjira.org.apache.http.protocol;

import java.io.IOException;
import workflowautomjira.org.apache.http.HttpException;
import workflowautomjira.org.apache.http.HttpResponse;
import workflowautomjira.org.apache.http.HttpResponseInterceptor;
import workflowautomjira.org.apache.http.annotation.Contract;
import workflowautomjira.org.apache.http.annotation.ThreadingBehavior;
import workflowautomjira.org.apache.http.protocol.HttpContext;
import workflowautomjira.org.apache.http.protocol.HttpDateGenerator;
import workflowautomjira.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

