/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.synchronisation.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.testcase.GetKindTestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.tf.automationrequest.RemoteAutomationRequestExtender;
import org.squashtest.tm.plugin.workflow.automjira.client.JiraClient;
import org.squashtest.tm.plugin.workflow.automjira.domain.SynchronizedField;
import org.squashtest.tm.plugin.workflow.automjira.domain.TestCaseToSynchronize;
import org.squashtest.tm.plugin.workflow.automjira.exception.AutomJiraException;
import org.squashtest.tm.plugin.workflow.automjira.helpers.LocaleWithFallback;
import org.squashtest.tm.plugin.workflow.automjira.repository.SynchronisationDao;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.IssueProcessingHelperService;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationSquashToJiraService;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;

@Service
public class SynchronizationSquashToJiraServiceImpl
implements SynchronizationSquashToJiraService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizationSquashToJiraServiceImpl.class);
    private final Provider<JiraClient> provider;
    private final PlatformTransactionManager transactionManager;
    private final SynchronisationDao syncDao;
    private final IssueProcessingHelperService issueProcessingHelperService;
    private final InternationalizationHelper i18nhelper;
    private final BugTrackerFinderService serverFinder;
    private final Locale locale;

    public SynchronizationSquashToJiraServiceImpl(Provider<JiraClient> provider, PlatformTransactionManager transactionManager, SynchronisationDao syncDao, IssueProcessingHelperService issueProcessingHelperService, InternationalizationHelper i18nhelper, BugTrackerFinderService serverFinder) {
        this.provider = provider;
        this.transactionManager = transactionManager;
        this.syncDao = syncDao;
        this.issueProcessingHelperService = issueProcessingHelperService;
        this.i18nhelper = i18nhelper;
        this.serverFinder = serverFinder;
        this.locale = LocaleWithFallback.getLocaleWithFallback();
    }

    @Override
    public void synchronizationSquashToJira(List<TestCaseToSynchronize> listTcToCanBeSynchronized, RemoteSynchronisation remoteSynchronisation) throws AutomJiraException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[AUTOM-JIRA-SYNC] - Begin synchronization Squash to Jira.");
        }
        TransactionStatus transaction = this.issueProcessingHelperService.createTransaction();
        try {
            try {
                List<TestCaseToSynchronize> listTestCaseToSynchronize = this.getListTestCaseModifiedSinceLastSync(listTcToCanBeSynchronized);
                Map<Long, List<TestCaseToSynchronize>> collectionTestCaseToSynchronizeGroupByIdServer = this.getTcToSynchronizeGroupByIdServer(listTestCaseToSynchronize);
                collectionTestCaseToSynchronizeGroupByIdServer.forEach(this::updateTicketJira);
                this.transactionManager.commit(transaction);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[AUTOM-JIRA-SYNC] -  Finished Synchronisation Squash to Jira with success: " + remoteSynchronisation.getId());
                }
            }
            catch (Throwable e) {
                this.transactionManager.rollback(transaction);
                String message = "[AUTOM-JIRA-SYNC] - Error while synchronizing Squash to Jira: " + remoteSynchronisation.getId();
                throw new AutomJiraException(message, e);
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[AUTOM-JIRA-SYNC] - Finished synchronization Squash to Jira.");
            }
        }
    }

    private List<TestCaseToSynchronize> getListTestCaseModifiedSinceLastSync(List<TestCaseToSynchronize> testCasesToSynchronize) throws IOException {
        ArrayList<TestCaseToSynchronize> listTestCaseModified = new ArrayList<TestCaseToSynchronize>();
        for (TestCaseToSynchronize tcToSync : testCasesToSynchronize) {
            TestCase tc = tcToSync.getTestCase();
            Date lastModifiedOn = tc.getLastModifiedOn();
            Date lastSyncDateSquash = tcToSync.getRemoteAutomationRequestExtender().getLastSyncDateSquash();
            boolean isChanged = this.summaryOrDescriptionChanged(tcToSync);
            if (lastSyncDateSquash != null && !lastModifiedOn.after(lastSyncDateSquash) && !isChanged) continue;
            listTestCaseModified.add(tcToSync);
        }
        return listTestCaseModified;
    }

    private Map<Long, List<TestCaseToSynchronize>> getTcToSynchronizeGroupByIdServer(List<TestCaseToSynchronize> listTestCaseToSynchronize) {
        return listTestCaseToSynchronize.stream().collect(Collectors.groupingBy(TestCaseToSynchronize::getServerId));
    }

    private void updateTicketJira(Long serverId, List<TestCaseToSynchronize> listTestCase) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[AUTOM-JIRA-SYNC] - " + listTestCase.size() + " tests cases to synchronize for the server " + String.valueOf(serverId));
        }
        JiraClient jiraClient = (JiraClient)this.provider.get();
        BugTracker bugtracker = this.serverFinder.findById(serverId.longValue());
        jiraClient.jiraClientAuthentication(bugtracker);
        try {
            try {
                listTestCase.forEach(tcToSync -> this.toDoUpdateTicketJira((TestCaseToSynchronize)tcToSync, serverId, jiraClient));
            }
            catch (BugTrackerNoCredentialsException ex) {
                String message = this.i18nhelper.internationalize("thirdpartyserver.admin.messages.testcreds.fail", this.locale);
                LOGGER.error(message);
                throw new AutomJiraException(message, ex);
            }
        }
        finally {
            if (jiraClient != null) {
                jiraClient.close();
            }
        }
    }

    private void toDoUpdateTicketJira(TestCaseToSynchronize tcToSync, Long serverId, JiraClient jiraClient) {
        Date dateSync = new Date();
        IssueInputBuilder builder = new IssueInputBuilder();
        try {
            RemoteAutomationRequestExtender rare;
            SynchronizedField syncField;
            Map<String, Boolean> editField;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[AUTOM-JIRA-SYNC] - synchronization jira ticket: " + tcToSync.getRemoteIssueKey());
            }
            if ((editField = this.getWhatChangeInJira(tcToSync, syncField = (SynchronizedField)new ObjectMapper().readValue((rare = this.syncDao.findRareByIssueKeyAndServerId(serverId, tcToSync.getRemoteIssueKey())).getSentValueForSync(), SynchronizedField.class))).isEmpty()) {
                return;
            }
            if (editField.get("summary") != null) {
                String summary = this.issueProcessingHelperService.buildIssueSummary(tcToSync.getTestCase());
                builder.setSummary(summary);
            }
            if (editField.get("description") != null) {
                String description = this.issueProcessingHelperService.buildIssueDescription(tcToSync.getTestCase());
                builder.setDescription(description);
            }
            jiraClient.updateIssueByKey(tcToSync.getRemoteIssueKey(), builder);
            rare.setLastSyncDate(dateSync);
            rare.setLastSyncDateSquash(dateSync);
            rare.setSentValueForSync(this.issueProcessingHelperService.getValueSentForSync(tcToSync.getTestCase()));
        }
        catch (BugTrackerNoCredentialsException ex) {
            String message = this.i18nhelper.internationalize("thirdpartyserver.admin.messages.testcreds.fail", this.locale);
            throw new BugTrackerNoCredentialsException(message, (Throwable)ex);
        }
        catch (IOException e) {
            String message = "[AUTOM-JIRA-SYNC] - Error during the deserialization of the test case to synchronize: " + String.valueOf(tcToSync.getTestCase().getId());
            throw new AutomJiraException(message, e);
        }
    }

    private Map<String, Boolean> getWhatChangeInJira(TestCaseToSynchronize tcToSync, SynchronizedField syncField) {
        HashMap<String, Boolean> editField = new HashMap<String, Boolean>();
        if (this.wasSummaryModified(syncField, tcToSync)) {
            editField.put("summary", true);
        }
        if (this.wasDescriptionModified(syncField, tcToSync)) {
            editField.put("description", true);
        }
        return editField;
    }

    private boolean summaryOrDescriptionChanged(TestCaseToSynchronize tcToSync) throws IOException {
        RemoteAutomationRequestExtender rare = tcToSync.getRemoteAutomationRequestExtender();
        SynchronizedField syncField = (SynchronizedField)new ObjectMapper().readValue(rare.getSentValueForSync(), SynchronizedField.class);
        return this.wasSummaryModified(syncField, tcToSync) || this.wasDescriptionModified(syncField, tcToSync);
    }

    private boolean wasSummaryModified(SynchronizedField syncField, TestCaseToSynchronize tcToSync) {
        boolean wasModified = true;
        TestCase testCase = tcToSync.getTestCase();
        boolean isReferenceEqual = testCase.getReference().equalsIgnoreCase(syncField.getReferenceTestCase());
        boolean isNameEqual = testCase.getName().equalsIgnoreCase(syncField.getNameTestCase());
        if (isReferenceEqual && isNameEqual) {
            String tcSummary = this.issueProcessingHelperService.buildIssueSummary(testCase);
            boolean isSummaryEqual = tcSummary.equalsIgnoreCase(tcToSync.getNewRemoteSummaryIssue());
            wasModified = !isSummaryEqual;
        }
        return wasModified;
    }

    private boolean wasDescriptionModified(SynchronizedField syncField, TestCaseToSynchronize tcToSync) {
        boolean wasModified = true;
        TestCase testCase = tcToSync.getTestCase();
        String urlToTc = this.issueProcessingHelperService.getUrlToTestCase(testCase);
        GetKindTestCaseVisitor kindVisitor = new GetKindTestCaseVisitor();
        testCase.accept((TestCaseVisitor)kindVisitor);
        String fullPathSharingServer = TestCaseKind.STANDARD.equals((Object)kindVisitor.getKind()) ? "" : this.issueProcessingHelperService.getFullPathSharingServer(testCase);
        String scriptTA = this.issueProcessingHelperService.getPathScriptTA(testCase.getAutomatedTest());
        String priority = this.issueProcessingHelperService.getTestCasePriority(testCase);
        if (urlToTc.equalsIgnoreCase(syncField.getUrlTestCase()) && fullPathSharingServer.equalsIgnoreCase(syncField.getPathSharingServerTestCase()) && scriptTA.equalsIgnoreCase(syncField.getScriptTaTestCase()) && priority.equalsIgnoreCase(syncField.getPrioriteTestCase())) {
            String tcDescription = this.issueProcessingHelperService.buildIssueDescription(testCase);
            boolean isDescriptionEqual = tcDescription.equalsIgnoreCase(tcToSync.getNewRemoteDescriptionIssue());
            wasModified = !isDescriptionEqual;
        }
        return wasModified;
    }
}

