/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.synchronisation.service;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.synchronisation.SynchronisationStatus;
import org.squashtest.tm.domain.tf.automationrequest.RemoteAutomationRequestExtender;
import org.squashtest.tm.plugin.workflow.automjira.client.JiraClient;
import org.squashtest.tm.plugin.workflow.automjira.domain.TestCaseToSynchronize;
import org.squashtest.tm.plugin.workflow.automjira.exception.AutomJiraException;
import org.squashtest.tm.plugin.workflow.automjira.helpers.LocaleWithFallback;
import org.squashtest.tm.plugin.workflow.automjira.repository.SynchronisationDao;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationHelperService;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationJiraToSquashService;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationService;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationSquashToJiraService;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Issue;

@Service
@Transactional
public class SynchronizationServiceImpl
implements SynchronizationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizationServiceImpl.class);
    private static final String AUTOM_JIRA_WORKFLOW = "automjira.workflow";
    @Value(value="${logging.dir}")
    private String logsFolderPath;
    private final SynchronizationSquashToJiraService syncSquashToJira;
    private final SynchronizationJiraToSquashService syncJiraToSquash;
    private final SynchronisationDao syncDao;
    private final Provider<JiraClient> provider;
    private final BugTrackerFinderService serverFinder;
    private final InternationalizationHelper i18nHelper;
    private final SynchronizationHelperService synchronizationHelperService;
    private final Environment environment;
    private final Locale locale;

    public SynchronizationServiceImpl(SynchronizationSquashToJiraService syncSquashToJira, SynchronizationJiraToSquashService syncJiraToSquash, SynchronisationDao syncDao, Provider<JiraClient> provider, BugTrackerFinderService serverFinder, InternationalizationHelper i18nHelper, SynchronizationHelperService synchronizationHelperService, Environment environment) {
        this.syncSquashToJira = syncSquashToJira;
        this.syncJiraToSquash = syncJiraToSquash;
        this.syncDao = syncDao;
        this.provider = provider;
        this.serverFinder = serverFinder;
        this.i18nHelper = i18nHelper;
        this.synchronizationHelperService = synchronizationHelperService;
        this.environment = environment;
        this.locale = LocaleWithFallback.getLocaleWithFallback();
    }

    @PostConstruct
    public void checkLoggingFilePath() {
        String loggingFilePath = this.environment.getProperty("logging.file.path");
        if (loggingFilePath != null) {
            LOGGER.warn("Workflow Automatisation Jira plugin : logging.file.path is no longer supported. Current value is the one defined in logging.dir");
        }
    }

    @Override
    public void performCronAuthentication() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[AUTOM-JIRA-SYNC] - Performing cron internal authentication");
        }
        SecurityContextHolder.clearContext();
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
        AnonymousAuthenticationToken authentication = new AnonymousAuthenticationToken(AUTOM_JIRA_WORKFLOW, (Object)AUTOM_JIRA_WORKFLOW, authorities);
        SecurityContext context = SecurityContextHolder.getContext();
        context.setAuthentication((Authentication)authentication);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[AUTOM-JIRA-SYNC] - authentication: {}", (Object)context.getAuthentication().isAuthenticated());
            LOGGER.debug("[AUTOM-JIRA-SYNC] - Done cron internal authentication as automjira.workflow");
        }
    }

    @Override
    public void startSynchronization(RemoteSynchronisation remoteSynchronisation) {
        Date newSyncDate = new Date();
        Project project = remoteSynchronisation.getProject();
        SynchronisationStatus finalStatus = SynchronisationStatus.FAILURE;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[AUTOM-JIRA-SYNC] - Begin synchronization for RemoteSynchronisation {} and Server {} ({}) ", new Object[]{remoteSynchronisation.getId(), remoteSynchronisation.getServer().getName(), remoteSynchronisation.getServer().getId()});
        }
        try {
            try {
                this.synchronizationHelperService.logSyncStarted(remoteSynchronisation.getId(), newSyncDate);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[AUTOM-JIRA-SYNC] - Verification of tickets before synchronization id" + remoteSynchronisation.getId());
                }
                List<TestCaseToSynchronize> listTcToCanBeSynchronized = this.findListTestCaseCanBeSynchronized(remoteSynchronisation);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[AUTOM-JIRA-SYNC] - Synchronization Jira to Squash TM");
                }
                this.syncJiraToSquash.synchronizationJiraToSquash(listTcToCanBeSynchronized, remoteSynchronisation);
                this.syncSquashToJira.synchronizationSquashToJira(listTcToCanBeSynchronized, remoteSynchronisation);
                finalStatus = SynchronisationStatus.SUCCESS;
            }
            catch (AutomJiraException e) {
                finalStatus = SynchronisationStatus.FAILURE;
                LOGGER.error("[AUTOM-JIRA-SYNC] - Project id: {} name: {} - Synchronisation id: {} name: {} - Server id: {} name: {} -  Error while processing remoteSynchronisation.", new Object[]{project.getId(), project.getName(), remoteSynchronisation.getId(), remoteSynchronisation.getName(), remoteSynchronisation.getServer().getId(), e});
                this.createLogFile(e, remoteSynchronisation.getId());
                this.synchronizationHelperService.logFinalStatus(remoteSynchronisation.getId(), finalStatus, newSyncDate);
            }
        }
        finally {
            this.synchronizationHelperService.logFinalStatus(remoteSynchronisation.getId(), finalStatus, newSyncDate);
        }
    }

    private void createLogFile(Throwable ex, Long remoteSynchronisationId) {
        File logFolder = new File(this.getPluginLogFolderPath());
        if (!logFolder.exists()) {
            logFolder.mkdirs();
        }
        String logFilePath = this.getSyncErrorLogPath(remoteSynchronisationId);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PrintWriter pw = new PrintWriter(logFilePath);){
                ex.printStackTrace(pw);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not generate error log file for synchronisation: (%s)".formatted(remoteSynchronisationId), (Throwable)e);
        }
    }

    private String getPluginLogFolderPath() {
        return this.logsFolderPath + "/automJira";
    }

    @Override
    public String getSyncErrorLogPath(Long syncId) {
        return "%s/%s-sync-%s-error.log".formatted(this.getPluginLogFolderPath(), "automJira", syncId.toString());
    }

    @Override
    public void performFullSynchronization() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[AUTOM-JIRA-SYNC] - Begin full Synchronisation.");
        }
        this.performCronAuthentication();
        try {
            List<Long> listSynchronizationIds = this.syncDao.findSynchronizationIds("henix.plugin.automation.workflow.automjira");
            List<RemoteSynchronisation> listRemoteSynchronization = this.syncDao.getListRemoteSynchronization(listSynchronizationIds);
            listRemoteSynchronization.forEach(this::startSynchronization);
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    private List<TestCaseToSynchronize> findListTestCaseCanBeSynchronized(RemoteSynchronisation remoteSynchronisation) {
        List<TestCaseToSynchronize> listTestCaseToSynchronize = null;
        try (JiraClient jiraClient = (JiraClient)this.provider.get();){
            try {
                Long serverId = remoteSynchronisation.getServer().getId();
                BugTracker bugtracker = this.serverFinder.findById(serverId.longValue());
                jiraClient.jiraClientAuthentication(bugtracker);
                List<Issue> listIssueKeyJira = jiraClient.listIssuesUpdateOnJira(remoteSynchronisation);
                List<RemoteAutomationRequestExtender> listRareByProjectId = this.syncDao.findListRareByProjectId(remoteSynchronisation.getProject().getId());
                listTestCaseToSynchronize = this.synchronizationHelperService.getListTestCaseCanBeSynchronized(listIssueKeyJira, listRareByProjectId);
            }
            catch (NoSuchElementException | BugTrackerNoCredentialsException ex) {
                String message = this.i18nHelper.internationalize("thirdpartyserver.admin.messages.testcreds.fail", this.locale);
                LOGGER.error(message);
                throw new AutomJiraException(message, ex);
            }
        }
        return listTestCaseToSynchronize;
    }
}

