/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.helpers;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.BasicComponent;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.BasicPriority;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.BasicProject;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Version;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import workflowautomjira.org.codehaus.jettison.json.JSONArray;
import workflowautomjira.org.codehaus.jettison.json.JSONException;
import workflowautomjira.org.codehaus.jettison.json.JSONObject;

@Service
public class ConvertValue {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConvertValue.class);
    @Inject
    private InternationalizationHelper i18nhelper;

    public FieldValue createFieldValue(String itemType, Object aValue) throws JSONException {
        FieldValue newValue;
        block27: {
            newValue = new FieldValue();
            newValue.setTypename(itemType);
            if (itemType == null) break block27;
            switch (itemType) {
                case "option": {
                    newValue = this.createOptionValue(aValue);
                    break;
                }
                case "JSONObject": {
                    newValue = this.castAsJSONObject(aValue);
                    break;
                }
                case "option-with-child": {
                    newValue = this.createOptionWithChild(aValue);
                    break;
                }
                case "project": {
                    newValue = this.castAsBasicProject(aValue);
                    break;
                }
                case "version": 
                case "multiversion": {
                    newValue = this.castAsBasicVersion(aValue);
                    break;
                }
                case "component": {
                    newValue = this.castAsComponent(aValue);
                    break;
                }
                case "priority": {
                    newValue = this.castAsBasicPriority(aValue);
                    break;
                }
                default: {
                    ConvertValue.warnItemTypenameIsNotHandled(itemType);
                }
            }
        }
        return newValue;
    }

    private static void warnItemTypenameIsNotHandled(String itemType) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Field value typename '%s' is not handled.".formatted(itemType));
        }
    }

    public String convertDatetimeToISOFormat(String value) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm:ss");
        DateTime dt = formatter.parseDateTime(value);
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        String date = fmt.print((ReadableInstant)dt);
        String first = date.substring(0, date.lastIndexOf(":"));
        String second = date.substring(date.lastIndexOf(":") + 1);
        return first + second;
    }

    public String convertDateToISOFormat(String value) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
        DateTime dt = formatter.parseDateTime(value);
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        String date = fmt.print((ReadableInstant)dt);
        String first = date.substring(0, date.lastIndexOf(":"));
        String second = date.substring(date.lastIndexOf(":") + 1);
        return first + second;
    }

    public List<String> extractStringListFromFieldValue(String value) {
        String[] values = value.split(" ");
        ArrayList<String> stringList = new ArrayList<String>();
        int i = 0;
        while (i < values.length) {
            stringList.add(values[i]);
            ++i;
        }
        return stringList;
    }

    public Map<String, Object> convertValueToKeyAttribute(String value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", value);
        return map;
    }

    public Map<String, Object> convertValueToIdAttribute(String value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", value);
        return map;
    }

    public List<ComplexIssueInputFieldValue> convertValueToIdList(String value) {
        ArrayList<ComplexIssueInputFieldValue> valueList = new ArrayList<ComplexIssueInputFieldValue>();
        String[] values = value.split(",");
        int i = 0;
        while (i < values.length) {
            String v = values[i];
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", v);
            valueList.add(new ComplexIssueInputFieldValue(map));
            ++i;
        }
        return valueList;
    }

    private ComplexIssueInputFieldValue buildHierarchy(List<String> valueList, int currentIndex) {
        HashMap<String, Object> element = new HashMap<String, Object>();
        if (currentIndex == valueList.size() - 1) {
            element.put("value", valueList.get(currentIndex));
        } else {
            element.put("value", valueList.get(currentIndex));
            element.put("child", this.buildHierarchy(valueList, currentIndex + 1));
        }
        return new ComplexIssueInputFieldValue(element);
    }

    public ComplexIssueInputFieldValue convertValueToAttributeHierarchy(String value) {
        String nonValue = this.i18nhelper.internationalize("label.none", this.getLocale());
        String[] values = value.split(",");
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < values.length) {
            String valueName = values[i].trim();
            if (!valueName.equals("") && !valueName.equals(nonValue)) {
                valueList.add(valueName);
            }
            ++i;
        }
        return this.buildHierarchy(valueList, 0);
    }

    public Map<String, Object> convertValueToNameAttribute(String value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", value);
        return map;
    }

    public List<ComplexIssueInputFieldValue> convertValueToNameList(String value) {
        ArrayList<ComplexIssueInputFieldValue> valueList = new ArrayList<ComplexIssueInputFieldValue>();
        String[] values = value.split(",");
        int i = 0;
        while (i < values.length) {
            String v = values[i];
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", v);
            valueList.add(new ComplexIssueInputFieldValue(map));
            ++i;
        }
        return valueList;
    }

    private FieldValue castAsJSONObject(Object aValue) throws JSONException {
        FieldValue value = new FieldValue();
        JSONObject jsonObject = (JSONObject)aValue;
        Iterator keys = jsonObject.keys();
        ArrayList<FieldValue> composite = new ArrayList<FieldValue>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            composite.add(this.createFieldValue("", jsonObject.opt(key)));
        }
        value.setId("jsonObject");
        value.setComposite(composite.toArray(new FieldValue[composite.size()]));
        return value;
    }

    private FieldValue createOptionValue(Object optValue) {
        JSONObject json = (JSONObject)optValue;
        String id = json.optString("id");
        String strVal = json.optString("value");
        FieldValue value = new FieldValue();
        value.setId(id);
        value.setTypename("option");
        value.setScalar(strVal);
        return value;
    }

    private FieldValue createOptionValueEmpty() {
        String id = String.valueOf(0);
        String strVal = this.i18nhelper.internationalize("label.none", this.getLocale());
        FieldValue value = new FieldValue();
        value.setId(id);
        value.setTypename("option");
        value.setScalar(strVal);
        return value;
    }

    private FieldValue createOptionWithChild(Object optValue) throws JSONException {
        JSONObject json = (JSONObject)optValue;
        JSONArray listChild = new JSONArray();
        if (!json.isNull("children")) {
            listChild = json.getJSONArray("children");
        }
        String id = json.optString("id");
        String strVal = json.optString("value");
        ArrayList<FieldValue> values = new ArrayList<FieldValue>();
        JSONObject childOpt = json.optJSONObject("child");
        if (childOpt != null) {
            childVal = this.createOptionValue(childOpt);
            values.add(childVal);
        } else if (listChild.length() == 0) {
            childVal = this.createOptionValueEmpty();
            values.add(childVal);
        }
        JSONArray childrenOpts = json.optJSONArray("children");
        if (childrenOpts != null) {
            int i = 0;
            while (i < childrenOpts.length()) {
                JSONObject chopt = childrenOpts.optJSONObject(i);
                if (chopt != null) {
                    FieldValue chval = this.createOptionValue(chopt);
                    values.add(chval);
                }
                ++i;
            }
        }
        FieldValue fieldvalue = new FieldValue();
        fieldvalue.setId(id);
        fieldvalue.setTypename("option-with-child");
        fieldvalue.setScalar(strVal);
        fieldvalue.setComposite(values.toArray(new FieldValue[values.size()]));
        return fieldvalue;
    }

    private FieldValue castAsBasicProject(Object project) {
        BasicProject basicProject = (BasicProject)project;
        String id = basicProject.getKey();
        String name = basicProject.getName();
        return new FieldValue(id, name);
    }

    private FieldValue castAsBasicVersion(Object version) {
        Version basicVersion = (Version)version;
        String id = basicVersion.getId().toString();
        String name = basicVersion.getName();
        return new FieldValue(id, name);
    }

    FieldValue castAsComponent(Object comp) {
        BasicComponent component = (BasicComponent)comp;
        String id = component.getId().toString();
        String name = component.getName();
        return new FieldValue(id, name);
    }

    FieldValue castAsBasicPriority(Object priority) {
        BasicPriority basicPriority = (BasicPriority)priority;
        String id = basicPriority.getId().toString();
        String name = basicPriority.getName();
        return new FieldValue(id, name);
    }

    private Locale getLocale() {
        return LocaleContextHolder.getLocaleContext().getLocale();
    }
}

