/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.com.atlassian.jira.rest.client.internal.json;

import java.net.URI;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Comment;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Visibility;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jiracloud.com.atlassian.jira.rest.client.internal.json.VisibilityJsonParser;
import jiracloud.org.codehaus.jettison.json.JSONException;
import jiracloud.org.codehaus.jettison.json.JSONObject;

public class CommentJsonParser
implements JsonObjectParser<Comment> {
    public static final String VISIBILITY_KEY = "visibility";
    private final VisibilityJsonParser visibilityJsonParser = new VisibilityJsonParser();

    @Override
    public Comment parse(JSONObject json) throws JSONException {
        URI selfUri = JsonParseUtil.getSelfUri(json);
        Long id = JsonParseUtil.getOptionalLong(json, "id");
        String body = json.getString("body");
        BasicUser author = JsonParseUtil.parseBasicUser(json.optJSONObject("author"));
        BasicUser updateAuthor = JsonParseUtil.parseBasicUser(json.optJSONObject("updateAuthor"));
        Visibility visibility = this.visibilityJsonParser.parseVisibility(json);
        return new Comment(selfUri, body, author, updateAuthor, JsonParseUtil.parseDateTime(json.getString("created")), JsonParseUtil.parseDateTime(json.getString("updated")), visibility, id);
    }
}

