/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jirarest.internal.json;

import java.net.URI;
import jirarest.com.atlassian.jira.rest.client.api.domain.LoginInfo;
import jirarest.com.atlassian.jira.rest.client.api.domain.Session;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirarest.com.atlassian.jira.rest.client.internal.json.LoginInfoJsonParser;
import jirarest.org.codehaus.jettison.json.JSONException;
import jirarest.org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionJsonParser
implements JsonObjectParser<Session> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionJsonParser.class);
    private final LoginInfoJsonParser loginInfoJsonParser = new LoginInfoJsonParser();

    @Override
    public Session parse(JSONObject json) throws JSONException {
        LoginInfo loginInfo;
        URI userUri = JsonParseUtil.getSelfUri(json);
        String username = json.getString("name");
        try {
            loginInfo = this.loginInfoJsonParser.parse(json.getJSONObject("loginInfo"));
        }
        catch (JSONException jSONException) {
            LOGGER.debug("loginInfo from Session is not returned anymore in Jira Cloud, a default value will be created");
            loginInfo = new LoginInfo(0, 0, null, null);
        }
        return new Session(userUri, username, loginInfo);
    }
}

