/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.jira.rest.client.internal.json;

import java.net.URI;
import jirarest.com.atlassian.jira.rest.client.api.domain.IssueType;
import jirarest.com.atlassian.jira.rest.client.api.domain.Status;
import jirarest.com.atlassian.jira.rest.client.api.domain.Subtask;
import jirarest.com.atlassian.jira.rest.client.internal.json.IssueTypeJsonParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirarest.com.atlassian.jira.rest.client.internal.json.StatusJsonParser;
import jirarest.org.codehaus.jettison.json.JSONException;
import jirarest.org.codehaus.jettison.json.JSONObject;

public class SubtaskJsonParser
implements JsonObjectParser<Subtask> {
    private final IssueTypeJsonParser issueTypeJsonParser = new IssueTypeJsonParser();
    private final StatusJsonParser statusJsonParser = new StatusJsonParser();

    @Override
    public Subtask parse(JSONObject json) throws JSONException {
        URI issueUri = JsonParseUtil.parseURI(json.getString("self"));
        String issueKey = json.getString("key");
        JSONObject fields = json.getJSONObject("fields");
        String summary = fields.getString("summary");
        Status status = this.statusJsonParser.parse(fields.getJSONObject("status"));
        IssueType issueType = this.issueTypeJsonParser.parse(fields.getJSONObject("issuetype"));
        return new Subtask(issueKey, issueUri, summary, issueType, status);
    }
}

